/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.dsl.embedded.impl;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.TimeZone;
import org.hibernate.search.exception.SearchException;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.Index;
import org.infinispan.objectfilter.ParsingException;
import org.infinispan.objectfilter.impl.syntax.parser.IckleParser;
import org.infinispan.objectfilter.impl.syntax.parser.IckleParsingResult;
import org.infinispan.objectfilter.impl.syntax.parser.ObjectPropertyHelper;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.embedded.DslSCI;
import org.infinispan.query.dsl.embedded.impl.EmbeddedLuceneQuery;
import org.infinispan.query.dsl.embedded.impl.QueryEngine;
import org.infinispan.query.dsl.embedded.impl.model.TheEntity;
import org.infinispan.query.dsl.embedded.testdomain.Author;
import org.infinispan.query.dsl.embedded.testdomain.Book;
import org.infinispan.query.dsl.embedded.testdomain.NotIndexed;
import org.infinispan.query.dsl.embedded.testdomain.User;
import org.infinispan.query.dsl.embedded.testdomain.hsearch.AccountHS;
import org.infinispan.query.dsl.embedded.testdomain.hsearch.AddressHS;
import org.infinispan.query.dsl.embedded.testdomain.hsearch.TransactionHS;
import org.infinispan.query.dsl.embedded.testdomain.hsearch.UserHS;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.fwk.CleanupAfterTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.TransactionMode;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.dsl.embedded.impl.EmbeddedQueryEngineTest")
@CleanupAfterTest
public class EmbeddedQueryEngineTest
extends MultipleCacheManagersTest {
    private final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private QueryEngine<Class<?>> qe;

    public EmbeddedQueryEngineTest() {
        this.DATE_FORMAT.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    private Date makeDate(String dateStr) throws ParseException {
        return this.DATE_FORMAT.parse(dateStr);
    }

    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder cfg = TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)true);
        cfg.transaction().transactionMode(TransactionMode.TRANSACTIONAL).indexing().index(Index.ALL).addIndexedEntity(UserHS.class).addIndexedEntity(AccountHS.class).addIndexedEntity(TransactionHS.class).addIndexedEntity(TheEntity.class).addIndexedEntity(Book.class).addProperty("default.directory_provider", "local-heap").addProperty("lucene_version", "LUCENE_CURRENT");
        this.createClusteredCaches(1, DslSCI.INSTANCE, cfg);
    }

    @BeforeClass(alwaysRun=true)
    protected void init() throws Exception {
        this.qe = new QueryEngine(this.cache(0).getAdvancedCache(), true);
        UserHS user1 = new UserHS();
        user1.setId(1);
        user1.setName("John");
        user1.setSurname("Doe");
        user1.setGender(User.Gender.MALE);
        user1.setAge(22);
        user1.setAccountIds(new HashSet<Integer>(Arrays.asList(1, 2)));
        user1.setNotes("Lorem ipsum dolor sit amet");
        AddressHS address1 = new AddressHS();
        address1.setStreet("Main Street");
        address1.setPostCode("X1234");
        user1.setAddresses(Collections.singletonList(address1));
        UserHS user2 = new UserHS();
        user2.setId(2);
        user2.setName("Spider");
        user2.setSurname("Man");
        user2.setGender(User.Gender.MALE);
        user2.setAge(44);
        user2.setAccountIds(Collections.singleton(3));
        AddressHS address2 = new AddressHS();
        address2.setStreet("Old Street");
        address2.setPostCode("Y12");
        AddressHS address3 = new AddressHS();
        address3.setStreet("Bond Street");
        address3.setPostCode("ZZ");
        user2.setAddresses(Arrays.asList(address2, address3));
        UserHS user3 = new UserHS();
        user3.setId(3);
        user3.setName("Spider");
        user3.setSurname("Woman");
        user3.setGender(User.Gender.FEMALE);
        user3.setAccountIds(Collections.emptySet());
        AccountHS account1 = new AccountHS();
        account1.setId(1);
        account1.setDescription("John Doe's first bank account");
        account1.setCreationDate(this.makeDate("2013-01-03"));
        AccountHS account2 = new AccountHS();
        account2.setId(2);
        account2.setDescription("John Doe's second bank account");
        account2.setCreationDate(this.makeDate("2013-01-04"));
        AccountHS account3 = new AccountHS();
        account3.setId(3);
        account3.setCreationDate(this.makeDate("2013-01-20"));
        TransactionHS transaction0 = new TransactionHS();
        transaction0.setId(0);
        transaction0.setDescription("Birthday present");
        transaction0.setAccountId(1);
        transaction0.setAmount(1800.0);
        transaction0.setDate(this.makeDate("2012-09-07"));
        transaction0.setDebit(false);
        transaction0.setValid(true);
        TransactionHS transaction1 = new TransactionHS();
        transaction1.setId(1);
        transaction1.setDescription("Feb. rent payment");
        transaction1.setAccountId(1);
        transaction1.setAmount(1500.0);
        transaction1.setDate(this.makeDate("2013-01-05"));
        transaction1.setDebit(true);
        transaction1.setValid(true);
        TransactionHS transaction2 = new TransactionHS();
        transaction2.setId(2);
        transaction2.setDescription("Starbucks");
        transaction2.setAccountId(1);
        transaction2.setAmount(23.0);
        transaction2.setDate(this.makeDate("2013-01-09"));
        transaction2.setDebit(true);
        transaction2.setValid(true);
        TransactionHS transaction3 = new TransactionHS();
        transaction3.setId(3);
        transaction3.setDescription("Hotel");
        transaction3.setAccountId(2);
        transaction3.setAmount(45.0);
        transaction3.setDate(this.makeDate("2013-02-27"));
        transaction3.setDebit(true);
        transaction3.setValid(true);
        TransactionHS transaction4 = new TransactionHS();
        transaction4.setId(4);
        transaction4.setDescription("Last january");
        transaction4.setAccountId(2);
        transaction4.setAmount(95.0);
        transaction4.setDate(this.makeDate("2013-01-31"));
        transaction4.setDebit(true);
        transaction4.setValid(true);
        TransactionHS transaction5 = new TransactionHS();
        transaction5.setId(5);
        transaction5.setDescription("Popcorn");
        transaction5.setAccountId(2);
        transaction5.setAmount(5.0);
        transaction5.setDate(this.makeDate("2013-01-01"));
        transaction5.setDebit(true);
        transaction5.setValid(true);
        this.cache(0).put((Object)("user_" + user1.getId()), (Object)user1);
        this.cache(0).put((Object)("user_" + user2.getId()), (Object)user2);
        this.cache(0).put((Object)("user_" + user3.getId()), (Object)user3);
        this.cache(0).put((Object)("account_" + account1.getId()), (Object)account1);
        this.cache(0).put((Object)("account_" + account2.getId()), (Object)account2);
        this.cache(0).put((Object)("account_" + account3.getId()), (Object)account3);
        this.cache(0).put((Object)("transaction_" + transaction0.getId()), (Object)transaction0);
        this.cache(0).put((Object)("transaction_" + transaction1.getId()), (Object)transaction1);
        this.cache(0).put((Object)("transaction_" + transaction2.getId()), (Object)transaction2);
        this.cache(0).put((Object)("transaction_" + transaction3.getId()), (Object)transaction3);
        this.cache(0).put((Object)("transaction_" + transaction4.getId()), (Object)transaction4);
        this.cache(0).put((Object)("transaction_" + transaction5.getId()), (Object)transaction5);
        for (int i = 0; i < 50; ++i) {
            TransactionHS transaction = new TransactionHS();
            transaction.setId(50 + i);
            transaction.setDescription("Expensive shoes " + i);
            transaction.setAccountId(2);
            transaction.setAmount(100 + i);
            transaction.setDate(this.makeDate("2013-08-20"));
            transaction.setDebit(true);
            transaction.setValid(true);
            this.cache(0).put((Object)("transaction_" + transaction.getId()), (Object)transaction);
        }
        this.cache(0).put((Object)"dummy", (Object)"a primitive value cannot be queried");
        this.cache(0).put((Object)"notIndexed1", (Object)new NotIndexed("testing 123"));
        this.cache(0).put((Object)"notIndexed2", (Object)new NotIndexed("xyz"));
        this.cache(0).put((Object)"entity1", (Object)new TheEntity("test value 1", new TheEntity.TheEmbeddedEntity("test embedded value 1")));
        this.cache(0).put((Object)"entity2", (Object)new TheEntity("test value 2", new TheEntity.TheEmbeddedEntity("test embedded value 2")));
        this.cache(0).put((Object)"book1", (Object)new Book("Java Performance: The Definitive Guide", "O'Reilly Media", new Author("Scott", "Oaks"), "Still, it turns out that every day, I think about GC performance, or the\nperformance of the JVM compiler, or how to get the best performance from Java Enterprise Edition APIs."));
        this.cache(0).put((Object)"book2", (Object)new Book("Functional Programming for Java Developers", "O'Reilly Media", new Author("Dean", "Wampler"), "Why should a Java developer learn about functional programming (FP)? After all, hasn\u2019t\nfunctional programming been safely hidden in academia for decades? Isn\u2019t object-\noriented programming (OOP) all we really need?"));
        this.cache(0).put((Object)"book3", (Object)new Book("The Java \u00ae Virtual Machine Specification Java SE 8 Edition", "Oracle", new Author("Tim", "Lindholm"), "The Java SE 8 Edition of The Java Virtual Machine Specification incorporates all the changes that have been made to the Java Virtual Machine since the Java SE 7 Edition in 2011. In addition, numerous corrections and clarifications have been made to align with popular implementations of the Java Virtual Machine."));
    }

    protected void clearContent() {
    }

    private Query buildQuery(String queryString) {
        return this.qe.buildQuery(null, this.qe.parse(queryString), null, -1L, -1);
    }

    public void testSimpleProjection1() {
        IckleParsingResult parsingResult = IckleParser.parse((String)"select b.author.name from org.infinispan.query.dsl.embedded.testdomain.Book b", (ObjectPropertyHelper)this.qe.getPropertyHelper());
        CacheQuery q = this.qe.buildLuceneQuery(parsingResult, null, -1L, -1);
        List list = q.list();
        AssertJUnit.assertEquals((int)3, (int)list.size());
    }

    @Test(enabled=false, description="Disabled due to https://issues.jboss.org/browse/ISPN-8564")
    public void testSimpleProjection2() {
        IckleParsingResult parsingResult = IckleParser.parse((String)"select author.name from org.infinispan.query.dsl.embedded.testdomain.Book", (ObjectPropertyHelper)this.qe.getPropertyHelper());
        CacheQuery q = this.qe.buildLuceneQuery(parsingResult, null, -1L, -1);
        List list = q.list();
        AssertJUnit.assertEquals((int)3, (int)list.size());
    }

    public void testGrouping() {
        Query q = this.buildQuery("select name from org.infinispan.query.dsl.embedded.testdomain.hsearch.UserHS where surname is not null group by name having name >= 'A'");
        List list = q.list();
        AssertJUnit.assertEquals((int)2, (int)list.size());
    }

    public void testNoGroupingOrAggregation() {
        Query q = this.buildQuery("from org.infinispan.query.dsl.embedded.testdomain.hsearch.UserHS");
        AssertJUnit.assertTrue((boolean)(q instanceof EmbeddedLuceneQuery));
        List list = q.list();
        AssertJUnit.assertEquals((int)3, (int)list.size());
    }

    @Test(expectedExceptions={ParsingException.class}, expectedExceptionsMessageRegExp="ISPN028516: Cannot have aggregate functions in the GROUP BY clause : SUM.")
    public void testDisallowAggregationInGroupBy() {
        Query q = this.buildQuery("select sum(age) from org.infinispan.query.dsl.embedded.testdomain.hsearch.UserHS group by sum(age) ");
        q.list();
    }

    public void testDuplicatesAcceptedInGroupBy() {
        Query q = this.buildQuery("select name from org.infinispan.query.dsl.embedded.testdomain.hsearch.UserHS group by name, name");
        List list = q.list();
        AssertJUnit.assertEquals((int)2, (int)list.size());
        AssertJUnit.assertEquals((int)1, (int)((Object[])list.get(0)).length);
        AssertJUnit.assertEquals((int)1, (int)((Object[])list.get(1)).length);
    }

    public void testDuplicatesAcceptedInSelect1() {
        Query q = this.buildQuery("select name, name from org.infinispan.query.dsl.embedded.testdomain.hsearch.UserHS group by name");
        List list = q.list();
        AssertJUnit.assertEquals((int)2, (int)list.size());
        AssertJUnit.assertEquals((int)2, (int)((Object[])list.get(0)).length);
        AssertJUnit.assertEquals((int)2, (int)((Object[])list.get(1)).length);
    }

    public void testDuplicatesAcceptedInSelect2() {
        Query q = this.buildQuery("select max(name), max(name) from org.infinispan.query.dsl.embedded.testdomain.hsearch.UserHS");
        List list = q.list();
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertEquals((int)2, (int)((Object[])list.get(0)).length);
    }

    public void testDuplicatesAcceptedInSelect3() {
        Query q = this.buildQuery("select min(name), max(name) from org.infinispan.query.dsl.embedded.testdomain.hsearch.UserHS");
        List list = q.list();
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertEquals((int)2, (int)((Object[])list.get(0)).length);
    }

    public void testDuplicatesAcceptedInOrderBy1() {
        Query q = this.buildQuery("from org.infinispan.query.dsl.embedded.testdomain.hsearch.UserHS order by age, age");
        List list = q.list();
        AssertJUnit.assertEquals((int)3, (int)list.size());
    }

    public void testDuplicatesAcceptedInOrderBy2() {
        Query q = this.buildQuery("from org.infinispan.query.dsl.embedded.testdomain.hsearch.UserHS order by age, name, age");
        List list = q.list();
        AssertJUnit.assertEquals((int)3, (int)list.size());
    }

    @Test(expectedExceptions={ParsingException.class}, expectedExceptionsMessageRegExp="ISPN014024: The property path 'addresses.postCode' cannot be used in the ORDER BY clause because it is multi-valued")
    public void testRejectMultivaluedOrderBy() {
        Query q = this.buildQuery("from org.infinispan.query.dsl.embedded.testdomain.hsearch.UserHS u order by u.addresses.postCode");
        q.list();
    }

    @Test(expectedExceptions={ParsingException.class}, expectedExceptionsMessageRegExp="ISPN014023: Using the multi-valued property path 'addresses.postCode' in the GROUP BY clause is not currently supported")
    public void testRejectMultivaluedGroupBy() {
        Query q = this.buildQuery("select u.addresses.postCode from org.infinispan.query.dsl.embedded.testdomain.hsearch.UserHS u group by u.addresses.postCode");
        q.list();
    }

    @Test(expectedExceptions={ParsingException.class}, expectedExceptionsMessageRegExp="ISPN014026: The expression 'age' must be part of an aggregate function or it should be included in the GROUP BY clause")
    public void testMissingAggregateInSelect() {
        Query q = this.buildQuery("select age from org.infinispan.query.dsl.embedded.testdomain.hsearch.UserHS group by name");
        q.list();
    }

    @Test(expectedExceptions={ParsingException.class}, expectedExceptionsMessageRegExp="ISPN014026: The expression 'age' must be part of an aggregate function or it should be included in the GROUP BY clause")
    public void testMissingAggregateInOrderBy() {
        Query q = this.buildQuery("select name, sum(age) from org.infinispan.query.dsl.embedded.testdomain.hsearch.UserHS group by name order by age");
        q.list();
    }

    @Test(expectedExceptions={ParsingException.class}, expectedExceptionsMessageRegExp="ISPN028515: Cannot have aggregate functions in the WHERE clause : SUM.")
    public void testDisallowAggregatesInWhereClause() {
        Query q = this.buildQuery("select name from org.infinispan.query.dsl.embedded.testdomain.hsearch.UserHS where sum(age) > 33 group by name");
        q.list();
    }

    @Test(expectedExceptions={ParsingException.class}, expectedExceptionsMessageRegExp="ISPN014026: The expression 'age' must be part of an aggregate function or it should be included in the GROUP BY clause")
    public void testHavingClauseAllowsAggregationsAndGroupByColumnsOnly() {
        Query q = this.buildQuery("select name from org.infinispan.query.dsl.embedded.testdomain.hsearch.UserHS group by name having age >= 18");
        q.list();
    }

    @Test(expectedExceptions={ParsingException.class}, expectedExceptionsMessageRegExp="ISPN014026: The expression 'name' must be part of an aggregate function or it should be included in the GROUP BY clause")
    public void testDisallowNonAggregatedProjectionWithGlobalAggregation() {
        Query q = this.buildQuery("select name, count(name) from org.infinispan.query.dsl.embedded.testdomain.hsearch.UserHS");
        q.list();
    }

    public void testBuildLuceneQuery() {
        IckleParsingResult parsingResult = IckleParser.parse((String)"select name from org.infinispan.query.dsl.embedded.testdomain.hsearch.UserHS", (ObjectPropertyHelper)this.qe.getPropertyHelper());
        CacheQuery q = this.qe.buildLuceneQuery(parsingResult, null, -1L, -1);
        List list = q.list();
        AssertJUnit.assertEquals((int)3, (int)list.size());
    }

    @Test(expectedExceptions={SearchException.class}, expectedExceptionsMessageRegExp="Unable to find field notes in org.infinispan.query.dsl.embedded.testdomain.hsearch.UserHS")
    public void testBuildLuceneQueryOnNonIndexedField() {
        IckleParsingResult parsingResult = IckleParser.parse((String)"select notes from org.infinispan.query.dsl.embedded.testdomain.hsearch.UserHS where notes like 'TBD%'", (ObjectPropertyHelper)this.qe.getPropertyHelper());
        CacheQuery q = this.qe.buildLuceneQuery(parsingResult, null, -1L, -1);
    }

    public void testGlobalCount() {
        Query q = this.buildQuery("select count(name), count(age) from org.infinispan.query.dsl.embedded.testdomain.hsearch.UserHS");
        List list = q.list();
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertEquals((int)2, (int)((Object[])list.get(0)).length);
        AssertJUnit.assertEquals((Object)3L, (Object)((Object[])list.get(0))[0]);
        AssertJUnit.assertEquals((Object)2L, (Object)((Object[])list.get(0))[1]);
    }

    public void testGlobalAvg() {
        Query q = this.buildQuery("select avg(age) from org.infinispan.query.dsl.embedded.testdomain.hsearch.UserHS");
        List list = q.list();
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertEquals((int)1, (int)((Object[])list.get(0)).length);
        AssertJUnit.assertEquals((Object)33.0, (Object)((Object[])list.get(0))[0]);
    }

    public void testGlobalSum() {
        Query q = this.buildQuery("select sum(age) from org.infinispan.query.dsl.embedded.testdomain.hsearch.UserHS");
        List list = q.list();
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertEquals((int)1, (int)((Object[])list.get(0)).length);
        AssertJUnit.assertEquals((Object)66L, (Object)((Object[])list.get(0))[0]);
    }

    public void testGlobalMin() {
        Query q = this.buildQuery("select min(age) from org.infinispan.query.dsl.embedded.testdomain.hsearch.UserHS");
        List list = q.list();
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertEquals((int)1, (int)((Object[])list.get(0)).length);
        AssertJUnit.assertEquals((Object)22, (Object)((Object[])list.get(0))[0]);
    }

    public void testGlobalMax() {
        Query q = this.buildQuery("select max(age) from org.infinispan.query.dsl.embedded.testdomain.hsearch.UserHS");
        List list = q.list();
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertEquals((int)1, (int)((Object[])list.get(0)).length);
        AssertJUnit.assertEquals((Object)44, (Object)((Object[])list.get(0))[0]);
    }

    public void testAggregateGroupingField() {
        Query q = this.buildQuery("select count(name) from org.infinispan.query.dsl.embedded.testdomain.hsearch.UserHS group by name order by count(name)");
        List list = q.list();
        AssertJUnit.assertEquals((int)2, (int)list.size());
        AssertJUnit.assertEquals((int)1, (int)((Object[])list.get(0)).length);
        AssertJUnit.assertEquals((Object)1L, (Object)((Object[])list.get(0))[0]);
        AssertJUnit.assertEquals((int)1, (int)((Object[])list.get(1)).length);
        AssertJUnit.assertEquals((Object)2L, (Object)((Object[])list.get(1))[0]);
    }

    public void testAggregateEmbedded1() {
        Query q = this.buildQuery("select max(accountIds) from org.infinispan.query.dsl.embedded.testdomain.hsearch.UserHS group by name order by name");
        List list = q.list();
        AssertJUnit.assertEquals((int)2, (int)list.size());
        AssertJUnit.assertEquals((int)1, (int)((Object[])list.get(0)).length);
        AssertJUnit.assertEquals((Object)2, (Object)((Object[])list.get(0))[0]);
        AssertJUnit.assertEquals((int)1, (int)((Object[])list.get(1)).length);
        AssertJUnit.assertEquals((Object)3, (Object)((Object[])list.get(1))[0]);
    }

    public void testAggregateEmbedded2() {
        Query q = this.buildQuery("select max(u.addresses.postCode) from org.infinispan.query.dsl.embedded.testdomain.hsearch.UserHS u group by u.name order by u.name");
        List list = q.list();
        AssertJUnit.assertEquals((int)2, (int)list.size());
        AssertJUnit.assertEquals((int)1, (int)((Object[])list.get(0)).length);
        AssertJUnit.assertEquals((Object)"X1234", (Object)((Object[])list.get(0))[0]);
        AssertJUnit.assertEquals((int)1, (int)((Object[])list.get(1)).length);
        AssertJUnit.assertEquals((Object)"ZZ", (Object)((Object[])list.get(1))[0]);
    }

    @Test(expectedExceptions={IllegalStateException.class}, expectedExceptionsMessageRegExp="Aggregation SUM cannot be applied to property of type java.lang.String")
    public void testIncompatibleAggregator() {
        Query q = this.buildQuery("select sum(name) from org.infinispan.query.dsl.embedded.testdomain.hsearch.UserHS");
        q.list();
    }

    public void testAggregateNulls() {
        Query q = this.buildQuery("select name, sum(age), avg(age) from org.infinispan.query.dsl.embedded.testdomain.hsearch.UserHS where surname is not null group by name having name >= 'A' and count(age) >= 1");
        List list = q.list();
        AssertJUnit.assertEquals((int)2, (int)list.size());
    }

    public void testRenamedFields1() {
        Query q = this.buildQuery("select theField from org.infinispan.query.dsl.embedded.impl.model.TheEntity where theField >= 'a' order by theField");
        List list = q.list();
        AssertJUnit.assertEquals((int)2, (int)list.size());
        AssertJUnit.assertEquals((int)1, (int)((Object[])list.get(0)).length);
        AssertJUnit.assertEquals((Object)"test value 1", (Object)((Object[])list.get(0))[0]);
        AssertJUnit.assertEquals((Object)"test value 2", (Object)((Object[])list.get(1))[0]);
    }

    public void testRenamedFields2() {
        Query q = this.buildQuery("select theField from org.infinispan.query.dsl.embedded.impl.model.TheEntity order by theField");
        List list = q.list();
        AssertJUnit.assertEquals((int)2, (int)list.size());
        AssertJUnit.assertEquals((int)1, (int)((Object[])list.get(0)).length);
        AssertJUnit.assertEquals((Object)"test value 1", (Object)((Object[])list.get(0))[0]);
        AssertJUnit.assertEquals((Object)"test value 2", (Object)((Object[])list.get(1))[0]);
    }

    public void testRenamedFields3() {
        Query q = this.buildQuery("select e.embeddedEntity.anotherField from org.infinispan.query.dsl.embedded.impl.model.TheEntity e where e.embeddedEntity.anotherField >= 'a' order by e.theField");
        List list = q.list();
        AssertJUnit.assertEquals((int)2, (int)list.size());
        AssertJUnit.assertEquals((int)1, (int)((Object[])list.get(0)).length);
        AssertJUnit.assertEquals((Object)"test embedded value 1", (Object)((Object[])list.get(0))[0]);
        AssertJUnit.assertEquals((Object)"test embedded value 2", (Object)((Object[])list.get(1))[0]);
    }

    public void testRenamedFields4() {
        Query q = this.buildQuery("select e.embeddedEntity.anotherField from org.infinispan.query.dsl.embedded.impl.model.TheEntity e order by e.theField");
        List list = q.list();
        AssertJUnit.assertEquals((int)2, (int)list.size());
        AssertJUnit.assertEquals((int)1, (int)((Object[])list.get(0)).length);
        AssertJUnit.assertEquals((Object)"test embedded value 1", (Object)((Object[])list.get(0))[0]);
        AssertJUnit.assertEquals((Object)"test embedded value 2", (Object)((Object[])list.get(1))[0]);
    }

    @Test(expectedExceptions={ParsingException.class}, expectedExceptionsMessageRegExp="ISPN028507: Invalid boolean literal '90'")
    public void testInvalidNotIndexedBooleanComparison() {
        this.buildQuery("from org.infinispan.query.dsl.embedded.testdomain.hsearch.TransactionHS where isValid = 90");
    }

    @Test(expectedExceptions={ParsingException.class}, expectedExceptionsMessageRegExp="ISPN014037: Invalid boolean literal '90'")
    public void testInvalidIndexedBooleanComparison() {
        this.buildQuery("from org.infinispan.query.dsl.embedded.testdomain.hsearch.TransactionHS where isDebit = 90");
    }

    public void testBooleanComparison() {
        IckleParsingResult parsingResult = IckleParser.parse((String)"from org.infinispan.query.dsl.embedded.testdomain.hsearch.TransactionHS WHERE isDebit = false", (ObjectPropertyHelper)this.qe.getPropertyHelper());
        CacheQuery q = this.qe.buildLuceneQuery(parsingResult, null, -1L, -1);
        List list = q.list();
        AssertJUnit.assertEquals((int)1, (int)list.size());
    }

    public void testConstantBooleanExpression() {
        IckleParsingResult parsingResult = IckleParser.parse((String)"from org.infinispan.query.dsl.embedded.testdomain.hsearch.TransactionHS WHERE true", (ObjectPropertyHelper)this.qe.getPropertyHelper());
        CacheQuery q = this.qe.buildLuceneQuery(parsingResult, null, -1L, -1);
        List list = q.list();
        AssertJUnit.assertEquals((int)56, (int)list.size());
        parsingResult = IckleParser.parse((String)"from org.infinispan.query.dsl.embedded.testdomain.hsearch.TransactionHS WHERE false", (ObjectPropertyHelper)this.qe.getPropertyHelper());
        q = this.qe.buildLuceneQuery(parsingResult, null, -1L, -1);
        list = q.list();
        AssertJUnit.assertEquals((int)0, (int)list.size());
    }

    public void testFullTextKeyword() {
        IckleParsingResult parsingResult = IckleParser.parse((String)"from org.infinispan.query.dsl.embedded.testdomain.Book b where b.preface:('java se'^7 -('bicycle' 'ski')) and b.publisher:'Oracel'~2", (ObjectPropertyHelper)this.qe.getPropertyHelper());
        CacheQuery q = this.qe.buildLuceneQuery(parsingResult, null, -1L, -1);
        List list = q.list();
        AssertJUnit.assertEquals((int)1, (int)list.size());
    }
}

