/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.persistence;

import java.io.File;
import java.io.Serializable;
import java.util.List;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Store;
import org.infinispan.Cache;
import org.infinispan.commons.test.CommonsTestingUtil;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.Index;
import org.infinispan.configuration.cache.SingleFileStoreConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.protostream.annotations.AutoProtoSchemaBuilder;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.Search;
import org.infinispan.query.SearchManager;
import org.infinispan.query.persistence.SCIImpl;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.CacheManagerCallable;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.persistence.InconsistentIndexesAfterRestartTest")
public class InconsistentIndexesAfterRestartTest
extends AbstractInfinispanTest {
    private static String TMP_DIR;

    @Test
    public void testPutSearchablePersistentWithoutBatchingWithoutTran() throws Exception {
        this.testPutTwice(false, false);
    }

    @Test
    public void testPutSearchablePersistentWithBatchingWithoutTran() throws Exception {
        this.testPutTwice(true, false);
    }

    @Test
    public void testPutSearchablePersistentWithBatchingInTran() throws Exception {
        this.testPutTwice(true, true);
    }

    private void testPutTwice(boolean batching, boolean inTran) throws Exception {
        this.testPutOperation(batching, inTran);
        this.testPutOperation(batching, inTran);
    }

    private void testPutOperation(boolean batching, final boolean inTran) throws Exception {
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(this.getCacheManager(batching)){

            public void call() throws Exception {
                Cache c = this.cm.getCache();
                if (inTran) {
                    c.getAdvancedCache().getTransactionManager().begin();
                }
                c.put((Object)"key1", (Object)new SEntity(1L, "name1", "surname1"));
                if (inTran) {
                    c.getAdvancedCache().getTransactionManager().commit();
                }
                Assert.assertEquals((int)InconsistentIndexesAfterRestartTest.this.searchByName("name1", c).size(), (int)1, (String)"should be 1, even repeating this");
            }
        });
    }

    private EmbeddedCacheManager getCacheManager(boolean batchingEnabled) throws Exception {
        GlobalConfigurationBuilder globalBuilder = new GlobalConfigurationBuilder().nonClusteredDefault();
        globalBuilder.globalState().persistentLocation(TMP_DIR);
        globalBuilder.serialization().addContextInitializer((SerializationContextInitializer)SCI.INSTANCE);
        ConfigurationBuilder builder = new ConfigurationBuilder();
        ((SingleFileStoreConfigurationBuilder)builder.persistence().addSingleFileStore().fetchPersistentState(true)).indexing().index(Index.PRIMARY_OWNER).addIndexedEntity(SEntity.class).addProperty("default.directory_provider", "filesystem").addProperty("lucene_version", "LUCENE_CURRENT").addProperty("default.indexBase", TMP_DIR + File.separator + "idx").invocationBatching().enable(batchingEnabled);
        return TestCacheManagerFactory.createCacheManager((GlobalConfigurationBuilder)globalBuilder, (ConfigurationBuilder)builder);
    }

    private List searchByName(String name, Cache c) {
        SearchManager sm = Search.getSearchManager((Cache)c);
        CacheQuery q = sm.getQuery(SEntity.searchByName(name), new Class[]{SEntity.class});
        int resultSize = q.getResultSize();
        List l = q.list();
        assert (l.size() == resultSize);
        return q.list();
    }

    @BeforeClass
    protected void setUpTempDir() {
        TMP_DIR = CommonsTestingUtil.tmpDirectory(((Object)((Object)this)).getClass());
        new File(TMP_DIR).mkdirs();
    }

    @AfterClass
    protected void clearTempDir() {
        Util.recursiveFileRemove((String)TMP_DIR);
    }

    @AutoProtoSchemaBuilder(includeClasses={SEntity.class}, schemaFileName="test.query.persistence.InconsistentIndexesAfterRestartTest.proto", schemaFilePath="proto/generated", schemaPackageName="org.infinispan.test.InconsistentIndexesAfterRestartTest")
    static interface SCI
    extends SerializationContextInitializer {
        public static final SCI INSTANCE = new SCIImpl();
    }

    @Indexed
    public static class SEntity
    implements Serializable {
        public static final String IDX_NAME = "name";
        private final long id;
        @Field(store=Store.YES)
        private final String name;
        @Field(store=Store.YES)
        private final String surname;

        @ProtoFactory
        SEntity(long id, String name, String surname) {
            this.id = id;
            this.name = name;
            this.surname = surname;
        }

        @ProtoField(number=1, defaultValue="0")
        public long getId() {
            return this.id;
        }

        @ProtoField(number=2)
        public String getName() {
            return this.name;
        }

        @ProtoField(number=3)
        public String getSurname() {
            return this.surname;
        }

        public String toString() {
            return "SEntity{id=" + this.id + ", name='" + this.name + '\'' + ", surname='" + this.surname + '\'' + '}';
        }

        public static Query searchByName(String name) {
            return new BooleanQuery.Builder().add((Query)new TermQuery(new Term(IDX_NAME, name.toLowerCase())), BooleanClause.Occur.MUST).build();
        }
    }
}

