/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.api;

import org.apache.lucene.search.Query;
import org.hibernate.search.query.dsl.TermMatchingContext;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.query.Search;
import org.infinispan.query.SearchManager;
import org.infinispan.query.api.AnotherTestEntity;
import org.infinispan.query.api.NotIndexedType;
import org.infinispan.query.api.TestEntity;
import org.infinispan.query.helper.StaticTestingErrorHandler;
import org.infinispan.query.test.QueryTestSCI;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.api.NonIndexedValuesTest")
public class NonIndexedValuesTest
extends SingleCacheManagerTest {
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder c = this.getDefaultStandaloneCacheConfig(true);
        c.indexing().enable().addIndexedEntity(TestEntity.class).addIndexedEntity(AnotherTestEntity.class).addProperty("default.directory_provider", "local-heap").addProperty("error_handler", "org.infinispan.query.helper.StaticTestingErrorHandler").addProperty("lucene_version", "LUCENE_CURRENT");
        return TestCacheManagerFactory.createCacheManager((SerializationContextInitializer)QueryTestSCI.INSTANCE, (ConfigurationBuilder)c);
    }

    @Test
    public void testReplaceSimpleSearchable() {
        TestEntity se1 = new TestEntity("ISPN-1949", "Allow non-indexed values in indexed caches", 10L, "note");
        this.cache.put((Object)se1.getId(), (Object)se1);
        this.cache.put((Object)"name2", (Object)"some string value");
        this.cache.put((Object)"name3", (Object)"some string value");
        this.cache.put((Object)"name3", (Object)new NotIndexedType("some string value"));
        SearchManager qf = Search.getSearchManager((Cache)this.cache);
        Query ispnIssueQuery = ((TermMatchingContext)qf.buildQueryBuilderForClass(TestEntity.class).get().keyword().onField("name").ignoreAnalyzer()).matching((Object)"ISPN-1949").createQuery();
        AssertJUnit.assertEquals((int)1, (int)qf.getQuery(ispnIssueQuery, new Class[0]).list().size());
        this.cache.put((Object)se1.getId(), (Object)"some string value");
        AssertJUnit.assertEquals((int)0, (int)qf.getQuery(ispnIssueQuery, new Class[0]).list().size());
        AnotherTestEntity indexBEntity = new AnotherTestEntity("ISPN-1949");
        this.cache.put((Object)"name", (Object)indexBEntity);
        AssertJUnit.assertEquals((int)1, (int)qf.getQuery(ispnIssueQuery, new Class[0]).list().size());
        TestEntity se2 = new TestEntity("HSEARCH-1077", "Mutable SearchFactory should return which classes are actually going to be indexed", 10L, "note");
        this.cache.replace((Object)"name", (Object)indexBEntity, (Object)se2);
        AssertJUnit.assertEquals((int)0, (int)qf.getQuery(ispnIssueQuery, new Class[0]).list().size());
        Query searchIssueQuery = ((TermMatchingContext)qf.buildQueryBuilderForClass(TestEntity.class).get().keyword().onField("name").ignoreAnalyzer()).matching((Object)"HSEARCH-1077").createQuery();
        AssertJUnit.assertEquals((int)1, (int)qf.getQuery(searchIssueQuery, new Class[0]).list().size());
        this.cache.replace((Object)"name", (Object)"notMatching", (Object)"notImportant");
        AssertJUnit.assertEquals((int)1, (int)qf.getQuery(searchIssueQuery, new Class[0]).list().size());
        AssertJUnit.assertEquals((int)0, (int)qf.getQuery(ispnIssueQuery, new Class[0]).list().size());
        this.cache.remove((Object)"name");
        AssertJUnit.assertEquals((int)0, (int)qf.getQuery(searchIssueQuery, new Class[0]).list().size());
        this.cache.put((Object)"name", (Object)se2);
        AssertJUnit.assertEquals((int)1, (int)qf.getQuery(searchIssueQuery, new Class[0]).list().size());
        this.cache.put((Object)"name", (Object)"replacement String");
        AssertJUnit.assertEquals((int)0, (int)qf.getQuery(searchIssueQuery, new Class[0]).list().size());
        this.cache.put((Object)"name", (Object)se1);
        AssertJUnit.assertEquals((int)1, (int)qf.getQuery(ispnIssueQuery, new Class[0]).list().size());
        this.cache.put((Object)"second name", (Object)se1);
        AssertJUnit.assertEquals((int)2, (int)qf.getQuery(ispnIssueQuery, new Class[0]).list().size());
        AssertJUnit.assertEquals((int)2, (int)qf.getQuery(ispnIssueQuery, new Class[]{TestEntity.class}).list().size());
        this.cache.replace((Object)"name", (Object)se1, (Object)indexBEntity);
        AssertJUnit.assertEquals((int)2, (int)qf.getQuery(ispnIssueQuery, new Class[0]).list().size());
        AssertJUnit.assertEquals((int)1, (int)qf.getQuery(ispnIssueQuery, new Class[]{TestEntity.class}).list().size());
        AssertJUnit.assertEquals((int)1, (int)qf.getQuery(ispnIssueQuery, new Class[]{AnotherTestEntity.class}).list().size());
        this.cache.replace((Object)"name", (Object)indexBEntity, (Object)new NotIndexedType("this is not indexed"));
        AssertJUnit.assertEquals((int)1, (int)qf.getQuery(ispnIssueQuery, new Class[0]).list().size());
        StaticTestingErrorHandler.assertAllGood(this.cache);
    }
}

