/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.blackbox;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.StoreConfigurationBuilder;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.dummy.DummyInMemoryStore;
import org.infinispan.persistence.dummy.DummyInMemoryStoreConfigurationBuilder;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.persistence.spi.MarshallableEntry;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.query.Search;
import org.infinispan.query.SearchManager;
import org.infinispan.query.test.AnotherGrassEater;
import org.infinispan.query.test.Person;
import org.infinispan.query.test.QueryTestSCI;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.function.SerializableBiFunction;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.blackbox.IndexingWithPersistenceTest")
public class IndexingWithPersistenceTest
extends SingleCacheManagerTest {
    private static final String KEY = "k";
    private static final Person RADIM = new Person("Radim", "Tough guy!", 29);
    private static final Person DAN = new Person("Dan", "Not that tough.", 39);
    private static final AnotherGrassEater FLUFFY = new AnotherGrassEater("Fluffy", "Very cute.");
    private DummyInMemoryStore store;

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.indexing().enable().addIndexedEntity(Person.class).addIndexedEntity(AnotherGrassEater.class).addProperty("default.directory_provider", "local-heap").addProperty("lucene_version", "LUCENE_CURRENT");
        builder.persistence().addStore((StoreConfigurationBuilder)new DummyInMemoryStoreConfigurationBuilder(builder.persistence()));
        EmbeddedCacheManager cacheManager = TestCacheManagerFactory.createCacheManager((SerializationContextInitializer)QueryTestSCI.INSTANCE, (ConfigurationBuilder)builder);
        this.cache = cacheManager.getCache();
        this.store = (DummyInMemoryStore)((PersistenceManager)this.cache.getAdvancedCache().getComponentRegistry().getComponent(PersistenceManager.class)).getStores(DummyInMemoryStore.class).iterator().next();
        return cacheManager;
    }

    public void testPut() {
        this.test(c -> c.put((Object)KEY, (Object)FLUFFY), this::assertFluffyIndexed, false);
    }

    public void testPutIgnoreReturnValue() {
        this.test(c -> c.getAdvancedCache().withFlags(Flag.IGNORE_RETURN_VALUES).put((Object)KEY, (Object)FLUFFY), this::assertFluffyIndexed, false);
    }

    public void testPutMap() {
        this.test(c -> c.putAll(Collections.singletonMap(KEY, FLUFFY)), this::assertFluffyIndexed, false);
    }

    public void testReplace() {
        this.test(c -> c.replace((Object)KEY, (Object)FLUFFY), this::assertFluffyIndexed, false);
    }

    public void testRemove() {
        this.test(c -> c.remove((Object)KEY), sm -> {}, true);
    }

    public void testCompute() {
        this.test(c -> c.compute((Object)KEY, (SerializableBiFunction & Serializable)(k, old) -> FLUFFY), this::assertFluffyIndexed, false);
    }

    public void testComputeRemove() {
        this.test(c -> c.compute((Object)KEY, (SerializableBiFunction & Serializable)(k, old) -> null), sm -> {}, true);
    }

    public void testMerge() {
        this.test(c -> c.merge((Object)KEY, (Object)FLUFFY, (SerializableBiFunction & Serializable)(o, n) -> n), this::assertFluffyIndexed, false);
    }

    public void testMergeRemove() {
        this.test(c -> c.merge((Object)KEY, (Object)FLUFFY, (SerializableBiFunction & Serializable)(o, n) -> null), sm -> {}, true);
    }

    private void test(Consumer<Cache> op, Consumer<SearchManager> check, boolean remove) {
        this.cache.put((Object)KEY, (Object)RADIM);
        this.cache.put((Object)"k2", (Object)DAN);
        SearchManager sm = Search.getSearchManager((Cache)this.cache);
        List<Person> found = this.queryAll(sm, Person.class);
        AssertJUnit.assertEquals(Arrays.asList(RADIM, DAN), this.sortByAge(found));
        this.cache.evict((Object)KEY);
        MarshallableEntry inStore = this.store.loadEntry((Object)KEY);
        AssertJUnit.assertNotNull((Object)inStore);
        AssertJUnit.assertTrue((String)("In store: " + inStore), (boolean)(inStore.getValue() instanceof Person));
        AssertJUnit.assertEquals(null, (Object)this.cache.getAdvancedCache().getDataContainer().get((Object)KEY));
        op.accept(this.cache);
        AssertJUnit.assertEquals(Collections.singletonList(DAN), this.queryAll(sm, Person.class));
        check.accept(sm);
        InternalCacheEntry ice = this.cache.getAdvancedCache().getDataContainer().get((Object)KEY);
        inStore = this.store.loadEntry((Object)KEY);
        if (remove) {
            AssertJUnit.assertEquals(null, (Object)ice);
            AssertJUnit.assertEquals(null, (Object)inStore);
        } else {
            AssertJUnit.assertNotNull((Object)ice);
            AssertJUnit.assertTrue((String)("In DC: " + ice), (boolean)(ice.getValue() instanceof AnotherGrassEater));
            AssertJUnit.assertNotNull((Object)inStore);
            AssertJUnit.assertTrue((String)("In store: " + inStore), (boolean)(inStore.getValue() instanceof AnotherGrassEater));
        }
    }

    private List<Person> sortByAge(List<Person> people) {
        Collections.sort(people, Comparator.comparingInt(Person::getAge));
        return people;
    }

    private <T> List<T> queryAll(SearchManager sm, Class<T> entityType) {
        return sm.getQuery(sm.buildQueryBuilderForClass(entityType).get().all().createQuery(), new Class[]{entityType}).list();
    }

    private void assertFluffyIndexed(SearchManager sm) {
        AssertJUnit.assertEquals(Collections.singletonList(FLUFFY), this.queryAll(sm, AnotherGrassEater.class));
    }
}

