/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.distributed;

import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.context.Flag;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.Search;
import org.infinispan.query.SearchManager;
import org.infinispan.query.test.Person;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.distributed.LocalCacheMassIndexerTest")
public class LocalCacheMassIndexerTest
extends SingleCacheManagerTest {
    private static final int NUM_ENTITIES = 2000;

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder cfg = this.getDefaultStandaloneCacheConfig(false);
        cfg.indexing().enable().addIndexedEntity(Person.class).addProperty("default.directory_provider", "local-heap").addProperty("lucene_version", "LUCENE_CURRENT");
        return TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)cfg);
    }

    private int indexSize(Cache<?, ?> cache) {
        SearchManager searchManager = Search.getSearchManager(cache);
        return searchManager.getQuery((Query)new MatchAllDocsQuery(), new Class[]{Person.class}).getResultSize();
    }

    @Test
    public void testMassIndexer() {
        for (int i = 0; i < 2000; ++i) {
            this.cache.put((Object)i, (Object)new Person("name" + i, "blurb" + i, i));
        }
        SearchManager searchManager = Search.getSearchManager((Cache)this.cache);
        AssertJUnit.assertEquals((int)2000, (int)this.indexSize(this.cache));
        searchManager.getMassIndexer().start();
        AssertJUnit.assertEquals((int)2000, (int)this.indexSize(this.cache));
        this.cache.clear();
        searchManager.getMassIndexer().start();
        AssertJUnit.assertEquals((int)0, (int)this.indexSize(this.cache));
    }

    public void testPartiallyReindex() throws Exception {
        this.cache.getAdvancedCache().withFlags(Flag.SKIP_INDEXING).put((Object)0, (Object)new Person("name0", "blurb0", 0));
        this.verifyFindsPerson(0, "name0");
        Search.getSearchManager((Cache)this.cache).getMassIndexer().reindex(new Object[]{0}).get();
        this.verifyFindsPerson(1, "name0");
        this.cache.remove((Object)0);
        this.verifyFindsPerson(0, "name0");
    }

    protected void verifyFindsPerson(int expectedCount, String name) throws Exception {
        SearchManager searchManager = Search.getSearchManager((Cache)this.cache);
        QueryBuilder carQueryBuilder = searchManager.buildQueryBuilderForClass(Person.class).get();
        Query fullTextQuery = carQueryBuilder.keyword().onField("name").matching((Object)name).createQuery();
        CacheQuery cacheQuery = searchManager.getQuery(fullTextQuery, new Class[]{Person.class});
        AssertJUnit.assertEquals((int)expectedCount, (int)cacheQuery.getResultSize());
    }
}

