/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.distributed;

import javax.security.auth.Subject;
import org.infinispan.query.distributed.DistributedMassIndexingTest;
import org.infinispan.security.Security;
import org.infinispan.test.TestingUtil;
import org.junit.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.distributed.SecureMassIndexingTest")
public class SecureMassIndexingTest
extends DistributedMassIndexingTest {
    private static final Subject ADMIN = TestingUtil.makeSubject((String[])new String[]{"admin"});

    @Override
    protected String getConfigurationFile() {
        return "mass-index-with-security.xml";
    }

    @Override
    protected void createCacheManagers() throws Throwable {
        this.runAs(ADMIN, () -> super.createCacheManagers());
    }

    @AfterMethod
    protected void clearContent() {
        this.runAs(ADMIN, () -> super.clearContent());
    }

    @Override
    public void testPartiallyReindex() {
        this.runAs(ADMIN, () -> super.testPartiallyReindex());
    }

    @Override
    public void testReindexing() {
        this.runAs(ADMIN, () -> super.testReindexing());
    }

    private void runAs(Subject subject, TestExecution execution) {
        Security.doAs((Subject)subject, () -> {
            try {
                execution.apply();
            }
            catch (Throwable e) {
                e.printStackTrace();
                Assert.fail();
            }
            return null;
        });
    }

    static interface TestExecution {
        public void apply() throws Throwable;
    }
}

