/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.indexedembedded;

import java.util.List;
import org.apache.lucene.search.Query;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.query.Search;
import org.infinispan.query.SearchManager;
import org.infinispan.query.indexedembedded.Book;
import org.infinispan.query.test.QueryTestSCI;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.TransactionMode;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.indexedembedded.BooksExampleTest")
public class BooksExampleTest
extends SingleCacheManagerTest {
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder cfg = this.getDefaultStandaloneCacheConfig(true);
        cfg.transaction().transactionMode(TransactionMode.TRANSACTIONAL).indexing().enable().addIndexedEntity(Book.class).addProperty("default.directory_provider", "local-heap").addProperty("lucene_version", "LUCENE_CURRENT");
        return TestCacheManagerFactory.createCacheManager((SerializationContextInitializer)QueryTestSCI.INSTANCE, (ConfigurationBuilder)cfg);
    }

    @Test
    public void searchOnEmptyIndex() {
        this.cache.put((Object)"1", (Object)new Book("Seam in Action", "Dan Allen", "Manning"));
        this.cache.put((Object)"2", (Object)new Book("Hibernate Search in Action", "Emmanuel Bernard and John Griffin", "Manning"));
        this.cache.put((Object)"3", (Object)new Book("Megaprogramming Ruby", "Paolo Perrotta", "The Pragmatic Programmers"));
        SearchManager qf = Search.getSearchManager((Cache)this.cache);
        Query luceneQuery = qf.buildQueryBuilderForClass(Book.class).get().phrase().onField("title").sentence("in action").createQuery();
        List list = qf.getQuery(luceneQuery, new Class[0]).list();
        assert (list.size() == 2);
    }
}

