/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.jmx;

import java.net.URL;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.infinispan.Cache;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.jmx.MBeanServerLookup;
import org.infinispan.commons.jmx.TestMBeanServerLookup;
import org.infinispan.commons.util.FileLookupFactory;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.distributed.DistributedMassIndexingTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.jmx.DistributedMassIndexingViaJmxTest")
public class DistributedMassIndexingViaJmxTest
extends DistributedMassIndexingTest {
    private static final String BASE_JMX_DOMAIN = DistributedMassIndexingViaJmxTest.class.getName();
    private final MBeanServerLookup mBeanServerLookup = TestMBeanServerLookup.create();

    @Override
    protected void createCacheManagers() throws Throwable {
        for (int i = 0; i < 3; ++i) {
            URL url = FileLookupFactory.newInstance().lookupFileLocation("dynamic-indexing-distribution.xml", Thread.currentThread().getContextClassLoader());
            ParserRegistry parserRegistry = new ParserRegistry(Thread.currentThread().getContextClassLoader());
            ConfigurationBuilderHolder holder = parserRegistry.parse(url);
            TestCacheManagerFactory.configureJmx((GlobalConfigurationBuilder)holder.getGlobalConfigurationBuilder(), (String)(BASE_JMX_DOMAIN + i), (MBeanServerLookup)this.mBeanServerLookup);
            EmbeddedCacheManager cm = TestCacheManagerFactory.createClusteredCacheManager((ConfigurationBuilderHolder)holder);
            this.registerCacheManager(new CacheContainer[]{cm});
            Cache cache = cm.getCache(((Object)((Object)this)).getClass().getSimpleName());
            this.caches.add(cache);
        }
        this.waitForClusterToForm();
    }

    @Override
    protected void rebuildIndexes() throws Exception {
        String cacheManagerName = this.manager(0).getCacheManagerConfiguration().cacheManagerName();
        ObjectName massIndexerObjName = this.getMassIndexerObjectName(BASE_JMX_DOMAIN + 0, cacheManagerName, ((Object)((Object)this)).getClass().getSimpleName());
        this.mBeanServerLookup.getMBeanServer().invoke(massIndexerObjName, "start", new Object[0], new String[0]);
    }

    private ObjectName getMassIndexerObjectName(String jmxDomain, String cacheManagerName, String cacheName) {
        try {
            return new ObjectName(jmxDomain + ":type=Query,manager=" + ObjectName.quote(cacheManagerName) + ",cache=" + ObjectName.quote(cacheName) + ",component=MassIndexer");
        }
        catch (MalformedObjectNameException e) {
            throw new CacheException("Malformed object name", (Throwable)e);
        }
    }
}

