/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.tx;

import java.util.concurrent.Callable;
import javax.transaction.TransactionManager;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.protostream.annotations.AutoProtoSchemaBuilder;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.query.helper.TestQueryHelperFactory;
import org.infinispan.query.nulls.SCIImpl;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.tx.TransactionalQueryTest")
public class TransactionalQueryTest
extends SingleCacheManagerTest {
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder cfg = this.getDefaultStandaloneCacheConfig(true);
        cfg.indexing().enable().addIndexedEntity(Session.class).addProperty("default.directory_provider", "local-heap").addProperty("lucene_version", "LUCENE_CURRENT");
        return TestCacheManagerFactory.createCacheManager((SerializationContextInitializer)new SCIImpl(), (ConfigurationBuilder)cfg);
    }

    @BeforeMethod
    public void initialize() throws Exception {
        TestingUtil.withTx((TransactionManager)this.tm(), (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                for (int i = 0; i < 100; ++i) {
                    TransactionalQueryTest.this.cache.put((Object)String.valueOf(i), (Object)new Session(String.valueOf(i)));
                }
                return null;
            }
        });
    }

    public void run() throws Exception {
        TestQueryHelperFactory.createCacheQuery(this.cache, "", "Id:2?");
        TestingUtil.withTx((TransactionManager)this.tm(), (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                TransactionalQueryTest.this.cache.remove((Object)"50");
                return null;
            }
        });
        TestingUtil.withTx((TransactionManager)this.tm(), (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                TransactionalQueryTest.this.cache.remove((Object)"200");
                return null;
            }
        });
    }

    @AutoProtoSchemaBuilder(includeClasses={Session.class}, schemaFileName="test.query.tx.TransactionalQueryTest.proto", schemaFilePath="proto/generated", schemaPackageName="org.infinispan.test.TransactionalQueryTest")
    static interface SCI
    extends SerializationContextInitializer {
    }

    @Indexed(index="SessionIndex")
    public static class Session {
        private String m_id;

        @ProtoFactory
        Session(String id) {
            this.m_id = id;
        }

        @Field(name="Id")
        @ProtoField(number=1)
        public String getId() {
            return this.m_id;
        }
    }
}

