/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.backend;

import java.util.Date;
import org.hibernate.search.backend.IndexWorkVisitor;
import org.hibernate.search.backend.impl.lucene.LuceneBackendResources;
import org.hibernate.search.backend.impl.lucene.WorkspaceHolder;
import org.hibernate.search.backend.impl.lucene.works.ByTermUpdateWorkExecutor;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.indexes.spi.DirectoryBasedIndexManager;
import org.hibernate.search.spi.SearchIntegrator;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.query.Search;
import org.infinispan.query.backend.Bond;
import org.infinispan.query.backend.Debenture;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.helper.StaticTestingErrorHandler;
import org.infinispan.query.test.QueryTestSCI;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.backend.MultipleEntitiesTest")
public class MultipleEntitiesTest
extends SingleCacheManagerTest {
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder cfg = this.getDefaultStandaloneCacheConfig(false);
        cfg.indexing().enable().addIndexedEntity(Bond.class).addIndexedEntity(Debenture.class).addProperty("default.directory_provider", "local-heap").addProperty("error_handler", StaticTestingErrorHandler.class.getName()).addProperty("lucene_version", "LUCENE_CURRENT");
        return TestCacheManagerFactory.createCacheManager((SerializationContextInitializer)QueryTestSCI.INSTANCE, (ConfigurationBuilder)cfg);
    }

    @Test
    public void testIndexAndQuery() {
        QueryFactory queryFactory = Search.getQueryFactory((Cache)this.cache);
        SearchIntegrator searchIntegrator = (SearchIntegrator)TestingUtil.extractComponent((Cache)this.cache, SearchIntegrator.class);
        this.cache.put((Object)123405, (Object)new Bond(new Date(System.currentTimeMillis()), 450L));
        this.assertEfficientIndexingUsed(searchIntegrator, Bond.class);
        this.cache.put((Object)123502, (Object)new Debenture("GB", 116.0));
        this.assertEfficientIndexingUsed(searchIntegrator, Debenture.class);
        this.cache.put((Object)223456, (Object)new Bond(new Date(System.currentTimeMillis()), 550L));
        this.assertEfficientIndexingUsed(searchIntegrator, Bond.class);
        Query query = queryFactory.create("FROM " + Bond.class.getName());
        Query query2 = queryFactory.create("FROM " + Debenture.class.getName());
        Assert.assertEquals((int)(query.list().size() + query2.list().size()), (int)3);
        Query queryBond = queryFactory.create("FROM " + Bond.class.getName());
        Assert.assertEquals((long)queryBond.execute().hitCount().orElse(-1L), (long)2L);
        Query queryDeb = queryFactory.create("FROM " + Debenture.class.getName());
        Assert.assertEquals((long)queryDeb.execute().hitCount().orElse(-1L), (long)1L);
    }

    private void assertEfficientIndexingUsed(SearchIntegrator searchIntegrator, Class<?> clazz) {
        DirectoryBasedIndexManager im = (DirectoryBasedIndexManager)((EntityIndexBinding)searchIntegrator.getIndexBindings().get(clazz)).getIndexManagerSelector().all().iterator().next();
        WorkspaceHolder workspaceHolder = im.getWorkspaceHolder();
        LuceneBackendResources indexResources = workspaceHolder.getIndexResources();
        IndexWorkVisitor visitor = indexResources.getWorkVisitor();
        Assert.assertTrue((boolean)(TestingUtil.extractField((Object)visitor, (String)"updateExecutor") instanceof ByTermUpdateWorkExecutor));
    }
}

