/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.blackbox;

import java.io.Serializable;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Store;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.protostream.annotations.AutoProtoSchemaBuilder;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.query.Search;
import org.infinispan.query.blackbox.SCIImpl;
import org.infinispan.query.dsl.Query;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.blackbox.ClusteredCacheWithLongIndexNameTest")
@CleanupAfterMethod
public class ClusteredCacheWithLongIndexNameTest
extends MultipleCacheManagersTest {
    private Cache<String, ClassWithLongIndexName> cache0;
    private Cache<String, ClassWithLongIndexName> cache1;
    private Cache<String, ClassWithLongIndexName> cache2;

    protected void createCacheManagers() throws Throwable {
        this.createClusteredCaches(3, SCI.INSTANCE, this.getDefaultConfiguration());
        this.cache0 = this.cache(0);
        this.cache1 = this.cache(1);
        this.cache2 = this.cache(2);
    }

    private ConfigurationBuilder getDefaultConfiguration() {
        ConfigurationBuilder cacheCfg = TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)this.transactionsEnabled(), (boolean)false);
        cacheCfg.clustering().cacheMode(this.getCacheMode()).indexing().enable().addIndexedEntity(ClassWithLongIndexName.class).addProperty("default.directory_provider", "local-heap").addProperty("lucene_version", "LUCENE_CURRENT");
        return cacheCfg;
    }

    public boolean transactionsEnabled() {
        return false;
    }

    public CacheMode getCacheMode() {
        return CacheMode.REPL_SYNC;
    }

    public void testAdditionOfNewNode() {
        for (int i = 0; i < 100; ++i) {
            this.cache0.put((Object)("key" + i), (Object)new ClassWithLongIndexName("value" + i));
        }
        String q = String.format("FROM %s WHERE name:'value*'", ClassWithLongIndexName.class.getName());
        Query cq = Search.getQueryFactory(this.cache2).create(q);
        AssertJUnit.assertEquals((long)100L, (long)cq.execute().hitCount().orElse(-1L));
        this.addClusterEnabledCacheManager(SCI.INSTANCE, this.getDefaultConfiguration());
        TestingUtil.waitForNoRebalance((Cache[])new Cache[]{this.cache(0), this.cache(1), this.cache(2), this.cache(3)});
        cq = Search.getQueryFactory((Cache)this.cache(3)).create(q);
        AssertJUnit.assertEquals((long)100L, (long)cq.execute().hitCount().orElse(-1L));
    }

    @AutoProtoSchemaBuilder(includeClasses={ClassWithLongIndexName.class}, schemaFileName="test.query.blackbox.ClusteredCacheWithLongIndexNameTest.proto", schemaFilePath="proto/generated", schemaPackageName="org.infinispan.test.ClusteredCacheWithLongIndexNameTest")
    static interface SCI
    extends SerializationContextInitializer {
        public static final SCI INSTANCE = new SCIImpl();
    }

    @Indexed(index="default_taskworker-java__com.google.appengine.api.datastore.Entity")
    public static class ClassWithLongIndexName
    implements Serializable {
        @Field(store=Store.YES)
        @ProtoField(number=1)
        String name;

        @ProtoFactory
        ClassWithLongIndexName(String name) {
            this.name = name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClassWithLongIndexName that = (ClassWithLongIndexName)o;
            return this.name != null ? this.name.equals(that.name) : that.name == null;
        }

        public int hashCode() {
            return this.name != null ? this.name.hashCode() : 0;
        }

        public String toString() {
            return "ClassWithLongIndexName{name='" + this.name + "'}";
        }
    }
}

