/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.dsl.embedded;

import java.util.ArrayList;
import java.util.List;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.event.CacheEntryCreatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryModifiedEvent;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilter;
import org.infinispan.objectfilter.ObjectFilter;
import org.infinispan.objectfilter.ParsingException;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.query.Search;
import org.infinispan.query.dsl.Expression;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.test.Person;
import org.infinispan.query.test.QueryTestSCI;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.dsl.embedded.ListenerWithDslFilterTest")
public class ListenerWithDslFilterTest
extends SingleCacheManagerTest {
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        return TestCacheManagerFactory.createCacheManager((SerializationContextInitializer)QueryTestSCI.INSTANCE, (ConfigurationBuilder)this.getConfigurationBuilder());
    }

    protected ConfigurationBuilder getConfigurationBuilder() {
        ConfigurationBuilder cfgBuilder = new ConfigurationBuilder();
        cfgBuilder.indexing().enable().addIndexedEntity(Person.class).addProperty("default.directory_provider", "local-heap").addProperty("lucene_version", "LUCENE_CURRENT");
        return cfgBuilder;
    }

    public void testEventFilter() {
        for (int i = 0; i < 10; ++i) {
            Person value = new Person();
            value.setName("John");
            value.setAge(99);
            this.cache().put((Object)i, (Object)value);
        }
        AssertJUnit.assertEquals((int)10, (int)this.cache.size());
        QueryFactory qf = Search.getQueryFactory((Cache)this.cache());
        Query query = qf.from(Person.class).having("age").lte((Object)Expression.param((String)"ageParam")).build().setParameter("ageParam", (Object)31);
        EntryListener listener = new EntryListener();
        this.cache().addListener((Object)listener, (CacheEventFilter)Search.makeFilter((Query)query), null);
        AssertJUnit.assertTrue((boolean)listener.createEvents.isEmpty());
        AssertJUnit.assertTrue((boolean)listener.modifyEvents.isEmpty());
        for (int i = 0; i < 10; ++i) {
            Person value = new Person();
            value.setName("John");
            value.setAge(i + 25);
            this.cache().put((Object)i, (Object)value);
        }
        AssertJUnit.assertEquals((int)10, (int)this.cache.size());
        AssertJUnit.assertTrue((boolean)listener.createEvents.isEmpty());
        AssertJUnit.assertEquals((int)7, (int)listener.modifyEvents.size());
        for (ObjectFilter.FilterResult r : listener.modifyEvents) {
            Person p = (Person)r.getInstance();
            AssertJUnit.assertTrue((p.getAge() <= 31 ? 1 : 0) != 0);
        }
        this.cache().removeListener((Object)listener);
        listener.createEvents.clear();
        listener.modifyEvents.clear();
        Person value = new Person();
        value.setName("George");
        value.setAge(30);
        this.cache().put((Object)-1, (Object)value);
        AssertJUnit.assertTrue((boolean)listener.createEvents.isEmpty());
        AssertJUnit.assertTrue((boolean)listener.modifyEvents.isEmpty());
    }

    public void testEventFilterChangingParameter() {
        Person p;
        Person value;
        for (int i = 0; i < 10; ++i) {
            Person value2 = new Person();
            value2.setName("John");
            value2.setAge(99);
            this.cache().put((Object)i, (Object)value2);
        }
        AssertJUnit.assertEquals((int)10, (int)this.cache.size());
        QueryFactory qf = Search.getQueryFactory((Cache)this.cache());
        Query query = qf.from(Person.class).having("age").lte((Object)Expression.param((String)"ageParam")).build().setParameter("ageParam", (Object)31);
        EntryListener listener = new EntryListener();
        this.cache().addListener((Object)listener, (CacheEventFilter)Search.makeFilter((Query)query), null);
        AssertJUnit.assertTrue((boolean)listener.createEvents.isEmpty());
        AssertJUnit.assertTrue((boolean)listener.modifyEvents.isEmpty());
        for (int i = 0; i < 10; ++i) {
            value = new Person();
            value.setName("John");
            value.setAge(i + 25);
            this.cache().put((Object)i, (Object)value);
        }
        AssertJUnit.assertEquals((int)10, (int)this.cache.size());
        AssertJUnit.assertTrue((boolean)listener.createEvents.isEmpty());
        AssertJUnit.assertEquals((int)7, (int)listener.modifyEvents.size());
        for (ObjectFilter.FilterResult r : listener.modifyEvents) {
            p = (Person)r.getInstance();
            AssertJUnit.assertTrue((p.getAge() <= 31 ? 1 : 0) != 0);
        }
        this.cache().removeListener((Object)listener);
        query.setParameter("ageParam", (Object)30);
        listener = new EntryListener();
        this.cache().addListener((Object)listener, (CacheEventFilter)Search.makeFilter((Query)query), null);
        AssertJUnit.assertTrue((boolean)listener.createEvents.isEmpty());
        AssertJUnit.assertTrue((boolean)listener.modifyEvents.isEmpty());
        for (int i = 0; i < 10; ++i) {
            value = new Person();
            value.setName("John");
            value.setAge(i + 25);
            this.cache().put((Object)i, (Object)value);
        }
        AssertJUnit.assertEquals((int)10, (int)this.cache.size());
        AssertJUnit.assertTrue((boolean)listener.createEvents.isEmpty());
        AssertJUnit.assertEquals((int)6, (int)listener.modifyEvents.size());
        for (ObjectFilter.FilterResult r : listener.modifyEvents) {
            p = (Person)r.getInstance();
            AssertJUnit.assertTrue((p.getAge() <= 30 ? 1 : 0) != 0);
        }
    }

    public void testEventFilterAndConverter() {
        QueryFactory qf = Search.getQueryFactory((Cache)this.cache());
        Query query = qf.from(Person.class).having("age").lte((Object)31).select(new String[]{"name", "age"}).build();
        EntryListener listener = new EntryListener();
        this.cache().addListener((Object)listener, (CacheEventFilter)Search.makeFilter((Query)query), null);
        for (int i = 0; i < 10; ++i) {
            Person value = new Person();
            value.setName("John");
            value.setAge(i + 25);
            this.cache.put((Object)i, (Object)value);
        }
        AssertJUnit.assertEquals((int)10, (int)this.cache.size());
        AssertJUnit.assertEquals((int)7, (int)listener.createEvents.size());
        AssertJUnit.assertTrue((boolean)listener.modifyEvents.isEmpty());
        for (ObjectFilter.FilterResult r : listener.createEvents) {
            AssertJUnit.assertNotNull((Object)r.getProjection());
            AssertJUnit.assertEquals((int)2, (int)r.getProjection().length);
            AssertJUnit.assertTrue(((Integer)r.getProjection()[1] <= 31 ? 1 : 0) != 0);
        }
        this.cache().removeListener((Object)listener);
    }

    @Test(expectedExceptions={ParsingException.class}, expectedExceptionsMessageRegExp="ISPN028523: Filters cannot use full-text searches")
    public void testDisallowFullTextQuery() {
        Query query = Search.getQueryFactory((Cache)this.cache()).create("from org.infinispan.query.test.Person where name : 'john'");
        this.cache().addListener((Object)new EntryListener(), (CacheEventFilter)Search.makeFilter((Query)query), null);
    }

    @Test(expectedExceptions={ParsingException.class}, expectedExceptionsMessageRegExp=".*ISPN028509:.*")
    public void testDisallowGroupingAndAggregation() {
        Query query = Search.getQueryFactory((Cache)this.cache()).from(Person.class).having("age").gte((Object)20).select(new Expression[]{Expression.max((String)"age")}).build();
        this.cache().addListener((Object)new EntryListener(), (CacheEventFilter)Search.makeFilter((Query)query), null);
    }

    @Listener(observation=Listener.Observation.POST)
    private static class EntryListener {
        public final List<ObjectFilter.FilterResult> createEvents = new ArrayList<ObjectFilter.FilterResult>();
        public final List<ObjectFilter.FilterResult> modifyEvents = new ArrayList<ObjectFilter.FilterResult>();

        private EntryListener() {
        }

        @CacheEntryCreated
        public void handleEvent(CacheEntryCreatedEvent<?, ObjectFilter.FilterResult> event) {
            ObjectFilter.FilterResult filterResult = (ObjectFilter.FilterResult)event.getValue();
            this.createEvents.add(filterResult);
        }

        @CacheEntryModified
        public void handleEvent(CacheEntryModifiedEvent<?, ObjectFilter.FilterResult> event) {
            ObjectFilter.FilterResult filterResult = (ObjectFilter.FilterResult)event.getValue();
            this.modifyEvents.add(filterResult);
        }
    }
}

