/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.searchmanager;

import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.query.Search;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.test.MultipleCacheManagersTest;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.searchmanager.ClusteredCacheQueryTimeoutTest")
public class ClusteredCacheQueryTimeoutTest
extends MultipleCacheManagersTest {
    private Cache cache1;

    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder cacheCfg = ClusteredCacheQueryTimeoutTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false);
        cacheCfg.indexing().enable().addIndexedEntity(Foo.class).addProperty("default.directory_provider", "local-heap").addProperty("lucene_version", "LUCENE_CURRENT");
        this.createClusteredCaches(2, cacheCfg);
        this.cache1 = this.cache(0);
    }

    @Test(enabled=false, description="ISPN-9469", expectedExceptions={UnsupportedOperationException.class}, expectedExceptionsMessageRegExp="Clustered queries do not support timeouts yet.")
    public void testClusteredQueryCacheTimeout() {
        QueryFactory queryFactory = Search.getQueryFactory((Cache)this.cache1);
        String q = String.format("FROM %s WHERE bar:'fakebar'", Foo.class.getName());
        Query query = queryFactory.create(q);
    }

    @Indexed(index="FooIndex")
    public class Foo {
        private String bar;

        public Foo(String bar) {
            this.bar = bar;
        }

        @Field(name="bar")
        public String getBar() {
            return this.bar;
        }
    }
}

