/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.searchmanager;

import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.Search;
import org.infinispan.query.dsl.Query;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.concurrent.TimeoutException;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.searchmanager.TimeoutTest")
public class TimeoutTest
extends SingleCacheManagerTest {
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder cfg = this.getDefaultStandaloneCacheConfig(true);
        cfg.indexing().enable().addIndexedEntity(Foo.class).addProperty("default.directory_provider", "local-heap").addProperty("lucene_version", "LUCENE_CURRENT");
        return TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)cfg);
    }

    @Test(enabled=false, description="ISPN-9469")
    public void timeoutExceptionIsThrown() {
        String q = String.format("FROM %s WHERE bar:'1'", Foo.class.getName());
        Query cacheQuery = Search.getQueryFactory((Cache)this.cache).create(q);
        try {
            cacheQuery.list();
            Assert.fail((String)"Expected TimeoutException");
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
    }

    @Indexed(index="FooIndex")
    public static class Foo {
        private String bar;

        public Foo(String bar) {
            this.bar = bar;
        }

        @Field(name="bar")
        public String getBar() {
            return this.bar;
        }
    }
}

