/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.backend;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.PrimitiveIterator;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import org.hibernate.search.backend.TransactionContext;
import org.hibernate.search.backend.spi.DeleteByQueryWork;
import org.hibernate.search.backend.spi.DeletionQuery;
import org.hibernate.search.backend.spi.SingularTermDeletionQuery;
import org.hibernate.search.backend.spi.Work;
import org.hibernate.search.backend.spi.WorkType;
import org.hibernate.search.backend.spi.Worker;
import org.hibernate.search.spi.IndexedTypeIdentifier;
import org.hibernate.search.spi.IndexingMode;
import org.hibernate.search.spi.SearchIntegrator;
import org.hibernate.search.spi.impl.PojoIndexedTypeIdentifier;
import org.infinispan.AdvancedCache;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.SegmentSpecificCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.functional.ReadWriteKeyCommand;
import org.infinispan.commands.functional.ReadWriteKeyValueCommand;
import org.infinispan.commands.functional.ReadWriteManyCommand;
import org.infinispan.commands.functional.ReadWriteManyEntriesCommand;
import org.infinispan.commands.functional.WriteOnlyKeyCommand;
import org.infinispan.commands.functional.WriteOnlyKeyValueCommand;
import org.infinispan.commands.functional.WriteOnlyManyCommand;
import org.infinispan.commands.functional.WriteOnlyManyEntriesCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.ComputeCommand;
import org.infinispan.commands.write.ComputeIfAbsentCommand;
import org.infinispan.commands.write.DataWriteCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.util.IntSet;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.distribution.DistributionInfo;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.encoding.DataConversion;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.interceptors.DDAsyncInterceptor;
import org.infinispan.interceptors.InvocationSuccessAction;
import org.infinispan.query.backend.KeyTransformationHandler;
import org.infinispan.query.backend.NoTransactionContext;
import org.infinispan.query.backend.SearchWorkCreator;
import org.infinispan.query.backend.SegmentListener;
import org.infinispan.query.logging.Log;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.concurrent.BlockingManager;
import org.infinispan.util.logging.LogFactory;

public final class QueryInterceptor
extends DDAsyncInterceptor {
    private static final Log log = (Log)LogFactory.getLog(QueryInterceptor.class, Log.class);
    private static final boolean trace = log.isTraceEnabled();
    static final Object UNKNOWN = new Object(){

        public String toString() {
            return "<UNKNOWN>";
        }
    };
    @Inject
    DistributionManager distributionManager;
    @Inject
    RpcManager rpcManager;
    @Inject
    @ComponentName(value="org.infinispan.executors.non-blocking")
    ExecutorService nonBlockingExecutor;
    @Inject
    BlockingManager blockingManager;
    @Inject
    protected KeyPartitioner keyPartitioner;
    private final SearchIntegrator searchFactory;
    private final KeyTransformationHandler keyTransformationHandler;
    private final AtomicBoolean stopping = new AtomicBoolean(false);
    private final ConcurrentMap<GlobalTransaction, Map<Object, Object>> txOldValues;
    private SearchWorkCreator searchWorkCreator = SearchWorkCreator.DEFAULT;
    private final DataConversion valueDataConversion;
    private final DataConversion keyDataConversion;
    private final boolean isPersistenceEnabled;
    private final InvocationSuccessAction<ClearCommand> processClearCommand = this::processClearCommand;
    private final boolean isManualIndexing;
    private final AdvancedCache<?, ?> cache;
    private final Map<String, Class<?>> indexedEntities;
    private SegmentListener segmentListener;

    public QueryInterceptor(SearchIntegrator searchFactory, KeyTransformationHandler keyTransformationHandler, ConcurrentMap<GlobalTransaction, Map<Object, Object>> txOldValues, AdvancedCache<?, ?> cache) {
        this.searchFactory = searchFactory;
        this.keyTransformationHandler = keyTransformationHandler;
        this.isManualIndexing = searchFactory.getIndexingMode() == IndexingMode.MANUAL;
        this.txOldValues = txOldValues;
        this.valueDataConversion = cache.getValueDataConversion();
        this.keyDataConversion = cache.getKeyDataConversion();
        this.isPersistenceEnabled = cache.getCacheConfiguration().persistence().usingStores();
        this.cache = cache;
        HashMap<String, Class> entities = new HashMap<String, Class>(2);
        for (Class c : cache.getCacheConfiguration().indexing().indexedEntities()) {
            entities.put(c.getName(), c);
        }
        for (IndexedTypeIdentifier typeIdentifier : searchFactory.getIndexBindings().keySet()) {
            Class c = typeIdentifier.getPojoType();
            entities.put(c.getName(), c);
        }
        this.indexedEntities = Collections.unmodifiableMap(entities);
    }

    @Start
    protected void start() {
        this.stopping.set(false);
        boolean isClustered = this.cache.getCacheConfiguration().clustering().cacheMode().isClustered();
        if (isClustered) {
            this.segmentListener = new SegmentListener(this.cache, this::purgeIndex, this.blockingManager);
            this.cache.addListener((Object)this.segmentListener);
        }
    }

    public void prepareForStopping() {
        if (this.segmentListener != null) {
            this.cache.removeListener((Object)this.segmentListener);
        }
        this.stopping.set(true);
    }

    private boolean shouldModifyIndexes(FlagAffectedCommand command, InvocationContext ctx, Object key) {
        if (this.isManualIndexing) {
            return false;
        }
        if (this.distributionManager == null || key == null) {
            return true;
        }
        DistributionInfo info = this.distributionManager.getCacheTopology().getDistribution(key);
        return info.isPrimary() || info.isWriteOwner() && (ctx.isInTxScope() || !ctx.isOriginLocal() || command != null && command.hasAnyFlag(FlagBitSets.PUT_FOR_STATE_TRANSFER));
    }

    public ExecutorService getAsyncExecutor() {
        return this.nonBlockingExecutor;
    }

    private Object handleDataWriteCommand(InvocationContext ctx, DataWriteCommand command) {
        Object prev;
        if (command.hasAnyFlag(FlagBitSets.SKIP_INDEXING)) {
            return this.invokeNext(ctx, (VisitableCommand)command);
        }
        CacheEntry entry = ctx.lookupEntry(command.getKey());
        if (ctx.isInTxScope()) {
            if (!(entry == null || entry.isChanged() || entry.getValue() == null && this.unreliablePreviousValue((WriteCommand)command))) {
                Map<Object, Object> oldValues = this.registerOldValues((TxInvocationContext)ctx);
                oldValues.putIfAbsent(command.getKey(), entry.getValue());
            }
            return this.invokeNext(ctx, (VisitableCommand)command);
        }
        Object object = prev = entry != null ? entry.getValue() : UNKNOWN;
        if (prev == null && this.unreliablePreviousValue((WriteCommand)command)) {
            prev = UNKNOWN;
        }
        Object oldValue = prev;
        return this.invokeNextThenApply(ctx, (VisitableCommand)command, (rCtx, cmd, rv) -> {
            CacheEntry entry2;
            if (!cmd.isSuccessful()) {
                return rv;
            }
            CacheEntry cacheEntry = entry2 = entry != null ? entry : rCtx.lookupEntry(cmd.getKey());
            if (entry2 != null && entry2.isChanged()) {
                return QueryInterceptor.asyncValue(this.blockingManager.runBlocking(() -> this.processChange(rCtx, (FlagAffectedCommand)cmd, cmd.getKey(), oldValue, entry2.getValue(), NoTransactionContext.INSTANCE), (Object)cmd).thenApply(ignore -> rv));
            }
            return rv;
        });
    }

    private Map<Object, Object> registerOldValues(TxInvocationContext ctx) {
        return this.txOldValues.computeIfAbsent(ctx.getGlobalTransaction(), gid -> {
            ctx.getCacheTransaction().addListener(() -> this.txOldValues.remove(gid));
            return new HashMap();
        });
    }

    private Object handleManyWriteCommand(InvocationContext ctx, WriteCommand command) {
        if (command.hasAnyFlag(FlagBitSets.SKIP_INDEXING)) {
            return this.invokeNext(ctx, (VisitableCommand)command);
        }
        if (ctx.isInTxScope()) {
            Map<Object, Object> oldValues = this.registerOldValues((TxInvocationContext)ctx);
            for (Object key : command.getAffectedKeys()) {
                CacheEntry entry = ctx.lookupEntry(key);
                if (entry == null || entry.isChanged() || entry.getValue() == null && this.unreliablePreviousValue(command)) continue;
                oldValues.putIfAbsent(key, entry.getValue());
            }
            return this.invokeNext(ctx, (VisitableCommand)command);
        }
        HashMap oldValues = new HashMap();
        for (Object key : command.getAffectedKeys()) {
            CacheEntry entry = ctx.lookupEntry(key);
            if (entry == null || entry.getValue() == null && this.unreliablePreviousValue(command)) continue;
            oldValues.put(key, entry.getValue());
        }
        return this.invokeNextThenAccept(ctx, (VisitableCommand)command, (rCtx, cmd, rv) -> {
            if (!cmd.isSuccessful()) {
                return;
            }
            for (Object key : cmd.getAffectedKeys()) {
                CacheEntry entry = rCtx.lookupEntry(key);
                if (entry == null || !entry.isChanged()) continue;
                Object oldValue = oldValues.getOrDefault(key, UNKNOWN);
                this.processChange(rCtx, (FlagAffectedCommand)cmd, key, oldValue, entry.getValue(), NoTransactionContext.INSTANCE);
            }
        });
    }

    private boolean unreliablePreviousValue(WriteCommand command) {
        return this.isPersistenceEnabled && (command.loadType() == VisitableCommand.LoadType.DONT_LOAD || command.hasAnyFlag(FlagBitSets.SKIP_CACHE_LOAD));
    }

    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) {
        return this.handleDataWriteCommand(ctx, (DataWriteCommand)command);
    }

    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) {
        return this.handleDataWriteCommand(ctx, (DataWriteCommand)command);
    }

    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) {
        return this.handleDataWriteCommand(ctx, (DataWriteCommand)command);
    }

    public Object visitComputeCommand(InvocationContext ctx, ComputeCommand command) {
        return this.handleDataWriteCommand(ctx, (DataWriteCommand)command);
    }

    public Object visitComputeIfAbsentCommand(InvocationContext ctx, ComputeIfAbsentCommand command) {
        return this.handleDataWriteCommand(ctx, (DataWriteCommand)command);
    }

    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) {
        return this.handleManyWriteCommand(ctx, (WriteCommand)command);
    }

    public Object visitClearCommand(InvocationContext ctx, ClearCommand command) {
        return this.invokeNextThenAccept(ctx, (VisitableCommand)command, this.processClearCommand);
    }

    public Object visitReadWriteKeyCommand(InvocationContext ctx, ReadWriteKeyCommand command) {
        return this.handleDataWriteCommand(ctx, (DataWriteCommand)command);
    }

    public Object visitWriteOnlyKeyCommand(InvocationContext ctx, WriteOnlyKeyCommand command) {
        return this.handleDataWriteCommand(ctx, (DataWriteCommand)command);
    }

    public Object visitReadWriteKeyValueCommand(InvocationContext ctx, ReadWriteKeyValueCommand command) {
        return this.handleDataWriteCommand(ctx, (DataWriteCommand)command);
    }

    public Object visitWriteOnlyManyEntriesCommand(InvocationContext ctx, WriteOnlyManyEntriesCommand command) {
        return this.handleManyWriteCommand(ctx, (WriteCommand)command);
    }

    public Object visitWriteOnlyKeyValueCommand(InvocationContext ctx, WriteOnlyKeyValueCommand command) {
        return this.handleDataWriteCommand(ctx, (DataWriteCommand)command);
    }

    public Object visitWriteOnlyManyCommand(InvocationContext ctx, WriteOnlyManyCommand command) {
        return this.handleManyWriteCommand(ctx, (WriteCommand)command);
    }

    public Object visitReadWriteManyCommand(InvocationContext ctx, ReadWriteManyCommand command) {
        return this.handleManyWriteCommand(ctx, (WriteCommand)command);
    }

    public Object visitReadWriteManyEntriesCommand(InvocationContext ctx, ReadWriteManyEntriesCommand command) {
        return this.handleManyWriteCommand(ctx, (WriteCommand)command);
    }

    public void purgeAllIndexes() {
        this.purgeAllIndexes(NoTransactionContext.INSTANCE);
    }

    public void purgeIndex(Class<?> entityType) {
        this.purgeIndex(NoTransactionContext.INSTANCE, entityType);
    }

    void purgeIndex(IntSet segments) {
        if (segments == null) {
            return;
        }
        PrimitiveIterator.OfInt ofInt = segments.iterator();
        while (ofInt.hasNext()) {
            int segment = (Integer)ofInt.next();
            SingularTermDeletionQuery deletionQuery = new SingularTermDeletionQuery("__segmentId", String.valueOf(segment));
            for (IndexedTypeIdentifier type : this.searchFactory.getIndexBindings().keySet()) {
                DeleteByQueryWork deleteWork = new DeleteByQueryWork(type, (DeletionQuery)deletionQuery);
                this.performSearchWork((Work)deleteWork, NoTransactionContext.INSTANCE);
            }
        }
    }

    void removeFromIndexes(TransactionContext transactionContext, Object key, int segment) {
        for (IndexedTypeIdentifier type : this.searchFactory.getIndexBindings().keySet()) {
            this.performSearchWork(this.searchWorkCreator.createPerEntityWork((Serializable)((Object)this.keyToString(key, segment)), type, WorkType.DELETE), transactionContext);
        }
    }

    private void purgeIndex(TransactionContext transactionContext, Class<?> entityType) {
        PojoIndexedTypeIdentifier type = new PojoIndexedTypeIdentifier(entityType);
        if (this.searchFactory.getIndexBindings().containsKey((IndexedTypeIdentifier)type)) {
            this.performSearchWork(this.searchWorkCreator.createPerEntityTypeWork((IndexedTypeIdentifier)type, WorkType.PURGE_ALL), transactionContext);
        }
    }

    private void purgeAllIndexes(TransactionContext transactionContext) {
        for (IndexedTypeIdentifier type : this.searchFactory.getIndexBindings().keySet()) {
            this.performSearchWork(this.searchWorkCreator.createPerEntityTypeWork(type, WorkType.PURGE_ALL), transactionContext);
        }
    }

    private void removeFromIndexes(Object value, Object key, TransactionContext transactionContext, int segment) {
        this.performSearchWork(value, (Serializable)((Object)this.keyToString(key, segment)), WorkType.DELETE, transactionContext);
    }

    private void updateIndexes(boolean usingSkipIndexCleanupFlag, Object value, Object key, TransactionContext transactionContext, int segment) {
        this.performSearchWork(value, (Serializable)((Object)this.keyToString(key, segment)), usingSkipIndexCleanupFlag ? WorkType.ADD : WorkType.UPDATE, transactionContext);
    }

    private void performSearchWork(Object value, Serializable id, WorkType workType, TransactionContext transactionContext) {
        if (value == null) {
            throw new NullPointerException("Cannot handle a null value!");
        }
        this.performSearchWork(this.searchWorkCreator.createPerEntityWork(value, id, workType), transactionContext);
    }

    private void performSearchWork(Work work, TransactionContext transactionContext) {
        if (work != null) {
            Worker worker = this.searchFactory.getWorker();
            worker.performWork(work, transactionContext);
        }
    }

    public Map<String, Class<?>> indexedEntities() {
        return this.indexedEntities;
    }

    private boolean isIndexedType(Object value) {
        return value != null && this.indexedEntities.containsValue(value.getClass());
    }

    private Object extractValue(Object storedValue) {
        return this.valueDataConversion.extractIndexable(storedValue);
    }

    private Object extractKey(Object storedKey) {
        return this.keyDataConversion.extractIndexable(storedKey);
    }

    private String keyToString(Object key, int segment) {
        return this.keyTransformationHandler.keyToString(key, segment);
    }

    public KeyTransformationHandler getKeyTransformationHandler() {
        return this.keyTransformationHandler;
    }

    public SearchWorkCreator getSearchWorkCreator() {
        return this.searchWorkCreator;
    }

    public void setSearchWorkCreator(SearchWorkCreator searchWorkCreator) {
        this.searchWorkCreator = searchWorkCreator;
    }

    void processChange(InvocationContext ctx, FlagAffectedCommand command, Object storedKey, Object storedOldValue, Object storedNewValue, TransactionContext transactionContext) {
        boolean skipIndexCleanup;
        int segment = SegmentSpecificCommand.extractSegment((ReplicableCommand)command, (Object)storedKey, (KeyPartitioner)this.keyPartitioner);
        Object key = this.extractKey(storedKey);
        Object oldValue = storedOldValue == UNKNOWN ? UNKNOWN : this.extractValue(storedOldValue);
        Object newValue = this.extractValue(storedNewValue);
        boolean bl = skipIndexCleanup = command != null && command.hasAnyFlag(FlagBitSets.SKIP_INDEX_CLEANUP);
        if (!skipIndexCleanup) {
            if (oldValue == UNKNOWN) {
                if (this.shouldModifyIndexes(command, ctx, storedKey)) {
                    this.removeFromIndexes(transactionContext, key, segment);
                }
            } else if (this.isIndexedType(oldValue) && (newValue == null || this.shouldRemove(newValue, oldValue)) && this.shouldModifyIndexes(command, ctx, storedKey)) {
                this.removeFromIndexes(oldValue, key, transactionContext, segment);
            } else if (trace) {
                log.tracef("Index cleanup not needed for %s -> %s", oldValue, newValue);
            }
        } else if (trace) {
            log.tracef("Skipped index cleanup for command %s", command);
        }
        if (this.isIndexedType(newValue)) {
            if (this.shouldModifyIndexes(command, ctx, storedKey)) {
                this.updateIndexes(skipIndexCleanup, newValue, key, transactionContext, segment);
            } else if (trace) {
                log.tracef("Not modifying index for %s (%s)", storedKey, command);
            }
        } else if (trace) {
            log.tracef("Update not needed for %s", newValue);
        }
    }

    private boolean shouldRemove(Object value, Object previousValue) {
        return value != null && previousValue != null && value.getClass() != previousValue.getClass();
    }

    private void processClearCommand(InvocationContext ctx, ClearCommand command, Object rv) {
        if (this.shouldModifyIndexes((FlagAffectedCommand)command, ctx, null)) {
            this.purgeAllIndexes(NoTransactionContext.INSTANCE);
        }
    }

    public boolean isStopping() {
        return this.stopping.get();
    }
}

