/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.impl;

import java.util.concurrent.ExecutorService;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.search.Query;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.query.engine.spi.TimeoutExceptionFactory;
import org.hibernate.search.spi.CustomTypeMetadata;
import org.hibernate.search.spi.IndexedTypeIdentifier;
import org.hibernate.search.spi.IndexedTypeMap;
import org.hibernate.search.spi.SearchIntegrator;
import org.hibernate.search.spi.impl.PojoIndexedTypeIdentifier;
import org.hibernate.search.stat.Statistics;
import org.infinispan.AdvancedCache;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.MassIndexer;
import org.infinispan.query.backend.KeyTransformationHandler;
import org.infinispan.query.backend.QueryInterceptor;
import org.infinispan.query.dsl.IndexedQueryMode;
import org.infinispan.query.dsl.embedded.impl.QueryEngine;
import org.infinispan.query.impl.ComponentRegistryUtils;
import org.infinispan.query.impl.QueryDefinition;
import org.infinispan.query.spi.SearchManagerImplementor;
import org.infinispan.util.concurrent.TimeoutException;

public final class SearchManagerImpl
implements SearchManagerImplementor {
    private final AdvancedCache<?, ?> cache;
    private final SearchIntegrator searchFactory;
    private final QueryInterceptor queryInterceptor;
    private final KeyTransformationHandler keyTransformationHandler;
    private final QueryEngine<?> queryEngine;
    private final MassIndexer massIndexer;
    private TimeoutExceptionFactory timeoutExceptionFactory;

    public SearchManagerImpl(AdvancedCache<?, ?> cache) {
        this(cache, ComponentRegistryUtils.getEmbeddedQueryEngine(cache));
    }

    public SearchManagerImpl(AdvancedCache<?, ?> cache, QueryEngine<?> queryEngine) {
        if (cache == null) {
            throw new IllegalArgumentException("cache parameter shall not be null");
        }
        this.cache = cache;
        this.searchFactory = ComponentRegistryUtils.getSearchIntegrator(cache);
        this.queryInterceptor = ComponentRegistryUtils.getQueryInterceptor(cache);
        this.keyTransformationHandler = ComponentRegistryUtils.getKeyTransformationHandler(cache);
        this.queryEngine = queryEngine;
        this.massIndexer = (MassIndexer)((Object)ComponentRegistryUtils.getIndexer(cache));
        this.timeoutExceptionFactory = (msg, q) -> new TimeoutException(msg + " \"" + q + '\"');
    }

    @Override
    public <E> CacheQuery<E> getQuery(Query luceneQuery, IndexedQueryMode indexedQueryMode, Class<?> entity) {
        return this.queryEngine.buildCacheQuery(luceneQuery, this.keyTransformationHandler, this.timeoutExceptionFactory, entity);
    }

    @Override
    public <E> CacheQuery<E> getQuery(String queryString, IndexedQueryMode indexedQueryMode) {
        ExecutorService asyncExecutor = this.queryInterceptor.getAsyncExecutor();
        try {
            return this.queryEngine.buildCacheQuery(queryString, indexedQueryMode, this.keyTransformationHandler, this.timeoutExceptionFactory, asyncExecutor);
        }
        catch (SearchException se) {
            throw new SearchException("'" + queryString + "' cannot be converted to an indexed query", (Throwable)se);
        }
    }

    @Override
    public <E> CacheQuery<E> getQuery(String queryString) {
        return this.getQuery(queryString, null);
    }

    @Override
    public <E> CacheQuery<E> getQuery(QueryDefinition queryDefinition, IndexedQueryMode indexedQueryMode, IndexedTypeMap<CustomTypeMetadata> indexedTypeMap) {
        ExecutorService asyncExecutor = this.queryInterceptor.getAsyncExecutor();
        return this.queryEngine.buildCacheQuery(queryDefinition, indexedQueryMode, this.keyTransformationHandler, asyncExecutor, indexedTypeMap);
    }

    @Override
    public void setTimeoutExceptionFactory(TimeoutExceptionFactory timeoutExceptionFactory) {
        this.timeoutExceptionFactory = timeoutExceptionFactory;
    }

    @Override
    public MassIndexer getMassIndexer() {
        return this.massIndexer;
    }

    @Override
    public Analyzer getAnalyzer(String name) {
        return this.searchFactory.getAnalyzer(name);
    }

    @Override
    public Statistics getStatistics() {
        return this.searchFactory.getStatistics();
    }

    @Override
    public Analyzer getAnalyzer(Class<?> clazz) {
        PojoIndexedTypeIdentifier type = new PojoIndexedTypeIdentifier(clazz);
        return this.searchFactory.getAnalyzer((IndexedTypeIdentifier)type);
    }

    @Override
    public void purge(Class<?> entityType) {
        this.queryInterceptor.purgeIndex(entityType);
    }

    @Override
    public <T> T unwrap(Class<T> cls) {
        if (SearchIntegrator.class.isAssignableFrom(cls)) {
            return (T)this.searchFactory;
        }
        if (SearchManagerImplementor.class.isAssignableFrom(cls)) {
            return (T)this;
        }
        throw new IllegalArgumentException("Cannot unwrap a SearchManagerImpl into a '" + cls.getName() + "'");
    }
}

