/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.clustered;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.spi.CustomTypeMetadata;
import org.hibernate.search.spi.IndexedTypeIdentifier;
import org.hibernate.search.spi.IndexedTypeMap;
import org.infinispan.AdvancedCache;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.FetchOptions;
import org.infinispan.query.ResultIterator;
import org.infinispan.query.backend.KeyTransformationHandler;
import org.infinispan.query.clustered.ClusteredQueryInvoker;
import org.infinispan.query.clustered.ClusteredQueryOperation;
import org.infinispan.query.clustered.DistributedIterator;
import org.infinispan.query.clustered.DistributedLazyIterator;
import org.infinispan.query.clustered.NodeTopDocs;
import org.infinispan.query.clustered.QueryResponse;
import org.infinispan.query.impl.CacheQueryImpl;
import org.infinispan.query.impl.QueryDefinition;
import org.infinispan.remoting.transport.Address;

public final class ClusteredCacheQueryImpl<E>
extends CacheQueryImpl<E> {
    private Integer resultSize;
    private final ClusteredQueryInvoker invoker;
    private int maxResults = 100;
    private int firstResult = 0;

    public ClusteredCacheQueryImpl(QueryDefinition queryDefinition, ExecutorService asyncExecutor, AdvancedCache<?, ?> cache, KeyTransformationHandler keyTransformationHandler, IndexedTypeMap<CustomTypeMetadata> metadata) {
        super(queryDefinition, cache, keyTransformationHandler);
        if (metadata != null) {
            this.queryDefinition.setIndexedType(((IndexedTypeIdentifier)metadata.keySet().iterator().next()).getPojoType());
            this.queryDefinition.setSortableField(((CustomTypeMetadata)metadata.values().iterator().next()).getSortableFields());
        }
        this.invoker = new ClusteredQueryInvoker(cache, asyncExecutor);
    }

    @Override
    public CacheQuery<E> maxResults(int maxResults) {
        this.maxResults = maxResults;
        return super.maxResults(maxResults);
    }

    @Override
    public CacheQuery<E> firstResult(int firstResult) {
        this.firstResult = firstResult;
        return super.firstResult(firstResult);
    }

    @Override
    public int getResultSize() {
        this.partitionHandlingSupport.checkCacheAvailable();
        if (this.resultSize == null) {
            List<QueryResponse> responses = this.invoker.broadcast(ClusteredQueryOperation.getResultSize(this.queryDefinition));
            int accumulator = 0;
            for (QueryResponse response : responses) {
                accumulator += response.getResultSize().intValue();
            }
            this.resultSize = accumulator;
        }
        return this.resultSize;
    }

    @Override
    public ResultIterator<E> iterator(FetchOptions fetchOptions) throws SearchException {
        this.partitionHandlingSupport.checkCacheAvailable();
        this.queryDefinition.setMaxResults(this.getNodeMaxResults());
        switch (fetchOptions.getFetchMode()) {
            case EAGER: {
                ClusteredQueryOperation command = ClusteredQueryOperation.createEagerIterator(this.queryDefinition);
                Map<Address, NodeTopDocs> topDocsResponses = this.broadcastQuery(command);
                return new DistributedIterator(this.queryDefinition.getSort(), fetchOptions.getFetchSize(), this.resultSize, this.maxResults, this.firstResult, topDocsResponses, this.cache);
            }
            case LAZY: {
                UUID queryId = UUID.randomUUID();
                ClusteredQueryOperation command = ClusteredQueryOperation.createLazyIterator(this.queryDefinition, queryId);
                Map<Address, NodeTopDocs> topDocsResponses = this.broadcastQuery(command);
                return new DistributedLazyIterator(this.queryDefinition.getSort(), fetchOptions.getFetchSize(), this.resultSize, this.maxResults, this.firstResult, queryId, topDocsResponses, this.invoker, this.cache);
            }
        }
        throw new IllegalArgumentException("Unknown FetchMode " + (Object)((Object)fetchOptions.getFetchMode()));
    }

    private int getNodeMaxResults() {
        return this.maxResults + this.firstResult;
    }

    private Map<Address, NodeTopDocs> broadcastQuery(ClusteredQueryOperation command) {
        HashMap<Address, NodeTopDocs> topDocsResponses = new HashMap<Address, NodeTopDocs>();
        int resultSize = 0;
        List<QueryResponse> responses = this.invoker.broadcast(command);
        for (QueryResponse queryResponse : responses) {
            if (queryResponse.getResultSize() <= 0) continue;
            topDocsResponses.put(queryResponse.getNodeTopDocs().address, queryResponse.getNodeTopDocs());
            resultSize += queryResponse.getResultSize().intValue();
        }
        this.resultSize = resultSize;
        return topDocsResponses;
    }

    @Override
    public List<E> list() throws SearchException {
        this.partitionHandlingSupport.checkCacheAvailable();
        ArrayList values = new ArrayList();
        try (ResultIterator<E> iterator = this.iterator(new FetchOptions().fetchMode(FetchOptions.FetchMode.EAGER));){
            while (iterator.hasNext()) {
                values.add(iterator.next());
            }
        }
        return values;
    }

    @Override
    public CacheQuery<E> timeout(long timeout, TimeUnit timeUnit) {
        throw new UnsupportedOperationException("Clustered queries do not support timeouts yet.");
    }
}

