/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.spi.IndexedTypeIdentifier;
import org.hibernate.search.spi.SearchIntegrator;
import org.hibernate.search.spi.impl.PojoIndexedTypeIdentifier;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.query.indexmanager.InfinispanIndexManager;

@Scope(value=Scopes.NAMED_CACHE)
public final class IndexInspector {
    private static final String ELASTICSEARCH_INDEX_MANAGER = "org.hibernate.search.elasticsearch.impl.ElasticsearchIndexManager";
    private final Map<Class<?>, IndexManager> indexManagerPerClass = new HashMap(2);
    private final Map<String, Class<?>> indexedEntities;
    private final SearchIntegrator searchFactory;
    private boolean hasLocalIndexes;

    public IndexInspector(Configuration cfg, SearchIntegrator searchFactory) {
        HashMap<String, Class> entities = new HashMap<String, Class>(2);
        for (Class c : cfg.indexing().indexedEntities()) {
            entities.put(c.getName(), c);
        }
        for (IndexedTypeIdentifier typeIdentifier : searchFactory.getIndexBindings().keySet()) {
            Class c = typeIdentifier.getPojoType();
            entities.put(c.getName(), c);
            this.hasLocalIndexes |= searchFactory.getIndexBinding(typeIdentifier).getIndexManagerSelector().all().stream().anyMatch(i -> !this.isShared((IndexManager)i));
        }
        this.indexedEntities = Collections.unmodifiableMap(entities);
        this.searchFactory = searchFactory;
    }

    Map<Class<?>, IndexManager> getIndexManagerPerClass() {
        if (this.indexManagerPerClass.isEmpty()) {
            for (Class<?> c : this.indexedEntities.values()) {
                PojoIndexedTypeIdentifier typeIdentifier = new PojoIndexedTypeIdentifier(c);
                Set indexManagers = this.searchFactory.getIndexBinding((IndexedTypeIdentifier)typeIdentifier).getIndexManagerSelector().all();
                Set ims = indexManagers.stream().map(Object::getClass).collect(Collectors.toSet());
                if (ims.size() > 1) {
                    throw new IllegalStateException("Different Shards using different index managers are not supported");
                }
                this.indexManagerPerClass.put(c, (IndexManager)indexManagers.iterator().next());
            }
        }
        return this.indexManagerPerClass;
    }

    public boolean hasSharedIndex(Class<?> entity) {
        IndexManager indexManager = this.getIndexManagerPerClass().get(entity);
        if (indexManager == null) {
            return false;
        }
        return this.isShared(indexManager);
    }

    private boolean isShared(IndexManager indexManager) {
        return indexManager instanceof InfinispanIndexManager || indexManager.getClass().getName().equals(ELASTICSEARCH_INDEX_MANAGER);
    }

    public boolean hasLocalIndexes() {
        return this.hasLocalIndexes;
    }

    public Map<String, Class<?>> getIndexedEntities() {
        return this.indexedEntities;
    }

    public boolean isIndexedType(Object value) {
        if (value == null) {
            return false;
        }
        Class<?> c = value.getClass();
        return this.indexedEntities.containsValue(c);
    }
}

