/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.indexmanager;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import org.hibernate.search.backend.FlushLuceneWork;
import org.hibernate.search.backend.IndexingMonitor;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.PurgeAllLuceneWork;
import org.hibernate.search.indexes.spi.IndexManager;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commons.util.Util;
import org.infinispan.query.indexmanager.IndexUpdateCommand;
import org.infinispan.query.indexmanager.IndexUpdateStreamCommand;
import org.infinispan.query.indexmanager.IndexingBackend;
import org.infinispan.query.logging.Log;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.ResponseCollector;
import org.infinispan.remoting.transport.impl.VoidResponseCollector;
import org.infinispan.util.ByteString;
import org.infinispan.util.logging.LogFactory;

final class RemoteIndexingBackend
implements IndexingBackend {
    private static final Log log = (Log)LogFactory.getLog(RemoteIndexingBackend.class, Log.class);
    private final int GRACE_MILLISECONDS_FOR_REPLACEMENT = 4000;
    private final int POLLING_MILLISECONDS_FOR_REPLACEMENT = 4000;
    protected static final Set<Class<? extends LuceneWork>> SYNC_ONLY_WORKS = Util.asSet((Object[])new Class[]{PurgeAllLuceneWork.class, FlushLuceneWork.class});
    private final String cacheName;
    private final String indexName;
    private final Address recipient;
    private final RpcManager rpcManager;
    private final Address masterAddress;
    private final boolean async;
    private volatile IndexingBackend replacement;

    public RemoteIndexingBackend(String cacheName, RpcManager rpcManager, String indexName, Address masterAddress, boolean async) {
        this.cacheName = cacheName;
        this.rpcManager = rpcManager;
        this.indexName = indexName;
        this.masterAddress = masterAddress;
        this.recipient = masterAddress;
        this.async = async;
    }

    @Override
    public void flushAndClose(IndexingBackend replacement) {
        if (replacement != null) {
            this.replacement = replacement;
        }
    }

    @Override
    public void applyWork(List<LuceneWork> workList, IndexingMonitor monitor, IndexManager indexManager) {
        IndexUpdateCommand command = new IndexUpdateCommand(ByteString.fromString((String)this.cacheName));
        byte[] serializedModel = indexManager.getSerializer().toSerializedModel(workList);
        command.setSerializedWorkList(serializedModel);
        command.setIndexName(this.indexName);
        try {
            log.applyingChangeListRemotely(workList);
            this.sendCommand(command, workList, this.shouldSendSync(workList));
        }
        catch (Exception e) {
            this.waitForReplacementBackend();
            if (this.replacement != null) {
                this.replacement.applyWork(workList, monitor, indexManager);
            }
            throw e;
        }
    }

    private boolean shouldSendSync(LuceneWork operation) {
        return !this.async || SYNC_ONLY_WORKS.contains(operation.getClass());
    }

    private boolean shouldSendSync(List<LuceneWork> operations) {
        return !this.async || operations.size() == 1 && this.shouldSendSync(operations.get(0));
    }

    @Override
    public void applyStreamWork(LuceneWork singleOperation, IndexingMonitor monitor, IndexManager indexManager) {
        IndexUpdateStreamCommand streamCommand = new IndexUpdateStreamCommand(ByteString.fromString((String)this.cacheName));
        List<LuceneWork> operations = Collections.singletonList(singleOperation);
        byte[] serializedModel = indexManager.getSerializer().toSerializedModel(operations);
        streamCommand.setSerializedWorkList(serializedModel);
        streamCommand.setIndexName(this.indexName);
        try {
            this.sendCommand(streamCommand, operations, this.shouldSendSync(singleOperation));
        }
        catch (Exception e) {
            this.waitForReplacementBackend();
            if (this.replacement != null) {
                this.replacement.applyStreamWork(singleOperation, monitor, indexManager);
            }
            throw e;
        }
    }

    private void waitForReplacementBackend() {
        int waitedMilliseconds = 0;
        try {
            while (this.replacement != null) {
                if (waitedMilliseconds >= 4000) {
                    return;
                }
                Thread.sleep(4000L);
                waitedMilliseconds += 4000;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private void sendCommand(ReplicableCommand command, List<LuceneWork> workList, boolean sync) {
        if (sync) {
            CompletionStage completionStage = this.rpcManager.invokeCommand(this.recipient, command, (ResponseCollector)VoidResponseCollector.ignoreLeavers(), this.rpcManager.getSyncRpcOptions());
            this.rpcManager.blocking(completionStage);
        } else {
            this.rpcManager.sendTo(this.recipient, command, DeliverOrder.PER_SENDER);
        }
        log.workListRemotedTo(workList, this.masterAddress);
    }

    @Override
    public boolean isMasterLocal() {
        return false;
    }

    public String toString() {
        return "RemoteIndexingBackend(" + this.masterAddress + ")";
    }
}

