/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.impl.massindex;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.hibernate.search.spi.IndexedTypeIdentifier;
import org.hibernate.search.spi.SearchIntegrator;
import org.hibernate.search.spi.impl.PojoIndexedTypeIdentifier;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.time.TimeService;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.LocalizedCacheTopology;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedOperation;
import org.infinispan.manager.ClusterExecutor;
import org.infinispan.query.MassIndexer;
import org.infinispan.query.backend.KeyTransformationHandler;
import org.infinispan.query.impl.IndexInspector;
import org.infinispan.query.impl.massindex.IndexUpdater;
import org.infinispan.query.impl.massindex.IndexWorker;
import org.infinispan.query.impl.massindex.MassIndexLock;
import org.infinispan.query.impl.massindex.MassIndexStrategy;
import org.infinispan.query.impl.massindex.MassIndexStrategyFactory;
import org.infinispan.query.impl.massindex.MassIndexerAlreadyStartedException;
import org.infinispan.query.impl.massindex.MassIndexerLockFactory;
import org.infinispan.query.logging.Log;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.concurrent.CompletionStages;
import org.infinispan.util.function.TriConsumer;
import org.infinispan.util.logging.LogFactory;

@MBean(objectName="MassIndexer", description="Component that rebuilds the Lucene index from the cached data")
@Scope(value=Scopes.NAMED_CACHE)
public class DistributedExecutorMassIndexer
implements MassIndexer {
    private static final Log LOG = (Log)LogFactory.getLog(DistributedExecutorMassIndexer.class, Log.class);
    private final AdvancedCache<?, ?> cache;
    private final SearchIntegrator searchIntegrator;
    private final IndexUpdater indexUpdater;
    private final ClusterExecutor executor;
    private final ExecutorService localExecutor;
    private final MassIndexLock lock;
    @Inject
    IndexInspector indexInspector;
    private static final TriConsumer<Address, Void, Throwable> TRI_CONSUMER = (a, v, t) -> {
        if (t != null) {
            throw new CacheException(t);
        }
    };

    public DistributedExecutorMassIndexer(AdvancedCache cache, SearchIntegrator searchIntegrator, KeyTransformationHandler keyTransformationHandler, TimeService timeService) {
        this.cache = cache;
        this.searchIntegrator = searchIntegrator;
        this.indexUpdater = new IndexUpdater(searchIntegrator, keyTransformationHandler, timeService);
        this.executor = cache.getCacheManager().executor();
        this.localExecutor = (ExecutorService)cache.getCacheManager().getGlobalComponentRegistry().getComponent(ExecutorService.class, "org.infinispan.executors.blocking");
        this.lock = MassIndexerLockFactory.buildLock(cache);
    }

    @Override
    @ManagedOperation(description="Starts rebuilding the index", displayName="Rebuild index")
    public void start() {
        CompletionStages.join(this.executeInternal(false));
    }

    @Override
    public CompletableFuture<Void> purge() {
        return this.executeInternal(true);
    }

    @Override
    public CompletableFuture<Void> startAsync() {
        return this.executeInternal(false);
    }

    @Override
    public CompletableFuture<Void> reindex(Object ... keys) {
        CompletableFuture<Void> future = null;
        HashSet<Object> everywhereSet = new HashSet<Object>();
        HashSet<Object> primeownerSet = new HashSet<Object>();
        for (Object key : keys) {
            if (this.cache.containsKey(key)) {
                Class<?> indexedType = this.cache.get(key).getClass();
                MassIndexStrategy massIndexStrategy = MassIndexStrategyFactory.calculateStrategy(this.indexInspector, (IndexedTypeIdentifier)new PojoIndexedTypeIdentifier(indexedType));
                MassIndexStrategy.IndexingExecutionMode indexingStrategy = massIndexStrategy.getIndexingStrategy();
                switch (indexingStrategy) {
                    case ALL: {
                        everywhereSet.add(key);
                        break;
                    }
                    case PRIMARY_OWNER: {
                        primeownerSet.add(key);
                    }
                }
                continue;
            }
            LOG.warn("cache contains no mapping for the key");
        }
        TriConsumer triConsumer = (a, v, t) -> {
            if (t != null) {
                throw new CacheException(t);
            }
        };
        if (everywhereSet.size() > 0) {
            IndexWorker indexWorkEverywhere = new IndexWorker(this.cache.getName(), null, false, false, false, false, everywhereSet);
            future = this.executor.submitConsumer((Function)indexWorkEverywhere, triConsumer);
        }
        if (primeownerSet.size() > 0) {
            HashMap targets = new HashMap();
            DistributionManager distributionManager = this.cache.getDistributionManager();
            if (distributionManager != null) {
                ArrayList<CompletableFuture> futures;
                LocalizedCacheTopology localizedCacheTopology = this.cache.getDistributionManager().getCacheTopology();
                for (Object e : primeownerSet) {
                    Address primary = localizedCacheTopology.getDistribution(e).primary();
                    HashSet keysForAddress = (HashSet)targets.get(primary);
                    if (keysForAddress == null) {
                        keysForAddress = new HashSet();
                        targets.put(primary, keysForAddress);
                    }
                    keysForAddress.add(e);
                }
                if (future != null) {
                    futures = new ArrayList(targets.size() + 1);
                    futures.add(future);
                } else {
                    futures = new ArrayList<CompletableFuture>(targets.size());
                }
                for (Map.Entry entry : targets.entrySet()) {
                    IndexWorker indexWorkEverywhere = new IndexWorker(this.cache.getName(), null, false, false, false, false, (Set)entry.getValue());
                    futures.add(this.executor.filterTargets(Collections.singleton((Address)entry.getKey())).submitConsumer((Function)indexWorkEverywhere, triConsumer));
                }
                future = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
            } else {
                IndexWorker indexWorkEverywhere = new IndexWorker(this.cache.getName(), null, false, false, false, false, primeownerSet);
                CompletableFuture localFuture = this.executor.submitConsumer((Function)indexWorkEverywhere, triConsumer);
                future = future != null ? CompletableFuture.allOf(future, localFuture) : localFuture;
            }
        }
        return future != null ? future : CompletableFutures.completedNull();
    }

    @Override
    public boolean isRunning() {
        return this.lock.isAcquired();
    }

    private CompletableFuture<Void> executeInternal(boolean skipIndex) {
        if (this.lock.lock()) {
            ArrayList futures = new ArrayList();
            LinkedList toFlush = new LinkedList();
            BiConsumer<Void, Throwable> flushIfNeeded = (v, t) -> {
                try {
                    this.indexUpdater.flush(toFlush);
                }
                finally {
                    this.lock.unlock();
                }
            };
            HashMap<MassIndexStrategy, Set> strategyPerType = new HashMap<MassIndexStrategy, Set>();
            for (IndexedTypeIdentifier indexedType : this.searchIntegrator.getIndexBindings().keySet()) {
                MassIndexStrategy strategy2 = MassIndexStrategyFactory.calculateStrategy(this.indexInspector, indexedType);
                strategyPerType.computeIfAbsent(strategy2, s -> new HashSet()).add(indexedType);
            }
            try {
                strategyPerType.forEach((strategy, indexedTypes) -> {
                    boolean workerClean = true;
                    boolean workerFlush = true;
                    if (strategy.getCleanStrategy() == MassIndexStrategy.CleanExecutionMode.ONCE_BEFORE) {
                        this.indexUpdater.purge((Collection<IndexedTypeIdentifier>)indexedTypes);
                        workerClean = false;
                    }
                    if (strategy.getFlushStrategy() == MassIndexStrategy.FlushExecutionMode.ONCE_AFTER) {
                        toFlush.addAll(indexedTypes);
                        workerFlush = false;
                    }
                    IndexWorker indexWork = new IndexWorker(this.cache.getName(), (Set<IndexedTypeIdentifier>)indexedTypes, workerFlush, workerClean, skipIndex, strategy.getIndexingStrategy() == MassIndexStrategy.IndexingExecutionMode.PRIMARY_OWNER, null);
                    futures.add(this.executor.submitConsumer((Function)indexWork, TRI_CONSUMER));
                });
                CompletableFuture<Void> compositeFuture = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
                return compositeFuture.whenCompleteAsync((BiConsumer)flushIfNeeded, (Executor)this.localExecutor);
            }
            catch (Throwable t2) {
                this.lock.unlock();
                return CompletableFutures.completedExceptionFuture((Throwable)t2);
            }
        }
        return CompletableFutures.completedExceptionFuture((Throwable)new MassIndexerAlreadyStartedException());
    }
}

