/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.api;

import java.util.ArrayList;
import java.util.List;
import org.infinispan.Cache;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.Search;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.queries.faceting.Car;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.api.ManualIndexingTest")
public class ManualIndexingTest
extends MultipleCacheManagersTest {
    protected static final int NUM_NODES = 4;
    protected List<Cache<String, Car>> caches = new ArrayList<Cache<String, Car>>(4);

    protected void createCacheManagers() throws Throwable {
        for (int i = 0; i < 4; ++i) {
            EmbeddedCacheManager cacheManager = TestCacheManagerFactory.fromXml((String)"manual-indexing-distribution.xml");
            this.registerCacheManager(new CacheContainer[]{cacheManager});
            Cache cache = cacheManager.getCache();
            this.caches.add((Cache<String, Car>)cache);
        }
        this.waitForClusterToForm("default");
    }

    public void testManualIndexing() {
        this.caches.get(0).put((Object)"car A", (Object)new Car("ford", "blue", 400));
        this.caches.get(0).put((Object)"car B", (Object)new Car("megane", "white", 300));
        this.caches.get(0).put((Object)"car C", (Object)new Car("megane", "red", 500));
        this.assertNumberOfCars(0, "megane");
        this.assertNumberOfCars(0, "ford");
        Search.getSearchManager(this.caches.get(0)).getMassIndexer().start();
        this.assertNumberOfCars(2, "megane");
        this.assertNumberOfCars(1, "ford");
    }

    private void assertNumberOfCars(int expectedCount, String carMake) {
        for (Cache<String, Car> cache : this.caches) {
            QueryFactory queryFactory = Search.getQueryFactory(cache);
            Query query = queryFactory.create(String.format("FROM %s where make:'%s'", Car.class.getName(), carMake));
            AssertJUnit.assertEquals((String)("Expected count not met on cache " + cache), (int)expectedCount, (int)query.getResultSize());
            AssertJUnit.assertEquals((String)("Expected count not met on cache " + cache), (int)expectedCount, (int)query.list().size());
        }
    }
}

