/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.blackbox;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;
import org.apache.lucene.index.IndexReader;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.exception.SearchException;
import org.infinispan.Cache;
import org.infinispan.commons.CacheException;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.HashConfiguration;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.FetchOptions;
import org.infinispan.query.ResultIterator;
import org.infinispan.query.Search;
import org.infinispan.query.SearchManager;
import org.infinispan.query.dsl.IndexedQueryMode;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.helper.StaticTestingErrorHandler;
import org.infinispan.query.test.Person;
import org.infinispan.query.test.QueryTestSCI;
import org.infinispan.test.MultipleCacheManagersTest;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.blackbox.ClusteredQueryTest")
public class ClusteredQueryTest
extends MultipleCacheManagersTest {
    static final int NUM_ENTRIES = 50;
    Cache<String, Person> cacheAMachine1;
    Cache<String, Person> cacheAMachine2;
    private CacheQuery<Person> cacheQuery;
    protected String queryString = String.format("FROM %s where blurb:'blurb1?'", Person.class.getName());
    private final String allPersonsQuery = "FROM " + Person.class.getName();

    public Object[] factory() {
        return new Object[]{new ClusteredQueryTest().storageType(StorageType.OFF_HEAP), new ClusteredQueryTest().storageType(StorageType.BINARY), new ClusteredQueryTest().storageType(StorageType.OBJECT)};
    }

    @AfterMethod
    protected void clearContent() {
    }

    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder cacheCfg = ClusteredQueryTest.getDefaultClusteredCacheConfig((CacheMode)this.getCacheMode(), (boolean)false);
        cacheCfg.clustering().hash().numOwners(this.numOwners()).indexing().enable().addIndexedEntity(Person.class).addProperty("default.directory_provider", "local-heap").addProperty("error_handler", StaticTestingErrorHandler.class.getName());
        cacheCfg.memory().storageType(this.storageType);
        this.createClusteredCaches(2, QueryTestSCI.INSTANCE, cacheCfg);
        this.cacheAMachine1 = this.cache(0);
        this.cacheAMachine2 = this.cache(1);
        this.populateCache();
    }

    protected CacheMode getCacheMode() {
        return CacheMode.REPL_SYNC;
    }

    protected int numOwners() {
        return (Integer)HashConfiguration.NUM_OWNERS.getDefaultValue();
    }

    protected void prepareTestData() {
        IntStream.range(0, 50).boxed().map(i -> new Person("name" + i, "blurb" + i, (int)i)).forEach(p -> {
            Cache<String, Person> cache = p.getAge() % 2 == 0 ? this.cacheAMachine1 : this.cacheAMachine2;
            cache.put((Object)p.getName(), p);
        });
        StaticTestingErrorHandler.assertAllGood(this.cacheAMachine1, this.cacheAMachine2);
    }

    public void testLazyOrdered() {
        CacheQuery<Person> cacheQuery = this.createSortedQuery("age");
        for (int i = 0; i < 2; ++i) {
            try (ResultIterator iterator = cacheQuery.iterator(new FetchOptions().fetchMode(FetchOptions.FetchMode.LAZY));){
                assert (cacheQuery.getResultSize() == 10) : cacheQuery.getResultSize();
                int previousAge = 0;
                while (iterator.hasNext()) {
                    Person person = (Person)iterator.next();
                    assert (person.getAge() > previousAge);
                    previousAge = person.getAge();
                }
                continue;
            }
        }
        StaticTestingErrorHandler.assertAllGood(this.cacheAMachine1, this.cacheAMachine2);
    }

    public void testLazyNonOrdered() {
        try (ResultIterator ignored = this.cacheQuery.iterator(new FetchOptions().fetchMode(FetchOptions.FetchMode.LAZY));){
            assert (this.cacheQuery.getResultSize() == 10) : this.cacheQuery.getResultSize();
        }
        StaticTestingErrorHandler.assertAllGood(this.cacheAMachine1, this.cacheAMachine2);
    }

    public void testLocalQuery() {
        SearchManager searchManager1 = Search.getSearchManager(this.cacheAMachine1);
        CacheQuery localQuery1 = searchManager1.getQuery(this.queryString);
        List results1 = localQuery1.list();
        SearchManager searchManager2 = Search.getSearchManager(this.cacheAMachine2);
        CacheQuery localQuery2 = searchManager2.getQuery(this.queryString);
        List results2 = localQuery2.list();
        AssertJUnit.assertEquals((int)10, (int)results1.size());
        AssertJUnit.assertEquals((int)10, (int)results2.size());
        StaticTestingErrorHandler.assertAllGood(this.cacheAMachine1, this.cacheAMachine2);
    }

    public void testEagerOrdered() {
        CacheQuery<Person> cacheQuery = this.createSortedQuery("age");
        try (ResultIterator iterator = cacheQuery.iterator(new FetchOptions().fetchMode(FetchOptions.FetchMode.EAGER));){
            AssertJUnit.assertEquals((int)10, (int)cacheQuery.getResultSize());
            int previousAge = 0;
            while (iterator.hasNext()) {
                Person person = (Person)iterator.next();
                assert (person.getAge() > previousAge);
                previousAge = person.getAge();
            }
        }
        StaticTestingErrorHandler.assertAllGood(this.cacheAMachine1, this.cacheAMachine2);
    }

    @Test(expectedExceptions={NoSuchElementException.class})
    public void testIteratorNextOutOfBounds() {
        this.cacheQuery.maxResults(1);
        try (ResultIterator iterator = this.cacheQuery.iterator(new FetchOptions().fetchMode(FetchOptions.FetchMode.EAGER));){
            assert (iterator.hasNext());
            iterator.next();
            assert (!iterator.hasNext());
            iterator.next();
        }
        StaticTestingErrorHandler.assertAllGood(this.cacheAMachine1, this.cacheAMachine2);
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testIteratorRemove() {
        this.cacheQuery.maxResults(1);
        try (ResultIterator iterator = this.cacheQuery.iterator(new FetchOptions().fetchMode(FetchOptions.FetchMode.EAGER));){
            assert (iterator.hasNext());
            iterator.remove();
        }
        StaticTestingErrorHandler.assertAllGood(this.cacheAMachine1, this.cacheAMachine2);
    }

    public void testList() {
        CacheQuery<Person> cacheQuery = this.createSortedQuery("age");
        List results = cacheQuery.list();
        AssertJUnit.assertEquals((int)10, (int)cacheQuery.getResultSize());
        int previousAge = 0;
        for (Person person : results) {
            assert (person.getAge() > previousAge);
            previousAge = person.getAge();
        }
        StaticTestingErrorHandler.assertAllGood(this.cacheAMachine1, this.cacheAMachine2);
    }

    public void testGetResultSizeList() {
        AssertJUnit.assertEquals((int)10, (int)this.cacheQuery.getResultSize());
    }

    public void testPagination() {
        CacheQuery<Person> cacheQuery = this.createSortedQuery("age");
        cacheQuery.firstResult(2);
        cacheQuery.maxResults(1);
        List results = cacheQuery.list();
        AssertJUnit.assertEquals((int)1, (int)results.size());
        AssertJUnit.assertEquals((int)10, (int)cacheQuery.getResultSize());
        Person result = (Person)results.get(0);
        AssertJUnit.assertEquals((int)12, (int)result.getAge());
        StaticTestingErrorHandler.assertAllGood(this.cacheAMachine1, this.cacheAMachine2);
    }

    @Test
    public void testPagination2() {
        int[] pageSizes;
        for (int pageSize : pageSizes = new int[]{1, 5, 7, 60}) {
            this.testPaginationWithoutSort(pageSize);
            this.testPaginationWithSort(pageSize, "age");
        }
    }

    private void testPaginationWithoutSort(int pageSize) {
        this.testPaginationInternal(pageSize, null);
    }

    private void testPaginationWithSort(int pageSize, String sortField) {
        this.testPaginationInternal(pageSize, sortField);
    }

    private void testPaginationInternal(int pageSize, String sortField) {
        CacheQuery<Person> paginationQuery = this.buildPaginationQuery(0, pageSize, sortField);
        int idx = 0;
        HashSet keys = new HashSet();
        while (idx < 50) {
            List results = paginationQuery.list();
            results.stream().map(Person::getName).forEach(keys::add);
            paginationQuery = this.buildPaginationQuery(idx += pageSize, pageSize, sortField);
        }
        AssertJUnit.assertEquals((int)50, (int)keys.size());
        StaticTestingErrorHandler.assertAllGood(this.cacheAMachine1, this.cacheAMachine2);
    }

    private CacheQuery<Person> buildPaginationQuery(int offset, int pageSize, String sortField) {
        String sortedQuery = sortField != null ? this.allPersonsQuery + " ORDER BY " + sortField : this.allPersonsQuery;
        CacheQuery clusteredQuery = Search.getSearchManager(this.cacheAMachine1).getQuery(sortedQuery);
        clusteredQuery.firstResult(offset);
        clusteredQuery.maxResults(pageSize);
        return clusteredQuery;
    }

    public void testQueryAll() {
        CacheQuery clusteredQuery = Search.getSearchManager(this.cacheAMachine1).getQuery(this.allPersonsQuery);
        AssertJUnit.assertEquals((int)50, (int)clusteredQuery.list().size());
        StaticTestingErrorHandler.assertAllGood(this.cacheAMachine1, this.cacheAMachine2);
    }

    public void testFuzzyQuery() {
        this.populateCache();
        String q = String.format("FROM %s WHERE name:'name1'~2", Person.class.getName());
        CacheQuery clusteredQuery = Search.getSearchManager(this.cacheAMachine1).getQuery(q);
        AssertJUnit.assertEquals((int)50, (int)clusteredQuery.list().size());
        StaticTestingErrorHandler.assertAllGood(this.cacheAMachine1, this.cacheAMachine2);
    }

    public void testBroadcastIckleMatchAllQuery() {
        CacheQuery everybody = Search.getSearchManager(this.cacheAMachine1).getQuery(String.format("FROM %s", Person.class.getName()));
        AssertJUnit.assertEquals((int)50, (int)everybody.list().size());
        StaticTestingErrorHandler.assertAllGood(this.cacheAMachine1, this.cacheAMachine2);
    }

    public void testBroadcastIckleTermQuery() {
        String targetName = "name2";
        CacheQuery singlePerson = Search.getSearchManager(this.cacheAMachine1).getQuery(String.format("FROM %s p where p.name:'%s'", Person.class.getName(), targetName));
        AssertJUnit.assertEquals((int)1, (int)singlePerson.list().size());
        AssertJUnit.assertEquals((String)targetName, (String)((Person)singlePerson.list().iterator().next()).getName());
        StaticTestingErrorHandler.assertAllGood(this.cacheAMachine1, this.cacheAMachine2);
    }

    public void testBroadcastFuzzyIckle() {
        CacheQuery persons0to10 = Search.getSearchManager(this.cacheAMachine1).getQuery(String.format("FROM %s p where p.name:'nome'~2", Person.class.getName()));
        AssertJUnit.assertEquals((int)10, (int)persons0to10.list().size());
        StaticTestingErrorHandler.assertAllGood(this.cacheAMachine1, this.cacheAMachine2);
    }

    public void testBroadcastNumericRangeQuery() {
        CacheQuery infants = Search.getSearchManager(this.cacheAMachine1).getQuery(String.format("FROM %s p where p.age between 0 and 5", Person.class.getName()));
        AssertJUnit.assertEquals((int)6, (int)infants.list().size());
        StaticTestingErrorHandler.assertAllGood(this.cacheAMachine1, this.cacheAMachine2);
    }

    public void testBroadcastProjectionIckleQuery() {
        SearchManager sm = Search.getSearchManager(this.cacheAMachine2);
        CacheQuery onlyNames = sm.getQuery(String.format("Select p.name FROM %s p", Person.class.getName()));
        List results = onlyNames.list();
        AssertJUnit.assertEquals((int)50, (int)results.size());
        HashSet names = new HashSet();
        results.iterator().forEachRemaining(s -> names.add((String)s[0]));
        Set allNames = IntStream.range(0, 50).boxed().map(i -> "name" + i).collect(Collectors.toSet());
        AssertJUnit.assertEquals(allNames, names);
        StaticTestingErrorHandler.assertAllGood(this.cacheAMachine1, this.cacheAMachine2);
    }

    public void testBroadcastSortedIckleQuery() {
        SearchManager sm = Search.getSearchManager(this.cacheAMachine2);
        CacheQuery theLastWillBeFirst = sm.getQuery(String.format("FROM %s p order by p.age desc", Person.class.getName()));
        List results = theLastWillBeFirst.list();
        AssertJUnit.assertEquals((int)50, (int)results.size());
        AssertJUnit.assertEquals((int)49, (int)((Person)results.iterator().next()).getAge());
        StaticTestingErrorHandler.assertAllGood(this.cacheAMachine1, this.cacheAMachine2);
    }

    public void testPaginatedIckleQuery() {
        SearchManager sm = Search.getSearchManager(this.cacheAMachine1);
        CacheQuery q = sm.getQuery(String.format("FROM %s p order by p.age", Person.class.getName()));
        q.firstResult(5);
        q.maxResults(10);
        List results = q.list();
        AssertJUnit.assertEquals((int)10, (int)results.size());
        AssertJUnit.assertEquals((String)"name5", (String)((Person)results.iterator().next()).getName());
        AssertJUnit.assertEquals((String)"name14", (String)((Person)results.get(9)).getName());
    }

    public void testPartialIckleQuery() {
        SearchManager searchManager1 = Search.getSearchManager(this.cacheAMachine1);
        SearchManager searchManager2 = Search.getSearchManager(this.cacheAMachine2);
        String query = String.format("FROM %s p", Person.class.getName());
        CacheQuery machine1Results = searchManager1.getQuery(query, IndexedQueryMode.FETCH);
        CacheQuery machine2Results = searchManager2.getQuery(query, IndexedQueryMode.FETCH);
        int numDocsMachine1 = this.countLocalIndex(this.cacheAMachine1);
        int numDocsMachine2 = this.countLocalIndex(this.cacheAMachine2);
        AssertJUnit.assertEquals((int)(this.numOwners() * 50), (int)(numDocsMachine1 + numDocsMachine2));
        AssertJUnit.assertEquals((int)numDocsMachine1, (int)machine1Results.list().size());
        AssertJUnit.assertEquals((int)numDocsMachine2, (int)machine2Results.list().size());
        StaticTestingErrorHandler.assertAllGood(this.cacheAMachine1, this.cacheAMachine2);
    }

    private int countLocalIndex(Cache<String, Person> cache) {
        SearchManager sm = Search.getSearchManager(cache);
        ExtendedSearchIntegrator esi = (ExtendedSearchIntegrator)sm.unwrap(ExtendedSearchIntegrator.class);
        IndexReader indexReader = esi.getIndexManager("person").getReaderProvider().openIndexReader();
        return indexReader.numDocs();
    }

    @Test(expectedExceptions={SearchException.class}, expectedExceptionsMessageRegExp=".*cannot be converted to an indexed query")
    public void testPreventHybridQuery() {
        CacheQuery hybridQuery = Search.getSearchManager(this.cacheAMachine1).getQuery(String.format("FROM %s p where p.nonIndexedField = 'nothing'", Person.class.getName()));
        hybridQuery.list();
    }

    @Test(expectedExceptions={CacheException.class}, expectedExceptionsMessageRegExp=".*cannot be converted to an indexed query")
    public void testPreventAggregationQueries() {
        CacheQuery aggregationQuery = Search.getSearchManager(this.cacheAMachine1).getQuery(String.format("FROM %s p where p.name:'name3' group by p.name", Person.class.getName()));
        aggregationQuery.list();
    }

    @Test
    public void testBroadcastNativeInfinispanMatchAllQuery() {
        String q = String.format("FROM %s", Person.class.getName());
        Query partialResultQuery = Search.getQueryFactory(this.cacheAMachine1).create(q, IndexedQueryMode.FETCH);
        Query fullResultQuery = Search.getQueryFactory(this.cacheAMachine2).create(q);
        int docsInMachine1 = this.countLocalIndex(this.cacheAMachine1);
        AssertJUnit.assertEquals((int)docsInMachine1, (int)partialResultQuery.list().size());
        AssertJUnit.assertEquals((int)50, (int)fullResultQuery.list().size());
    }

    @Test
    public void testBroadcastNativeInfinispanHybridQuery() {
        String q = "FROM " + Person.class.getName() + " where age >= 40 and nonIndexedField = 'na'";
        Query query = Search.getQueryFactory(this.cacheAMachine1).create(q);
        AssertJUnit.assertEquals((int)10, (int)query.list().size());
    }

    @Test
    public void testBroadcastNativeInfinispanFuzzyQuery() {
        String q = String.format("FROM %s p where p.name:'nome'~2", Person.class.getName());
        Query query = Search.getQueryFactory(this.cacheAMachine1).create(q);
        AssertJUnit.assertEquals((int)10, (int)query.list().size());
    }

    @Test
    public void testBroadcastSortedInfinispanQuery() {
        QueryFactory queryFactory = Search.getQueryFactory(this.cacheAMachine1);
        Query sortedQuery = queryFactory.create("FROM " + Person.class.getName() + " p order by p.age desc");
        List results = sortedQuery.list();
        AssertJUnit.assertEquals((int)50, (int)results.size());
        AssertJUnit.assertEquals((int)49, (int)((Person)results.iterator().next()).getAge());
        StaticTestingErrorHandler.assertAllGood(this.cacheAMachine1, this.cacheAMachine2);
    }

    @Test
    public void testIckleProjectionsLazyRetrieval() {
        SearchManager searchManager = Search.getSearchManager(this.cacheAMachine1);
        String query = String.format("SELECT name, blurb FROM %s p ORDER BY age", Person.class.getName());
        CacheQuery cacheQuery = searchManager.getQuery(query, IndexedQueryMode.BROADCAST);
        ResultIterator iterator = cacheQuery.iterator(new FetchOptions().fetchMode(FetchOptions.FetchMode.LAZY));
        List values = this.toList((Iterator)iterator);
        for (int i = 0; i < 50; ++i) {
            Object[] projection = (Object[])values.get(i);
            AssertJUnit.assertEquals((Object)projection[0], (Object)("name" + i));
            AssertJUnit.assertEquals((Object)projection[1], (Object)("blurb" + i));
        }
    }

    private <E> List<E> toList(Iterator<E> iterator) {
        return StreamSupport.stream(((Iterable)() -> iterator).spliterator(), false).collect(Collectors.toList());
    }

    @Test
    public void testBroadcastAggregatedInfinispanQuery() {
        QueryFactory queryFactory = Search.getQueryFactory(this.cacheAMachine2);
        Query hybridQuery = queryFactory.create("select name FROM " + Person.class.getName() + " WHERE name : 'na*' group by name");
        AssertJUnit.assertEquals((int)50, (int)hybridQuery.list().size());
    }

    @Test
    public void testNonIndexedBroadcastInfinispanQuery() {
        QueryFactory queryFactory = Search.getQueryFactory(this.cacheAMachine2);
        Query slowQuery = queryFactory.create("FROM " + Person.class.getName() + " WHERE nonIndexedField LIKE 'na%'");
        AssertJUnit.assertEquals((int)50, (int)slowQuery.list().size());
    }

    protected void populateCache() {
        this.prepareTestData();
        this.cacheQuery = Search.getSearchManager(this.cacheAMachine1).getQuery(this.queryString);
        StaticTestingErrorHandler.assertAllGood(this.cacheAMachine1, this.cacheAMachine2);
    }

    protected CacheQuery<Person> createSortedQuery(String sortField) {
        String q = String.format("FROM %s p where p.blurb:'blurb1?' order by p.%s'", Person.class.getName(), sortField);
        return Search.getSearchManager(this.cacheAMachine1).getQuery(q);
    }
}

