/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.blackbox;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.hibernate.search.filter.FullTextFilter;
import org.infinispan.Cache;
import org.infinispan.cache.impl.CacheImpl;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.FetchOptions;
import org.infinispan.query.ResultIterator;
import org.infinispan.query.Search;
import org.infinispan.query.SearchManager;
import org.infinispan.query.helper.StaticTestingErrorHandler;
import org.infinispan.query.spi.SearchManagerImplementor;
import org.infinispan.query.test.AnotherGrassEater;
import org.infinispan.query.test.CustomKey3;
import org.infinispan.query.test.CustomKey3Transformer;
import org.infinispan.query.test.Person;
import org.infinispan.query.test.QueryTestSCI;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.mockito.Mockito;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional", "smoke"}, testName="query.blackbox.LocalCacheTest")
public class LocalCacheTest
extends SingleCacheManagerTest {
    protected Person person1;
    protected Person person2;
    protected Person person3;
    protected Person person4;
    protected AnotherGrassEater anotherGrassEater;
    protected String key1 = "Navin";
    protected String key2 = "BigGoat";
    protected String key3 = "MiniGoat";
    protected String anotherGrassEaterKey = "anotherGrassEaterKey";

    public LocalCacheTest() {
        this.cleanup = AbstractCacheTest.CleanupPhase.AFTER_METHOD;
    }

    private CacheQuery<Person> createQuery(String predicate, Class<?> entity) {
        SearchManager searchManager = Search.getSearchManager((Cache)this.cache);
        return searchManager.getQuery(String.format("FROM %s WHERE %s", entity.getName(), predicate));
    }

    public void testSimple() {
        this.loadTestingData();
        CacheQuery<Person> cacheQuery = this.createQuery("blurb:'playing'", Person.class);
        List found = cacheQuery.list();
        int elems = found.size();
        assert (elems == 1) : "Expected 1 but was " + elems;
        Person val = (Person)found.get(0);
        assert (val.equals(this.person1)) : "Expected " + this.person1 + " but was " + val;
        StaticTestingErrorHandler.assertAllGood(this.cache);
    }

    public void testEagerIterator() {
        this.loadTestingData();
        CacheQuery<Person> cacheQuery = this.createQuery("blurb:'playing'", Person.class);
        try (ResultIterator found = cacheQuery.iterator(new FetchOptions().fetchMode(FetchOptions.FetchMode.EAGER));){
            AssertJUnit.assertTrue((boolean)found.hasNext());
            found.next();
            AssertJUnit.assertFalse((boolean)found.hasNext());
        }
        StaticTestingErrorHandler.assertAllGood(this.cache);
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testEagerIteratorRemove() {
        this.loadTestingData();
        CacheQuery<Person> cacheQuery = this.createQuery("blurb:'playing'", Person.class);
        try (ResultIterator found = cacheQuery.iterator(new FetchOptions().fetchMode(FetchOptions.FetchMode.EAGER));){
            AssertJUnit.assertTrue((boolean)found.hasNext());
            found.remove();
        }
    }

    @Test(expectedExceptions={NoSuchElementException.class})
    public void testEagerIteratorExCase() {
        this.loadTestingData();
        CacheQuery<Person> cacheQuery = this.createQuery("blurb:'playing'", Person.class);
        try (ResultIterator found = cacheQuery.iterator(new FetchOptions().fetchMode(FetchOptions.FetchMode.EAGER));){
            AssertJUnit.assertTrue((boolean)found.hasNext());
            found.next();
            AssertJUnit.assertFalse((boolean)found.hasNext());
            found.next();
        }
    }

    public void testMultipleResults() {
        this.loadTestingData();
        CacheQuery<Person> cacheQuery = this.createQuery("name:'goat'", Person.class);
        List found = cacheQuery.list();
        assert (found.size() == 2);
        AssertJUnit.assertTrue((boolean)found.contains(this.person2));
        AssertJUnit.assertTrue((boolean)found.contains(this.person3));
        StaticTestingErrorHandler.assertAllGood(this.cache);
    }

    public void testModified() {
        this.loadTestingData();
        CacheQuery<Person> cacheQuery = this.createQuery("blurb:'playing'", Person.class);
        List found = cacheQuery.list();
        assert (found.size() == 1);
        assert (((Person)found.get(0)).equals(this.person1));
        this.person1.setBlurb("Likes pizza");
        this.cache.put((Object)this.key1, (Object)this.person1);
        cacheQuery = this.createQuery("blurb:'pizza'", Person.class);
        found = cacheQuery.list();
        assert (found.size() == 1);
        assert (((Person)found.get(0)).equals(this.person1));
        StaticTestingErrorHandler.assertAllGood(this.cache);
    }

    public void testAdded() {
        this.loadTestingData();
        CacheQuery<Person> cacheQuery = this.createQuery("name:'Goat'", Person.class);
        List found = cacheQuery.list();
        assert (found.size() == 2) : "Size of list should be 2";
        assert (found.contains(this.person2));
        assert (found.contains(this.person3));
        assert (!found.contains(this.person4)) : "This should not contain object person4";
        this.person4 = new Person();
        this.person4.setName("Mighty Goat");
        this.person4.setBlurb("Also eats grass");
        this.cache.put((Object)"mighty", (Object)this.person4);
        cacheQuery = this.createQuery("name:'Goat'", Person.class);
        found = cacheQuery.list();
        assert (found.size() == 3) : "Size of list should be 3";
        assert (found.contains(this.person2));
        assert (found.contains(this.person3));
        assert (found.contains(this.person4)) : "This should now contain object person4";
        StaticTestingErrorHandler.assertAllGood(this.cache);
    }

    public void testRemoved() {
        this.loadTestingData();
        CacheQuery<Person> cacheQuery = this.createQuery("name:'Goat'", Person.class);
        List found = cacheQuery.list();
        assert (found.size() == 2);
        assert (found.contains(this.person2));
        assert (found.contains(this.person3)) : "This should still contain object person3";
        this.cache.remove((Object)this.key3);
        cacheQuery = this.createQuery("name:'Goat'", Person.class);
        found = cacheQuery.list();
        assert (found.size() == 1);
        assert (found.contains(this.person2));
        assert (!found.contains(this.person3)) : "The search should not return person3";
        StaticTestingErrorHandler.assertAllGood(this.cache);
    }

    public void testUpdated() {
        this.loadTestingData();
        CacheQuery<Person> cacheQuery = this.createQuery("name:'Goat'", Person.class);
        List found = cacheQuery.list();
        assert (found.size() == 2) : "Size of list should be 2";
        assert (found.contains(this.person2)) : "The search should have person2";
        this.cache.put((Object)this.key2, (Object)this.person1);
        cacheQuery = this.createQuery("name:'Goat'", Person.class);
        found = cacheQuery.list();
        assert (found.size() == 1) : "Size of list should be 1";
        assert (!found.contains(this.person2)) : "Person 2 should not be found now";
        assert (!found.contains(this.person1)) : "Person 1 should not be found because it does not meet the search criteria";
        StaticTestingErrorHandler.assertAllGood(this.cache);
    }

    public void testSetSort() {
        this.loadTestingData();
        Sort sort = new Sort(new SortField("age", SortField.Type.INT));
        CacheQuery<Person> cacheQuery = this.createQuery("name:'Goat'", Person.class);
        List found = cacheQuery.list();
        assert (found.size() == 2);
        cacheQuery.sort(sort);
        found = cacheQuery.list();
        assert (found.size() == 2);
        assert (((Person)found.get(0)).equals(this.person3));
        assert (((Person)found.get(1)).equals(this.person2));
        StaticTestingErrorHandler.assertAllGood(this.cache);
        this.person2.setAge(10);
        this.cache.put((Object)this.key2, (Object)this.person2);
        cacheQuery = this.createQuery("name:'Goat'", Person.class);
        found = cacheQuery.list();
        assert (found.size() == 2);
        cacheQuery.sort(sort);
        found = cacheQuery.list();
        assert (found.size() == 2);
        assert (((Person)found.get(0)).equals(this.person2));
        assert (((Person)found.get(1)).equals(this.person3));
        StaticTestingErrorHandler.assertAllGood(this.cache);
    }

    public void testSetFilter() {
        this.loadTestingData();
        CacheQuery<Person> cacheQuery = this.createQuery("name:'goat'", Person.class);
        List found = cacheQuery.list();
        assert (found.size() == 2);
        cacheQuery = this.createQuery("name:'goat' AND blurb:'cheese'", Person.class);
        found = cacheQuery.list();
        assert (found.size() == 1);
        StaticTestingErrorHandler.assertAllGood(this.cache);
    }

    public void testLazyIterator() {
        this.loadTestingData();
        CacheQuery<Person> cacheQuery = this.createQuery("blurb:'playing'", Person.class);
        try (ResultIterator found = cacheQuery.iterator(new FetchOptions().fetchMode(FetchOptions.FetchMode.LAZY));){
            AssertJUnit.assertTrue((boolean)found.hasNext());
            found.next();
            AssertJUnit.assertFalse((boolean)found.hasNext());
        }
        StaticTestingErrorHandler.assertAllGood(this.cache);
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="Unknown FetchMode null")
    public void testUnknownFetchModeIterator() {
        this.loadTestingData();
        CacheQuery<Person> cacheQuery = this.createQuery("blurb:'playing'", Person.class);
        try (ResultIterator found = cacheQuery.iterator(new FetchOptions(){

            public FetchOptions.FetchMode getFetchMode() {
                return null;
            }
        });){
            AssertJUnit.assertTrue((boolean)found.hasNext());
            found.next();
            AssertJUnit.assertFalse((boolean)found.hasNext());
        }
    }

    public void testIteratorWithDefaultOptions() {
        this.loadTestingData();
        CacheQuery<Person> cacheQuery = this.createQuery("blurb:'playing'", Person.class);
        try (ResultIterator found = cacheQuery.iterator();){
            AssertJUnit.assertTrue((boolean)found.hasNext());
            found.next();
            AssertJUnit.assertFalse((boolean)found.hasNext());
        }
        StaticTestingErrorHandler.assertAllGood(this.cache);
    }

    public void testExplain() {
        this.loadTestingData();
        CacheQuery<Person> cacheQuery = this.createQuery("blurb:'Eats'", Person.class);
        Explanation found = cacheQuery.explain(0);
        AssertJUnit.assertNotNull((Object)found);
        StaticTestingErrorHandler.assertAllGood(this.cache);
    }

    public void testFullTextFilterOnOff() {
        this.loadTestingData();
        CacheQuery<Person> query = this.createQuery("blurb:'Eats'", Person.class);
        FullTextFilter filter = query.enableFullTextFilter("personFilter");
        filter.setParameter("blurbText", (Object)"cheese");
        AssertJUnit.assertEquals((int)1, (int)query.getResultSize());
        List result = query.list();
        Person person = (Person)result.get(0);
        AssertJUnit.assertEquals((String)"Mini Goat", (String)person.getName());
        AssertJUnit.assertEquals((String)"Eats cheese", (String)person.getBlurb());
        query.disableFullTextFilter("personFilter");
        AssertJUnit.assertEquals((int)2, (int)query.getResultSize());
        StaticTestingErrorHandler.assertAllGood(this.cache);
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testIteratorRemove() {
        this.loadTestingData();
        CacheQuery<Person> cacheQuery = this.createQuery("blurb:'Eats'", Person.class);
        try (ResultIterator iterator = cacheQuery.iterator();){
            if (iterator.hasNext()) {
                iterator.next();
                iterator.remove();
            }
        }
        StaticTestingErrorHandler.assertAllGood(this.cache);
    }

    public void testLazyIteratorWithOffset() {
        this.loadTestingData();
        CacheQuery cacheQuery = this.createQuery("blurb:'Eats'", Person.class).firstResult(1);
        try (ResultIterator iterator = cacheQuery.iterator(new FetchOptions().fetchMode(FetchOptions.FetchMode.LAZY));){
            AssertJUnit.assertEquals((int)1, (int)this.countElements((Iterator<?>)iterator));
        }
        StaticTestingErrorHandler.assertAllGood(this.cache);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testSearchManagerWithNullCache() {
        Search.getSearchManager(null);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testLazyIteratorWithInvalidFetchSize() {
        this.loadTestingData();
        CacheQuery cacheQuery = this.createQuery("blurb:'Eats'", Person.class).firstResult(1);
        cacheQuery.iterator(new FetchOptions().fetchMode(FetchOptions.FetchMode.LAZY).fetchSize(0));
    }

    @Test(expectedExceptions={NoSuchElementException.class})
    public void testLazyIteratorWithNoElementsFound() {
        this.loadTestingData();
        CacheQuery cacheQuery = this.createQuery("blurb:'fish'", Person.class).firstResult(1);
        try (ResultIterator found = cacheQuery.iterator(new FetchOptions().fetchMode(FetchOptions.FetchMode.LAZY));){
            found.next();
        }
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testIteratorWithNullFetchMode() {
        this.loadTestingData();
        CacheQuery cacheQuery = this.createQuery("blurb:'Eats'", Person.class).firstResult(1);
        try (ResultIterator found = cacheQuery.iterator(new FetchOptions().fetchMode(null));){
            found.next();
        }
    }

    public void testSearchKeyTransformer() {
        SearchManagerImplementor manager = (SearchManagerImplementor)Search.getSearchManager((Cache)this.cache).unwrap(SearchManagerImplementor.class);
        manager.registerKeyTransformer(CustomKey3.class, CustomKey3Transformer.class);
        this.loadTestingDataWithCustomKey();
        CacheQuery<Person> cacheQuery = this.createQuery("blurb:'Eats'", Person.class);
        try (ResultIterator iterator = cacheQuery.iterator(new FetchOptions().fetchMode(FetchOptions.FetchMode.LAZY));){
            AssertJUnit.assertEquals((int)2, (int)this.countElements((Iterator<?>)iterator));
        }
        StaticTestingErrorHandler.assertAllGood(this.cache);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testSearchWithWrongCache() {
        Cache cache = (Cache)Mockito.mock(CacheImpl.class);
        Mockito.when((Object)cache.getAdvancedCache()).thenReturn(null);
        Search.getSearchManager((Cache)cache);
    }

    public void testSearchManagerWithInstantiation() {
        this.loadTestingData();
        CacheQuery<Person> cacheQuery = this.createQuery("blurb:'playing'", Person.class);
        try (ResultIterator found = cacheQuery.iterator(new FetchOptions().fetchMode(FetchOptions.FetchMode.valueOf((String)"LAZY")));){
            AssertJUnit.assertTrue((boolean)found.hasNext());
            found.next();
            AssertJUnit.assertFalse((boolean)found.hasNext());
        }
    }

    public void testGetResultSize() {
        this.loadTestingData();
        CacheQuery<Person> cacheQuery = this.createQuery("blurb:'playing'", Person.class);
        assert (cacheQuery.getResultSize() == 1);
        StaticTestingErrorHandler.assertAllGood(this.cache);
    }

    public void testMaxResults() {
        this.loadTestingData();
        CacheQuery cacheQuery = this.createQuery("blurb:'eats'", Person.class).maxResults(1);
        AssertJUnit.assertEquals((int)2, (int)cacheQuery.getResultSize());
        AssertJUnit.assertEquals((int)1, (int)cacheQuery.list().size());
        try (ResultIterator eagerIterator = cacheQuery.iterator(new FetchOptions().fetchMode(FetchOptions.FetchMode.EAGER));){
            AssertJUnit.assertEquals((int)1, (int)this.countElements((Iterator<?>)eagerIterator));
        }
        try (ResultIterator lazyIterator = cacheQuery.iterator(new FetchOptions().fetchMode(FetchOptions.FetchMode.LAZY));){
            AssertJUnit.assertEquals((int)1, (int)this.countElements((Iterator<?>)lazyIterator));
        }
        try (ResultIterator defaultIterator = cacheQuery.iterator();){
            AssertJUnit.assertEquals((int)1, (int)this.countElements((Iterator<?>)defaultIterator));
        }
        StaticTestingErrorHandler.assertAllGood(this.cache);
    }

    private int countElements(Iterator<?> iterator) {
        int count = 0;
        while (iterator.hasNext()) {
            iterator.next();
            ++count;
        }
        return count;
    }

    public void testClear() {
        this.loadTestingData();
        String predicate = "name:'navin' OR name:'goat'";
        CacheQuery<Person> cacheQuery = this.createQuery(predicate, Person.class);
        assert (cacheQuery.getResultSize() == 3) : "Expected 3, got " + cacheQuery.getResultSize();
        this.cache.clear();
        cacheQuery = this.createQuery(predicate, Person.class);
        assert (cacheQuery.getResultSize() == 0);
        StaticTestingErrorHandler.assertAllGood(this.cache);
    }

    public void testTypeFiltering() {
        this.loadTestingData();
        CacheQuery<Person> cacheQuery = this.createQuery("blurb:'grass'", Person.class);
        List found = cacheQuery.list();
        assert (found.size() == 1);
        assert (found.contains(this.person2));
        cacheQuery = this.createQuery("blurb:'grass'", AnotherGrassEater.class);
        found = cacheQuery.list();
        assert (found.size() == 1);
        assert (found.get(0).equals(this.anotherGrassEater));
        StaticTestingErrorHandler.assertAllGood(this.cache);
    }

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder cfg = this.getDefaultStandaloneCacheConfig(true);
        cfg.indexing().enable().addIndexedEntity(Person.class).addIndexedEntity(AnotherGrassEater.class).addProperty("default.directory_provider", "local-heap").addProperty("error_handler", StaticTestingErrorHandler.class.getName()).addProperty("lucene_version", "LUCENE_CURRENT");
        this.enhanceConfig(cfg);
        return TestCacheManagerFactory.createCacheManager((SerializationContextInitializer)QueryTestSCI.INSTANCE, (ConfigurationBuilder)cfg);
    }

    protected void teardown() {
        if (this.cache != null) {
            this.cache.clear();
        }
        super.teardown();
    }

    protected void loadTestingData() {
        this.prepareTestingData();
        this.cache.put((Object)this.key1, (Object)this.person1);
        this.cache.put((Object)this.key2, (Object)this.person2);
        this.cache.put((Object)this.key2, (Object)this.person2);
        this.cache.put((Object)this.key2, (Object)this.person2);
        this.cache.put((Object)this.key3, (Object)this.person3);
        this.cache.put((Object)this.anotherGrassEaterKey, (Object)this.anotherGrassEater);
        StaticTestingErrorHandler.assertAllGood(this.cache);
    }

    protected void loadTestingDataWithCustomKey() {
        this.prepareTestingData();
        CustomKey3 customeKey1 = new CustomKey3(this.key1);
        CustomKey3 customeKey2 = new CustomKey3(this.key2);
        CustomKey3 customeKey3 = new CustomKey3(this.key3);
        this.cache.put((Object)customeKey1, (Object)this.person1);
        this.cache.put((Object)customeKey2, (Object)this.person2);
        this.cache.put((Object)customeKey2, (Object)this.person2);
        this.cache.put((Object)customeKey2, (Object)this.person2);
        this.cache.put((Object)customeKey3, (Object)this.person3);
        this.cache.put((Object)this.anotherGrassEaterKey, (Object)this.anotherGrassEater);
        StaticTestingErrorHandler.assertAllGood(this.cache);
    }

    private void prepareTestingData() {
        this.person1 = new Person();
        this.person1.setName("Navin Surtani");
        this.person1.setAge(20);
        this.person1.setBlurb("Likes playing WoW");
        this.person1.setNonIndexedField("test1");
        this.person2 = new Person();
        this.person2.setName("Big Goat");
        this.person2.setAge(30);
        this.person2.setBlurb("Eats grass");
        this.person2.setNonIndexedField("test2");
        this.person3 = new Person();
        this.person3.setName("Mini Goat");
        this.person3.setAge(25);
        this.person3.setBlurb("Eats cheese");
        this.person3.setNonIndexedField("test3");
        this.anotherGrassEater = new AnotherGrassEater("Another grass-eater", "Eats grass");
        StaticTestingErrorHandler.assertAllGood(this.cache);
    }

    protected void enhanceConfig(ConfigurationBuilder c) {
    }
}

