/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.blackbox;

import org.apache.lucene.index.IndexReader;
import org.hibernate.search.spi.SearchIntegrator;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.Search;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.helper.TestQueryHelperFactory;
import org.infinispan.query.test.Person;
import org.infinispan.query.test.QueryTestSCI;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.blackbox.OffHeapQueryTest")
public class OffHeapQueryTest
extends SingleCacheManagerTest {
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder cfg = this.getDefaultStandaloneCacheConfig(false);
        cfg.memory().storageType(StorageType.OFF_HEAP).size(10L);
        cfg.indexing().enable().addIndexedEntity(Person.class).addProperty("default.directory_provider", "local-heap");
        return TestCacheManagerFactory.createCacheManager((SerializationContextInitializer)QueryTestSCI.INSTANCE, (ConfigurationBuilder)cfg);
    }

    @Test
    public void testQuery() {
        this.cache.put((Object)"1", (Object)new Person("Donald", "MAGA", 78));
        Assert.assertEquals((int)this.getIndexDocs(), (int)1);
        CacheQuery queryFromLucene = TestQueryHelperFactory.createCacheQuery(Person.class, this.cache, "name", "Donald");
        Assert.assertEquals((int)1, (int)queryFromLucene.list().size());
        Query queryFromIckle = Search.getQueryFactory((Cache)this.cache).create("From org.infinispan.query.test.Person p where p.name:'Donald'");
        Assert.assertEquals((int)1, (int)queryFromIckle.list().size());
    }

    private int getIndexDocs() {
        SearchIntegrator searchIntegrator = TestQueryHelperFactory.extractSearchFactory(this.cache);
        IndexReader indexReader = searchIntegrator.getIndexManager("person").getReaderProvider().openIndexReader();
        return indexReader.numDocs();
    }
}

