/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.blackbox;

import org.hibernate.search.spi.SearchIntegrator;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.test.Person;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.TransactionMode;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(testName="query.blackbox.SearchFactoryShutdownTest", groups={"functional"})
public class SearchFactoryShutdownTest
extends AbstractInfinispanTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCorrectShutdown() {
        EmbeddedCacheManager cc = null;
        try {
            ConfigurationBuilder cfg = new ConfigurationBuilder();
            cfg.transaction().transactionMode(TransactionMode.TRANSACTIONAL).indexing().enable().addIndexedEntity(Person.class).addProperty("default.directory_provider", "local-heap").addProperty("lucene_version", "LUCENE_CURRENT");
            cc = TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)cfg);
            Cache cache = cc.getCache();
            SearchIntegrator sfi = (SearchIntegrator)TestingUtil.extractComponent((Cache)cache, SearchIntegrator.class);
            AssertJUnit.assertFalse((boolean)sfi.isStopped());
            cc.stop();
            AssertJUnit.assertTrue((boolean)sfi.isStopped());
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers((CacheContainer[])new CacheContainer[]{cc});
            throw throwable;
        }
        TestingUtil.killCacheManagers((CacheContainer[])new CacheContainer[]{cc});
    }
}

