/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.distributed;

import java.io.IOException;
import javax.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.Search;
import org.infinispan.query.SearchManager;
import org.infinispan.query.helper.StaticTestingErrorHandler;
import org.infinispan.query.test.Person;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.TransactionMode;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.distributed.IndexManagerLocalTest")
public class IndexManagerLocalTest
extends SingleCacheManagerTest {
    protected EmbeddedCacheManager createCacheManager() throws IOException {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.clustering().cacheMode(CacheMode.LOCAL).indexing().enable().addIndexedEntity(Person.class).addProperty("lucene_version", "LUCENE_CURRENT").addProperty("error_handler", StaticTestingErrorHandler.class.getName()).addProperty("default.indexmanager", "near-real-time").addProperty("default.directory_provider", "local-heap");
        if (this.transactionsEnabled()) {
            builder.transaction().transactionMode(TransactionMode.TRANSACTIONAL);
        }
        return TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)builder);
    }

    protected boolean transactionsEnabled() {
        return false;
    }

    public void testIndexingWork() throws Exception {
        this.assertIndexSize(0);
        this.store("k1", new Person("K. Firt", "Is not a character from the matrix", 1));
        this.assertIndexSize(1);
        this.store("k2", new Person("K. Seycond", "Is a pilot", 1));
        this.assertIndexSize(2);
    }

    protected void store(String key, Person person) throws Exception {
        TransactionManager transactionManager = this.cache.getAdvancedCache().getTransactionManager();
        if (this.transactionsEnabled()) {
            transactionManager.begin();
        }
        this.cache.put((Object)key, (Object)person);
        if (this.transactionsEnabled()) {
            transactionManager.commit();
        }
    }

    protected void assertIndexSize(int expectedIndexSize) {
        SearchManager searchManager = Search.getSearchManager((Cache)this.cache);
        CacheQuery query = searchManager.getQuery("FROM " + Person.class.getName());
        AssertJUnit.assertEquals((int)expectedIndexSize, (int)query.list().size());
        StaticTestingErrorHandler.assertAllGood(this.cache);
    }
}

