/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.distributed;

import org.infinispan.Cache;
import org.infinispan.commons.test.ThreadLeakChecker;
import org.infinispan.context.Flag;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.Search;
import org.infinispan.query.test.Transaction;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.jboss.byteman.contrib.bmunit.BMNGListener;
import org.jboss.byteman.contrib.bmunit.BMRule;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Listeners;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.distributed.MassIndexerAsyncBackendTest")
@Listeners(value={BMNGListener.class})
public class MassIndexerAsyncBackendTest
extends MultipleCacheManagersTest {
    protected static final int NUM_NODES = 2;
    protected static final int NUM_ENTRIES = 10;

    protected void createCacheManagers() throws Throwable {
        for (int i = 0; i < 2; ++i) {
            EmbeddedCacheManager cacheManager = TestCacheManagerFactory.fromXml((String)"dist-indexing-async.xml");
            this.registerCacheManager(new CacheContainer[]{cacheManager});
        }
        this.waitForClusterToForm(new String[]{"default", "LuceneIndexesMetadata", "LuceneIndexesData", "LuceneIndexesLocking"});
    }

    @AfterClass(alwaysRun=true)
    protected void destroy() {
        ThreadLeakChecker.ignoreThreadsContaining((String)"DefaultExecutorService-");
        super.destroy();
    }

    @Test
    @BMRule(name="Delay the purge of the index", targetClass="org.hibernate.search.backend.impl.lucene.works.PurgeAllWorkExecutor", targetMethod="performWork", action="delay(500)")
    public void testMassIndexOnAsync() throws Exception {
        Cache cache = (Cache)this.caches().get(0);
        for (int i = 0; i < 10; ++i) {
            cache.getAdvancedCache().withFlags(Flag.SKIP_INDEXING).put((Object)String.valueOf(i), (Object)new Transaction(i, "12345"));
        }
        for (Cache c : this.caches()) {
            Search.getSearchManager((Cache)c).getMassIndexer().start();
            this.assertAllIndexed(c);
        }
    }

    private void assertAllIndexed(Cache cache) {
        this.eventually(() -> {
            int size = Search.getSearchManager((Cache)cache).getQuery("FROM " + Transaction.class.getName()).list().size();
            return size == 10;
        });
    }
}

