/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.distributed;

import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.context.Flag;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.Search;
import org.infinispan.query.SearchManager;
import org.infinispan.query.distributed.DistributedMassIndexingTest;
import org.infinispan.query.helper.StaticTestingErrorHandler;
import org.infinispan.query.queries.faceting.Car;
import org.infinispan.query.test.Person;
import org.infinispan.query.test.QueryTestSCI;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.distributed.MultipleEntitiesMassIndexTest")
public class MultipleEntitiesMassIndexTest
extends DistributedMassIndexingTest {
    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder cacheCfg = MultipleEntitiesMassIndexTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.REPL_SYNC, (boolean)false);
        cacheCfg.indexing().enable().addIndexedEntity(Car.class).addIndexedEntity(Person.class).addProperty("hibernate.search.person.directory_provider", "local-heap").addProperty("default.directory_provider", "local-heap").addProperty("error_handler", StaticTestingErrorHandler.class.getName()).addProperty("lucene_version", "LUCENE_CURRENT");
        this.createClusteredCaches(2, QueryTestSCI.INSTANCE, cacheCfg);
        this.waitForClusterToForm();
    }

    @Override
    public void testReindexing() throws Exception {
        this.cache(0).put(this.key("C1"), (Object)new Car("megane", "white", 300));
        this.cache(1).put(this.key("P1"), (Object)new Person("james", "blurb", 23));
        this.cache(1).put(this.key("P2"), (Object)new Person("tony", "blurb", 28));
        this.cache(1).put(this.key("P3"), (Object)new Person("chris", "blurb", 26));
        this.cache(1).put(this.key("P4"), (Object)new Person("iker", "blurb", 23));
        this.cache(1).put(this.key("P5"), (Object)new Person("sergio", "blurb", 29));
        this.checkIndex(5, Person.class);
        this.checkIndex(1, Car.class);
        this.checkIndex(1, "make", "megane", Car.class);
        this.checkIndex(1, "name", "james", Person.class);
        this.cache(1).put(this.key("C2"), (Object)new Car("megane", "blue", 300));
        this.checkIndex(2, "make", "megane", Car.class);
        this.cache(1).getAdvancedCache().withFlags(Flag.SKIP_INDEXING).put(this.key("C3"), (Object)new Car("megane", "blue", 300));
        this.checkIndex(2, "make", "megane", Car.class);
        this.rebuildIndexes();
        this.checkIndex(5, Person.class);
        this.checkIndex(3, Car.class);
        this.checkIndex(3, "make", "megane", Car.class);
        this.checkIndex(1, "name", "tony", Person.class);
        this.cache(1).getAdvancedCache().withFlags(Flag.SKIP_INDEXING).remove(this.key("C2"));
        this.cache(1).getAdvancedCache().withFlags(Flag.SKIP_INDEXING).remove(this.key("P3"));
        Assert.assertNull((Object)this.cache(1).get(this.key("P3")));
        Assert.assertNull((Object)this.cache(1).get(this.key("C2")));
        this.checkIndex(3, "make", "megane", Car.class);
        this.checkIndex(5, Person.class);
        this.rebuildIndexes();
        this.checkIndex(2, Car.class);
        this.checkIndex(2, "make", "megane", Car.class);
        this.checkIndex(4, Person.class);
    }

    private void checkIndex(int expectedCount, String fieldName, String fieldValue, Class<?> entity) {
        String q = String.format("FROM %s where %s:'%s'", entity.getName(), fieldName, fieldValue);
        this.checkIndex(expectedCount, q, entity);
    }

    private void checkIndex(int expectedCount, Class<?> entity) {
        this.checkIndex(expectedCount, "FROM " + entity.getName(), entity);
    }

    private void checkIndex(int expectedCount, String q, Class<?> entity) {
        for (Cache cache : this.caches()) {
            StaticTestingErrorHandler.assertAllGood(cache);
            SearchManager searchManager = Search.getSearchManager((Cache)cache);
            CacheQuery cacheQuery = searchManager.getQuery(q);
            AssertJUnit.assertEquals((int)expectedCount, (int)cacheQuery.getResultSize());
        }
    }
}

