/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.distributed;

import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.query.Search;
import org.infinispan.query.SearchManager;
import org.infinispan.query.helper.StaticTestingErrorHandler;
import org.infinispan.query.helper.TestQueryHelperFactory;
import org.infinispan.query.queries.faceting.Car;
import org.infinispan.query.test.QueryTestSCI;
import org.infinispan.test.MultipleCacheManagersTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.distributed.ShardingMassIndexTest")
public class ShardingMassIndexTest
extends MultipleCacheManagersTest {
    protected static final int NUM_NODES = 3;

    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder cacheCfg = ShardingMassIndexTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.REPL_SYNC, (boolean)false);
        cacheCfg.indexing().enable().addIndexedEntity(Car.class).addProperty("hibernate.search.car.sharding_strategy.nbr_of_shards", "2").addProperty("hibernate.search.car.1.directory_provider", "local-heap").addProperty("hibernate.search.car.0.indexmanager", "near-real-time").addProperty("error_handler", StaticTestingErrorHandler.class.getName()).addProperty("lucene_version", "LUCENE_CURRENT");
        this.createClusteredCaches(3, QueryTestSCI.INSTANCE, cacheCfg);
        this.waitForClusterToForm(this.getDefaultCacheName());
    }

    @Test(enabled=false, description="Shards going to different index managers are not currently supported")
    public void testReindex() throws Exception {
        Cache cache = this.cache(0);
        cache.put((Object)1, (Object)new Car("mazda", "red", 200));
        cache.put((Object)2, (Object)new Car("mazda", "blue", 200));
        cache.put((Object)3, (Object)new Car("audi", "blue", 170));
        cache.put((Object)4, (Object)new Car("audi", "black", 170));
        this.checkIndex(4, Car.class);
        this.runMassIndexer();
        this.checkIndex(4, Car.class);
        cache.clear();
        this.runMassIndexer();
        this.checkIndex(0, Car.class);
    }

    protected void checkIndex(int expectedNumber, Class<?> entity) {
        for (Cache c : this.caches()) {
            SearchManager searchManager = Search.getSearchManager((Cache)c);
            int size = TestQueryHelperFactory.queryAll(searchManager, entity).size();
            Assert.assertEquals((int)size, (int)expectedNumber);
        }
    }

    protected void runMassIndexer() {
        SearchManager searchManager = Search.getSearchManager((Cache)this.cache(0));
        searchManager.getMassIndexer().start();
    }
}

