/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.nulls;

import java.io.Serializable;
import java.util.List;
import java.util.NoSuchElementException;
import javax.transaction.TransactionManager;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Store;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.distribution.DistributionInfo;
import org.infinispan.distribution.LocalizedCacheTopology;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.protostream.annotations.AutoProtoSchemaBuilder;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.FetchOptions;
import org.infinispan.query.ResultIterator;
import org.infinispan.query.Search;
import org.infinispan.query.SearchManager;
import org.infinispan.query.dsl.IndexedQueryMode;
import org.infinispan.query.nulls.SCIImpl;
import org.infinispan.remoting.transport.Address;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.nulls.NullCollectionElementsClusteredTest")
public class NullCollectionElementsClusteredTest
extends MultipleCacheManagersTest {
    private Cache<String, Foo> cache1;
    private Cache<String, Foo> cache2;
    private SearchManager searchManager;

    public void testQuerySkipsNullsInList() throws Exception {
        this.prepareData();
        TestingUtil.withTx((TransactionManager)this.tm(1), () -> {
            this.cache2.remove((Object)"2");
            Cache<String, Foo> queryCache = this.getNonOwner("2");
            List list = this.createLocalCacheQuery(queryCache, "2").list();
            AssertJUnit.assertEquals((String)"Wrong list size.", (int)0, (int)list.size());
            return null;
        });
    }

    public void testQuerySkipsNullsInEagerIterator() throws Exception {
        this.prepareData();
        TestingUtil.withTx((TransactionManager)this.tm(0), () -> {
            this.cache1.remove((Object)"1");
            ResultIterator iterator = this.createLocalCacheQuery(this.cache1, "1").iterator(new FetchOptions().fetchMode(FetchOptions.FetchMode.EAGER));
            AssertJUnit.assertFalse((String)"Iterator should not have elements.", (boolean)iterator.hasNext());
            try {
                iterator.next();
                AssertJUnit.fail((String)"Expected NoSuchElementException");
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            return null;
        });
    }

    public void testQuerySkipsNullsInDefaultIterator() throws Exception {
        this.prepareData();
        TestingUtil.withTx((TransactionManager)this.tm(0), () -> {
            Cache<String, Foo> cache = this.getKeyLocation("1");
            cache.remove((Object)"1");
            ResultIterator iterator = this.createLocalCacheQuery(cache, "1").iterator();
            AssertJUnit.assertFalse((boolean)iterator.hasNext());
            try {
                iterator.next();
                AssertJUnit.fail((String)"Expected NoSuchElementException");
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            return null;
        });
    }

    public void testQuerySkipsNullsInCacheQueryIterator() throws Exception {
        this.prepareData();
        TestingUtil.withTx((TransactionManager)this.tm(0), () -> {
            Cache<String, Foo> cache = this.getKeyLocation("1");
            cache.remove((Object)"1");
            CacheQuery<Foo> cacheQuery = this.createLocalCacheQuery(cache, "1");
            AssertJUnit.assertEquals((String)"Wrong result size.", (int)1, (int)cacheQuery.getResultSize());
            for (Object obj : cacheQuery) {
                AssertJUnit.fail((String)("The iterator should not contain any data but it contains " + obj));
            }
            return null;
        });
    }

    public void testQuerySkipsNullsInLazyIterator() throws Exception {
        this.prepareData();
        TestingUtil.withTx((TransactionManager)this.tm(1), () -> {
            this.cache2.remove((Object)"2");
            Cache<String, Foo> queryCache = this.getKeyLocation("2").equals(this.cache1) ? this.cache2 : this.cache1;
            this.searchManager = Search.getSearchManager(queryCache);
            ResultIterator iterator = this.createLocalCacheQuery(queryCache, "2").iterator(new FetchOptions().fetchMode(FetchOptions.FetchMode.LAZY));
            AssertJUnit.assertFalse((boolean)iterator.hasNext());
            try {
                iterator.next();
                AssertJUnit.fail((String)"Expected NoSuchElementException");
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            return null;
        });
    }

    public void testQueryReturnsNullWhenProjectingCacheValue() throws Exception {
        this.prepareData();
        TestingUtil.withTx((TransactionManager)this.tm(0), () -> {
            Cache<String, Foo> cache = this.getKeyLocation("1");
            cache.remove((Object)"1");
            this.searchManager = Search.getSearchManager(cache);
            String q = String.format("SELECT bar FROM %s where bar:'1'", Foo.class.getName());
            CacheQuery cacheQuery = this.searchManager.getQuery(q);
            ResultIterator iterator = cacheQuery.iterator(new FetchOptions().fetchMode(FetchOptions.FetchMode.LAZY));
            AssertJUnit.assertTrue((String)"Expected an element in iterator.", (boolean)iterator.hasNext());
            Object[] projection = (Object[])iterator.next();
            AssertJUnit.assertEquals((Object)"1", (Object)projection[0]);
            return null;
        });
    }

    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder cfg = NullCollectionElementsClusteredTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)true);
        cfg.clustering().hash().numOwners(1);
        cfg.indexing().enable().addIndexedEntity(Foo.class).addProperty("default.directory_provider", "local-heap").addProperty("lucene_version", "LUCENE_CURRENT");
        this.createClusteredCaches(2, SCI.INSTANCE, cfg);
        this.cache1 = this.cache(0);
        this.cache2 = this.cache(1);
    }

    private void prepareData() throws Exception {
        TestingUtil.withTx((TransactionManager)this.tm(0), () -> {
            this.cache1.put((Object)"1", (Object)new Foo("1"));
            return null;
        });
        TestingUtil.withTx((TransactionManager)this.tm(1), () -> {
            this.cache2.put((Object)"2", (Object)new Foo("2"));
            return null;
        });
    }

    private CacheQuery<Foo> createLocalCacheQuery(Cache<?, ?> cache, String value) {
        SearchManager searchManager = Search.getSearchManager(cache);
        String q = String.format("FROM %s where bar:'%s'", Foo.class.getName(), value);
        return searchManager.getQuery(q, IndexedQueryMode.FETCH);
    }

    private Cache<String, Foo> getKeyLocation(String key) {
        Address cache1Address = this.cache1.getAdvancedCache().getRpcManager().getAddress();
        LocalizedCacheTopology cacheTopology = this.cache1.getAdvancedCache().getDistributionManager().getCacheTopology();
        DistributionInfo distribution = cacheTopology.getDistribution((Object)key);
        Address primary = distribution.primary();
        return primary.equals(cache1Address) ? this.cache1 : this.cache2;
    }

    private Cache<String, Foo> getNonOwner(String key) {
        LocalizedCacheTopology cacheTopology = this.cache1.getAdvancedCache().getDistributionManager().getCacheTopology();
        DistributionInfo distribution = cacheTopology.getDistribution((Object)key);
        List addresses = distribution.writeOwners();
        List allCaches = this.caches();
        return allCaches.stream().filter(c -> !addresses.contains(c.getAdvancedCache().getRpcManager().getAddress())).findFirst().get();
    }

    @AutoProtoSchemaBuilder(includeClasses={Foo.class}, schemaFileName="test.query.nulls.NullCollectionElementsClusteredTest.proto", schemaFilePath="proto/generated", schemaPackageName="org.infinispan.test.NullCollectionElementsClusteredTest")
    static interface SCI
    extends SerializationContextInitializer {
        public static final SCI INSTANCE = new SCIImpl();
    }

    @Indexed(index="FooIndex")
    public static class Foo
    implements Serializable {
        private String bar;

        @ProtoFactory
        Foo(String bar) {
            this.bar = bar;
        }

        @Field(name="bar", store=Store.YES)
        @ProtoField(number=1)
        public String getBar() {
            return this.bar;
        }
    }
}

