/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.nulls;

import java.util.List;
import java.util.NoSuchElementException;
import javax.transaction.TransactionManager;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Store;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.FetchOptions;
import org.infinispan.query.ResultIterator;
import org.infinispan.query.Search;
import org.infinispan.query.SearchManager;
import org.infinispan.query.test.QueryTestSCI;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.nulls.NullCollectionElementsTest")
public class NullCollectionElementsTest
extends SingleCacheManagerTest {
    private SearchManager searchManager;

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder cfg = this.getDefaultStandaloneCacheConfig(true);
        cfg.indexing().enable().addIndexedEntity(Foo.class).addProperty("default.directory_provider", "local-heap").addProperty("lucene_version", "LUCENE_CURRENT");
        return TestCacheManagerFactory.createCacheManager((SerializationContextInitializer)QueryTestSCI.INSTANCE, (ConfigurationBuilder)cfg);
    }

    protected void setup() throws Exception {
        super.setup();
        this.searchManager = Search.getSearchManager((Cache)this.cache);
    }

    @BeforeMethod
    public void insertData() throws Exception {
        TestingUtil.withTx((TransactionManager)this.tm(), () -> {
            this.cache.put((Object)"1", (Object)new Foo("1"));
            return null;
        });
    }

    CacheQuery<?> createCacheQuery() {
        String q = String.format("FROM %s WHERE bar:1", Foo.class.getName());
        return this.searchManager.getQuery(q);
    }

    @Test
    public void testQuerySkipsNullsInList() throws Exception {
        TestingUtil.withTx((TransactionManager)this.tm(), () -> {
            this.cache.remove((Object)"1");
            List list = this.createCacheQuery().list();
            assert (list.size() == 0);
            return null;
        });
    }

    @Test
    public void testQuerySkipsNullsInEagerIterator() throws Exception {
        TestingUtil.withTx((TransactionManager)this.tm(), () -> {
            this.cache.remove((Object)"1");
            ResultIterator iterator = this.createCacheQuery().iterator(new FetchOptions().fetchMode(FetchOptions.FetchMode.EAGER));
            AssertJUnit.assertFalse((boolean)iterator.hasNext());
            try {
                iterator.next();
                AssertJUnit.fail((String)"Expected NoSuchElementException");
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            return null;
        });
    }

    @Test
    public void testQuerySkipsNullsInDefaultIterator() throws Exception {
        TestingUtil.withTx((TransactionManager)this.tm(), () -> {
            this.cache.remove((Object)"1");
            CacheQuery<?> cacheQuery = this.createCacheQuery();
            AssertJUnit.assertEquals((int)1, (int)cacheQuery.getResultSize());
            ResultIterator iterator = cacheQuery.iterator();
            AssertJUnit.assertFalse((boolean)iterator.hasNext());
            try {
                iterator.next();
                AssertJUnit.fail((String)"Expected NoSuchElementException");
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            return null;
        });
    }

    @Test
    public void testQuerySkipsNullsInLazyIterator() throws Exception {
        TestingUtil.withTx((TransactionManager)this.tm(), () -> {
            this.cache.remove((Object)"1");
            ResultIterator iterator = this.createCacheQuery().iterator(new FetchOptions().fetchMode(FetchOptions.FetchMode.LAZY));
            AssertJUnit.assertFalse((boolean)iterator.hasNext());
            try {
                iterator.next();
                AssertJUnit.fail((String)"Expected NoSuchElementException");
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            return null;
        });
    }

    @Test
    public void testQueryReturnsNullWhenProjectingCacheValue() throws Exception {
        TestingUtil.withTx((TransactionManager)this.tm(), () -> {
            this.cache.remove((Object)"1");
            ResultIterator iterator = this.createCacheQuery().projection(new String[]{"__HSearch_This", "bar"}).iterator(new FetchOptions().fetchMode(FetchOptions.FetchMode.LAZY));
            AssertJUnit.assertTrue((boolean)iterator.hasNext());
            Object[] projection = (Object[])iterator.next();
            AssertJUnit.assertNull((Object)projection[0]);
            AssertJUnit.assertEquals((Object)"1", (Object)projection[1]);
            return null;
        });
    }

    @Indexed(index="FooIndex")
    public class Foo {
        private String bar;

        public Foo(String bar) {
            this.bar = bar;
        }

        @Field(name="bar", store=Store.YES)
        public String getBar() {
            return this.bar;
        }
    }
}

