/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.queries.phrases;

import java.util.List;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.objectfilter.ParsingException;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.Search;
import org.infinispan.query.queries.NumericType;
import org.infinispan.query.test.AnotherGrassEater;
import org.infinispan.query.test.Person;
import org.infinispan.query.test.QueryTestSCI;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.queries.phrases.QueryPhrasesTest")
public class QueryPhrasesTest
extends SingleCacheManagerTest {
    private Person person1;
    private Person person2;
    private Person person3;
    private Person person4;
    private String key1 = "test1";
    private String key2 = "test2";
    private String key3 = "test3";
    private NumericType type1;
    private NumericType type2;
    private NumericType type3;

    public QueryPhrasesTest() {
        this.cleanup = AbstractCacheTest.CleanupPhase.AFTER_METHOD;
    }

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder cfg = this.getDefaultStandaloneCacheConfig(true);
        cfg.indexing().enable().addIndexedEntity(NumericType.class).addIndexedEntity(Person.class).addIndexedEntity(AnotherGrassEater.class).addProperty("default.directory_provider", "local-heap").addProperty("lucene_version", "LUCENE_CURRENT");
        return TestCacheManagerFactory.createCacheManager((SerializationContextInitializer)QueryTestSCI.INSTANCE, (ConfigurationBuilder)cfg);
    }

    private <T> CacheQuery<T> createCacheQuery(Class<T> clazz, String predicate) {
        String queryStr = String.format("FROM %s WHERE %s", clazz.getName(), predicate);
        return Search.getSearchManager((Cache)this.cache).getQuery(queryStr);
    }

    public void testBooleanQueriesMustNot() {
        this.loadTestingData();
        CacheQuery<Person> cacheQuery = this.createCacheQuery(Person.class, "-name:'Goat'");
        List found = cacheQuery.list();
        AssertJUnit.assertEquals((int)1, (int)found.size());
        AssertJUnit.assertTrue((boolean)found.contains(this.person1));
        cacheQuery = this.createCacheQuery(Person.class, "name:'Goat'");
        found = cacheQuery.list();
        AssertJUnit.assertEquals((int)2, (int)found.size());
        AssertJUnit.assertTrue((boolean)found.contains(this.person2));
        AssertJUnit.assertTrue((boolean)found.contains(this.person3));
    }

    public void testBooleanQueriesShould() {
        this.loadTestingData();
        CacheQuery<Person> cacheQuery = this.createCacheQuery(Person.class, "name:'Goat' OR age <= 20");
        List found = cacheQuery.list();
        AssertJUnit.assertEquals((int)3, (int)found.size());
        AssertJUnit.assertTrue((boolean)found.contains(this.person1));
        AssertJUnit.assertTrue((boolean)found.contains(this.person2));
        AssertJUnit.assertTrue((boolean)found.contains(this.person3));
        cacheQuery = this.createCacheQuery(Person.class, "name:'Goat' OR age < 20");
        found = cacheQuery.list();
        AssertJUnit.assertEquals((int)2, (int)found.size());
        AssertJUnit.assertTrue((boolean)found.contains(this.person2));
        AssertJUnit.assertTrue((boolean)found.contains(this.person3));
    }

    public void testBooleanQueriesShouldNot() {
        this.loadTestingData();
        CacheQuery<Person> cacheQuery = this.createCacheQuery(Person.class, "name:'Goat'^0.5 OR age:[* to 20]^2");
        List found = cacheQuery.list();
        AssertJUnit.assertEquals((int)3, (int)found.size());
        AssertJUnit.assertEquals((Object)this.person1, found.get(0));
        AssertJUnit.assertEquals((Object)this.person2, found.get(1));
        AssertJUnit.assertEquals((Object)this.person3, found.get(2));
        cacheQuery = this.createCacheQuery(Person.class, "name:'Goat'^3.5 OR age:[* to 20]^2");
        found = cacheQuery.list();
        AssertJUnit.assertEquals((int)3, (int)found.size());
        AssertJUnit.assertEquals((Object)this.person2, found.get(0));
        AssertJUnit.assertEquals((Object)this.person3, found.get(1));
        AssertJUnit.assertEquals((Object)this.person1, found.get(2));
    }

    public void testFuzzyOnFieldsAndField() {
        this.loadTestingData();
        CacheQuery<Person> cacheQuery = this.createCacheQuery(Person.class, "name:'Goat'~2");
        List found = cacheQuery.list();
        AssertJUnit.assertEquals((int)2, (int)found.size());
        AssertJUnit.assertTrue((boolean)found.contains(this.person2));
        AssertJUnit.assertTrue((boolean)found.contains(this.person3));
        this.person4 = new Person();
        this.person4.setName("Test");
        this.person4.setBlurb("Test goat");
        this.cache.put((Object)"testKey", (Object)this.person4);
        cacheQuery = this.createCacheQuery(Person.class, "name:'goat'~2 OR blurb:'goat'~2");
        found = cacheQuery.list();
        AssertJUnit.assertEquals((int)3, (int)found.size());
        AssertJUnit.assertTrue((boolean)found.contains(this.person2));
        AssertJUnit.assertTrue((boolean)found.contains(this.person3));
        AssertJUnit.assertTrue((boolean)found.contains(this.person4));
    }

    public void testFuzzyWithThresholdWithPrefixLength() {
        this.person1 = new Person("yyJohn", "Eat anything", 10);
        this.person2 = new Person("yyJonn", "Eat anything", 10);
        this.cache.put((Object)this.key1, (Object)this.person1);
        this.cache.put((Object)this.key2, (Object)this.person2);
        CacheQuery<Person> cacheQuery = this.createCacheQuery(Person.class, "name:'yyJohny'~1");
        List found = cacheQuery.list();
        AssertJUnit.assertEquals((int)1, (int)found.size());
        AssertJUnit.assertTrue((boolean)found.contains(this.person1));
        cacheQuery = this.createCacheQuery(Person.class, "name:'yyJohn'~2");
        List foundWithLowerThreshold = cacheQuery.list();
        AssertJUnit.assertEquals((int)2, (int)foundWithLowerThreshold.size());
        AssertJUnit.assertTrue((boolean)foundWithLowerThreshold.contains(this.person1));
        AssertJUnit.assertTrue((boolean)foundWithLowerThreshold.contains(this.person2));
    }

    public void testQueryingRangeWithAnd() {
        NumericType type1 = new NumericType(10, 20);
        NumericType type2 = new NumericType(20, 10);
        NumericType type3 = new NumericType(10, 10);
        this.cache.put((Object)this.key1, (Object)type1);
        this.cache.put((Object)this.key2, (Object)type2);
        this.cache.put((Object)this.key3, (Object)type3);
        CacheQuery<NumericType> cacheQuery = this.createCacheQuery(NumericType.class, "num1:[* TO 19] OR num2:[* TO 19]");
        List found = cacheQuery.list();
        AssertJUnit.assertEquals((int)3, (int)found.size());
        AssertJUnit.assertTrue((boolean)found.contains(type1));
        AssertJUnit.assertTrue((boolean)found.contains(type2));
        AssertJUnit.assertTrue((boolean)found.contains(type3));
        NumericType type4 = new NumericType(11, 10);
        this.cache.put((Object)"newKey", (Object)type4);
        found = cacheQuery.list();
        AssertJUnit.assertEquals((int)4, (int)found.size());
        AssertJUnit.assertTrue((boolean)found.contains(type3));
        AssertJUnit.assertTrue((boolean)found.contains(type2));
        AssertJUnit.assertTrue((boolean)found.contains(type1));
        AssertJUnit.assertTrue((boolean)found.contains(type4));
    }

    @Test(expectedExceptions={ParsingException.class})
    public void testWildcardWithWrongName() {
        this.loadTestingData();
        CacheQuery<Person> cacheQuery = this.createCacheQuery(Person.class, "wrongname:'*Goat*'");
        List found = cacheQuery.list();
        AssertJUnit.assertEquals((int)2, (int)found.size());
    }

    public void testWildcard() {
        this.loadNumericTypes();
        CacheQuery<NumericType> cacheQuery = this.createCacheQuery(NumericType.class, "name LIKE '%wildcard%'");
        List found = cacheQuery.list();
        AssertJUnit.assertEquals((int)3, (int)found.size());
        AssertJUnit.assertTrue((boolean)found.contains(this.type1));
        AssertJUnit.assertTrue((boolean)found.contains(this.type2));
        AssertJUnit.assertTrue((boolean)found.contains(this.type3));
        cacheQuery = this.createCacheQuery(NumericType.class, "name LIKE 'nothing%'");
        found = cacheQuery.list();
        AssertJUnit.assertEquals((int)0, (int)found.size());
        NumericType type4 = new NumericType(35, 40);
        type4.setName("nothing special.");
        this.cache.put((Object)"otherKey", (Object)type4);
        found = cacheQuery.list();
        AssertJUnit.assertEquals((int)1, (int)found.size());
        AssertJUnit.assertTrue((boolean)found.contains(type4));
        cacheQuery = this.createCacheQuery(NumericType.class, "name LIKE '%nothing%'");
        found = cacheQuery.list();
        AssertJUnit.assertEquals((int)2, (int)found.size());
        AssertJUnit.assertTrue((boolean)found.contains(this.type2));
        AssertJUnit.assertTrue((boolean)found.contains(type4));
    }

    public void testKeyword() {
        this.loadTestingData();
        CacheQuery<Person> cacheQuery = this.createCacheQuery(Person.class, "name:'Eats' OR blurb:'Eats'");
        List found = cacheQuery.list();
        AssertJUnit.assertEquals((int)2, (int)found.size());
        this.person4 = new Person();
        this.person4.setName("Some name with Eats");
        this.person4.setBlurb("Description without keyword.");
        this.cache.put((Object)"someKey", (Object)this.person4);
        found = cacheQuery.list();
        AssertJUnit.assertEquals((int)3, (int)found.size());
        AssertJUnit.assertTrue((boolean)found.contains(this.person2));
        AssertJUnit.assertTrue((boolean)found.contains(this.person3));
        AssertJUnit.assertTrue((boolean)found.contains(this.person4));
    }

    public void testPhraseSentence() {
        this.loadTestingData();
        CacheQuery<Person> cacheQuery = this.createCacheQuery(Person.class, "blurb:'Eats grass'");
        List found = cacheQuery.list();
        AssertJUnit.assertEquals((int)1, (int)found.size());
        AssertJUnit.assertTrue((boolean)found.contains(this.person2));
        this.person4 = new Person();
        this.person4.setName("Another goat");
        this.person4.setBlurb("Eats grass and drinks water.");
        this.cache.put((Object)"anotherKey", (Object)this.person4);
        found = cacheQuery.list();
        AssertJUnit.assertEquals((int)2, (int)found.size());
        AssertJUnit.assertTrue((boolean)found.contains(this.person2));
        AssertJUnit.assertTrue((boolean)found.contains(this.person4));
    }

    public void testPhraseSentenceForNonAnalyzedEntries() {
        this.loadNumericTypes();
        CacheQuery<NumericType> cacheQuery = this.createCacheQuery(NumericType.class, "name = 'Some string'");
        List found = cacheQuery.list();
        AssertJUnit.assertEquals((int)0, (int)found.size());
        NumericType type4 = new NumericType(45, 50);
        type4.setName("Some string");
        this.cache.put((Object)"otherKey", (Object)type4);
        found = cacheQuery.list();
        AssertJUnit.assertEquals((int)1, (int)found.size());
        AssertJUnit.assertTrue((boolean)found.contains(type4));
    }

    public void testPhraseWithSlop() {
        this.loadTestingData();
        CacheQuery<Person> cacheQuery = this.createCacheQuery(Person.class, "blurb:'Eats grass'~3");
        List found = cacheQuery.list();
        AssertJUnit.assertEquals((int)1, (int)found.size());
        AssertJUnit.assertTrue((boolean)found.contains(this.person2));
        this.person4 = new Person();
        this.person4.setName("other goat");
        this.person4.setBlurb("Eats green grass.");
        this.cache.put((Object)"otherKey", (Object)this.person4);
        found = cacheQuery.list();
        AssertJUnit.assertEquals((int)2, (int)found.size());
        AssertJUnit.assertTrue((boolean)found.contains(this.person2));
        AssertJUnit.assertTrue((boolean)found.contains(this.person4));
        this.person4.setBlurb("Eats green tasty grass.");
        this.cache.put((Object)"otherKey", (Object)this.person4);
        found = cacheQuery.list();
        AssertJUnit.assertEquals((int)2, (int)found.size());
        AssertJUnit.assertTrue((boolean)found.contains(this.person2));
        AssertJUnit.assertTrue((boolean)found.contains(this.person4));
        this.person4.setBlurb("Eats green, tasty, juicy grass.");
        this.cache.put((Object)"otherKey", (Object)this.person4);
        found = cacheQuery.list();
        AssertJUnit.assertEquals((int)2, (int)found.size());
        AssertJUnit.assertTrue((boolean)found.contains(this.person2));
        AssertJUnit.assertTrue((boolean)found.contains(this.person4));
        this.person4.setBlurb("Eats green, tasty, juicy, fresh grass.");
        this.cache.put((Object)"otherKey", (Object)this.person4);
        found = cacheQuery.list();
        AssertJUnit.assertEquals((int)1, (int)found.size());
        AssertJUnit.assertTrue((boolean)found.contains(this.person2));
    }

    public void testPhraseWithSlopWithoutAnalyzer() {
        this.loadNumericTypes();
        CacheQuery<NumericType> cacheQuery = this.createCacheQuery(NumericType.class, "name='Some string'");
        List found = cacheQuery.list();
        AssertJUnit.assertEquals((int)0, (int)found.size());
        NumericType type = new NumericType(10, 60);
        type.setName("Some string");
        this.cache.put((Object)"otherKey", (Object)type);
        found = cacheQuery.list();
        AssertJUnit.assertEquals((int)1, (int)found.size());
        AssertJUnit.assertTrue((boolean)found.contains(type));
        NumericType type1 = new NumericType(20, 60);
        type1.setName("Some other string");
        this.cache.put((Object)"otherKey1", (Object)type1);
        found = cacheQuery.list();
        AssertJUnit.assertEquals((int)1, (int)found.size());
        AssertJUnit.assertTrue((boolean)found.contains(type));
    }

    public void testAllExcept() {
        this.loadTestingData();
        CacheQuery<Person> cacheQuery = this.createCacheQuery(Person.class, "name:[* TO *]");
        List found = cacheQuery.list();
        AssertJUnit.assertEquals((int)3, (int)found.size());
        AssertJUnit.assertTrue((boolean)found.contains(this.person2));
        AssertJUnit.assertTrue((boolean)found.contains(this.person1));
        AssertJUnit.assertTrue((boolean)found.contains(this.person3));
        cacheQuery = this.createCacheQuery(Person.class, "-name:[* TO *]");
        found = cacheQuery.list();
        AssertJUnit.assertEquals((int)0, (int)found.size());
        cacheQuery = this.createCacheQuery(Person.class, "-name:'Goat'");
        found = cacheQuery.list();
        AssertJUnit.assertEquals((int)1, (int)found.size());
        AssertJUnit.assertTrue((boolean)found.contains(this.person1));
    }

    public void testAllExceptWithoutAnalyzer() {
        this.loadNumericTypes();
        CacheQuery<NumericType> cacheQuery = this.createCacheQuery(NumericType.class, "name LIKE '%string%'");
        List found = cacheQuery.list();
        AssertJUnit.assertEquals((int)3, (int)found.size());
        AssertJUnit.assertTrue((boolean)found.contains(this.type1));
        AssertJUnit.assertTrue((boolean)found.contains(this.type2));
        AssertJUnit.assertTrue((boolean)found.contains(this.type3));
        cacheQuery = this.createCacheQuery(NumericType.class, "not(name LIKE '%string%')");
        found = cacheQuery.list();
        AssertJUnit.assertEquals((int)0, (int)found.size());
    }

    private void loadTestingData() {
        this.person1 = new Person();
        this.person1.setName("Navin Surtani");
        this.person1.setBlurb("Likes playing WoW");
        this.person1.setAge(20);
        this.person2 = new Person();
        this.person2.setName("Big Goat");
        this.person2.setBlurb("Eats grass");
        this.person2.setAge(30);
        this.person3 = new Person();
        this.person3.setName("Mini Goat");
        this.person3.setBlurb("Eats cheese");
        this.person3.setAge(25);
        this.cache.put((Object)this.key1, (Object)this.person1);
        this.cache.put((Object)this.key2, (Object)this.person2);
        this.cache.put((Object)this.key3, (Object)this.person3);
    }

    private void loadNumericTypes() {
        this.type1 = new NumericType(10, 20);
        this.type1.setName("Some string for testing wildcards.");
        this.type2 = new NumericType(15, 25);
        this.type2.setName("This string has nothing to do with wildcards.");
        this.type3 = new NumericType(20, 30);
        this.type3.setName("Some other string for testing wildcards.");
        this.cache.put((Object)this.key1, (Object)this.type1);
        this.cache.put((Object)this.key2, (Object)this.type2);
        this.cache.put((Object)this.key3, (Object)this.type3);
    }
}

