/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.tx;

import java.util.concurrent.Callable;
import javax.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.Search;
import org.infinispan.query.SearchManager;
import org.infinispan.query.test.AnotherGrassEater;
import org.infinispan.query.test.Person;
import org.infinispan.query.test.QueryTestSCI;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.tx.NonLocalIndexingTest")
public class NonLocalIndexingTest
extends MultipleCacheManagersTest {
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder builder = NonLocalIndexingTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.REPL_SYNC, (boolean)this.transactionsEnabled());
        builder.indexing().enable().addIndexedEntity(Person.class).addIndexedEntity(AnotherGrassEater.class).addProperty("hibernate.search.default.directory_provider", "local-heap").addProperty("lucene_version", "LUCENE_CURRENT");
        this.createClusteredCaches(2, QueryTestSCI.INSTANCE, builder);
    }

    protected boolean transactionsEnabled() {
        return false;
    }

    public void testQueryAfterAddingNewNode() throws Exception {
        this.store("Astronaut", new Person("Astronaut", "is asking his timezone", 32), (Cache<Object, Object>)this.cache(0));
        this.assertFind("timezone", 1);
        this.assertFind("asking", 1);
        this.assertFind("cat", 0);
        this.store("Webdeveloper", new Person("Webdeveloper", "is confused by the timezone concept", 32), (Cache<Object, Object>)this.cache(1));
        this.assertFind("cat", 0);
        this.assertFind("timezone", 2);
        this.store("Astronaut", new Person("Astronaut", "thinks about his cat", 32), (Cache<Object, Object>)this.cache(1));
        this.assertFind("cat", 1);
        this.assertFind("timezone", 1);
        this.store("Astronaut", new AnotherGrassEater("Astronaut", "is having a hard time to find grass"), (Cache<Object, Object>)this.cache(1));
        this.assertFind("cat", 0);
        this.assertFind("grass", 0);
    }

    private void assertFind(String keyword, int expectedCount) {
        NonLocalIndexingTest.assertFind(this.cache(0), keyword, expectedCount);
        NonLocalIndexingTest.assertFind(this.cache(1), keyword, expectedCount);
    }

    private static void assertFind(Cache cache, String keyword, int expectedCount) {
        SearchManager queryFactory = Search.getSearchManager((Cache)cache);
        String q = String.format("FROM %s WHERE blurb:'%s'", Person.class.getName(), keyword);
        CacheQuery cacheQuery = queryFactory.getQuery(q);
        int resultSize = cacheQuery.getResultSize();
        Assert.assertEquals((int)resultSize, (int)expectedCount);
    }

    private void store(String key, Object value, Cache<Object, Object> cache) throws Exception {
        Callable<Void> callable = () -> {
            cache.put((Object)key, value);
            return null;
        };
        if (this.transactionsEnabled()) {
            TestingUtil.withTx((TransactionManager)cache.getAdvancedCache().getTransactionManager(), callable);
        } else {
            callable.call();
        }
    }
}

