/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.backend;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.search.analyzer.definition.LuceneAnalysisDefinitionProvider;
import org.hibernate.search.cfg.SearchMapping;
import org.hibernate.search.cfg.spi.SearchConfiguration;
import org.hibernate.search.cfg.spi.SearchConfigurationBase;
import org.hibernate.search.engine.service.classloading.spi.ClassLoaderService;
import org.hibernate.search.engine.service.spi.Service;
import org.hibernate.search.engine.spi.SearchMappingHelper;
import org.infinispan.Cache;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.query.backend.ClassLoaderServiceImpl;
import org.infinispan.query.logging.Log;
import org.infinispan.query.spi.ProgrammaticSearchMappingProvider;
import org.infinispan.util.logging.LogFactory;

public final class SearchableCacheConfiguration
extends SearchConfigurationBase
implements SearchConfiguration {
    private static final String HSEARCH_PREFIX = "hibernate.search.";
    private static final Log log = (Log)LogFactory.getLog(SearchableCacheConfiguration.class, Log.class);
    private final Map<String, Class<?>> classes = new HashMap();
    private final Properties properties;
    private final SearchMapping searchMapping;
    private final ClassLoaderServiceImpl classLoaderService;

    public SearchableCacheConfiguration(Set<Class<?>> indexedEntities, Properties properties, Collection<ProgrammaticSearchMappingProvider> programmaticSearchMappingProviders, Collection<LuceneAnalysisDefinitionProvider> analyzerDefProviders, ComponentRegistry cr, ClassLoader aggregatedClassLoader) {
        this.classLoaderService = new ClassLoaderServiceImpl(aggregatedClassLoader);
        this.properties = this.augmentProperties(properties);
        Cache cache = (Cache)cr.getComponent(Cache.class);
        LuceneAnalysisDefinitionProvider analyzerDefProvider = analyzerDefProviders != null && !analyzerDefProviders.isEmpty() ? builder -> {
            for (LuceneAnalysisDefinitionProvider provider : analyzerDefProviders) {
                if (log.isDebugEnabled()) {
                    log.debugf("Loading LuceneAnalysisDefinitionProvider for cache %s from provider : %s", cache.getName(), provider.getClass().getName());
                }
                provider.register(builder);
            }
        } : null;
        SearchMapping searchMapping = SearchMappingHelper.extractSearchMapping((SearchConfiguration)this);
        if (programmaticSearchMappingProviders != null && !programmaticSearchMappingProviders.isEmpty()) {
            if (searchMapping == null) {
                searchMapping = new SearchMapping();
            }
            for (ProgrammaticSearchMappingProvider programmaticSearchMappingProvider : programmaticSearchMappingProviders) {
                if (log.isDebugEnabled()) {
                    log.debugf("Loading programmatic search mappings for cache %s from provider : %s", cache.getName(), programmaticSearchMappingProvider.getClass().getName());
                }
                programmaticSearchMappingProvider.defineMappings(cache, searchMapping);
            }
        }
        this.searchMapping = searchMapping;
        for (Class clazz : indexedEntities) {
            if (log.isDebugEnabled()) {
                log.debugf("Found configured class mapping for Hibernate Search: %s", clazz.getName());
            }
            this.classes.put(clazz.getName(), clazz);
        }
        if (searchMapping != null) {
            for (Class clazz : searchMapping.getMappedEntities()) {
                if (log.isDebugEnabled()) {
                    log.debugf("Found programmatically configured class mapping for Hibernate Search: %s", clazz.getName());
                }
                this.classes.put(clazz.getName(), clazz);
            }
        }
    }

    public boolean isDeleteByTermEnforced() {
        return true;
    }

    public Iterator<Class<?>> getClassMappings() {
        return this.classes.values().iterator();
    }

    public Class<?> getClassMapping(String name) {
        return this.classes.get(name);
    }

    public String getProperty(String propertyName) {
        return this.properties.getProperty(propertyName);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public ReflectionManager getReflectionManager() {
        return null;
    }

    public SearchMapping getProgrammaticMapping() {
        return this.searchMapping;
    }

    public Map<Class<? extends Service>, Object> getProvidedServices() {
        return Collections.emptyMap();
    }

    public boolean isTransactionManagerExpected() {
        return false;
    }

    public boolean isIdProvidedImplicit() {
        return true;
    }

    private Properties augmentProperties(Properties origin) {
        Properties target = new Properties();
        if (origin != null) {
            for (Map.Entry<Object, Object> entry : origin.entrySet()) {
                Object key = entry.getKey();
                if (key instanceof String && !key.toString().startsWith(HSEARCH_PREFIX)) {
                    key = HSEARCH_PREFIX + key.toString();
                }
                target.put(key, entry.getValue());
            }
        }
        target.putIfAbsent("hibernate.search.index_uninverting_allowed", Boolean.TRUE.toString());
        return target;
    }

    public ClassLoaderService getClassLoaderService() {
        return this.classLoaderService;
    }
}

