/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.backend;

import java.util.Set;
import java.util.function.Consumer;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.IntSets;
import org.infinispan.distribution.LocalizedCacheTopology;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.TopologyChanged;
import org.infinispan.notifications.cachelistener.event.TopologyChangedEvent;
import org.infinispan.remoting.transport.Address;

@Listener(observation=Listener.Observation.POST)
final class SegmentListener {
    private final AdvancedCache<?, ?> cache;
    private final Consumer<IntSet> segmentDeleted;
    private final Address address;

    SegmentListener(AdvancedCache<?, ?> cache, Consumer<IntSet> segmentsDeleted) {
        this.cache = cache;
        this.segmentDeleted = segmentsDeleted;
        this.address = cache.getRpcManager().getAddress();
    }

    @TopologyChanged
    public void topologyChanged(TopologyChangedEvent<?, ?> event) {
        if (event.isPre()) {
            return;
        }
        ConsistentHash newWriteCh = event.getWriteConsistentHashAtEnd();
        LocalizedCacheTopology cacheTopology = this.cache.getDistributionManager().getCacheTopology();
        boolean isMember = cacheTopology.getMembers().contains(this.address);
        if (!isMember) {
            return;
        }
        int numSegments = newWriteCh.getNumSegments();
        IntSet removedSegments = IntSets.mutableEmptySet((int)numSegments);
        IntSet newSegments = IntSets.from((Set)newWriteCh.getSegmentsForOwner(this.address));
        for (int i = 0; i < numSegments; ++i) {
            if (newSegments.contains(i)) continue;
            removedSegments.add(i);
        }
        this.segmentDeleted.accept(removedSegments);
    }
}

