/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.clustered;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.hibernate.search.exception.SearchException;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.query.clustered.ClusteredQueryOperation;
import org.infinispan.query.clustered.QueryPartitioner;
import org.infinispan.query.clustered.QueryResponse;
import org.infinispan.query.clustered.SegmentsClusteredQueryCommand;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.SuccessfulResponse;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.rpc.RpcOptions;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.ResponseCollector;
import org.infinispan.remoting.transport.impl.MapResponseCollector;
import org.infinispan.remoting.transport.impl.SingleResponseCollector;
import org.infinispan.util.concurrent.CompletableFutures;

final class ClusteredQueryInvoker {
    private final RpcManager rpcManager;
    private final AdvancedCache<?, ?> cache;
    private final Address myAddress;
    private final ExecutorService asyncExecutor;
    private final RpcOptions rpcOptions;
    private final QueryPartitioner partitioner;

    ClusteredQueryInvoker(AdvancedCache<?, ?> cache, ExecutorService asyncExecutor) {
        this.cache = cache;
        this.asyncExecutor = asyncExecutor;
        this.rpcManager = cache.getRpcManager();
        this.myAddress = this.rpcManager.getAddress();
        this.rpcOptions = new RpcOptions(DeliverOrder.NONE, 10000L, TimeUnit.MILLISECONDS);
        this.partitioner = new QueryPartitioner(cache);
    }

    QueryResponse unicast(Address address, SegmentsClusteredQueryCommand cmd) {
        if (address.equals(this.myAddress)) {
            Future<QueryResponse> localResponse = this.localInvoke(cmd);
            try {
                return localResponse.get();
            }
            catch (InterruptedException e) {
                throw new SearchException("Interrupted while searching locally", (Throwable)e);
            }
            catch (ExecutionException e) {
                throw new SearchException("Exception while searching locally", (Throwable)e);
            }
        }
        CompletionStage completionStage = this.rpcManager.invokeCommand(address, (ReplicableCommand)cmd, (ResponseCollector)MapResponseCollector.ignoreLeavers(), this.rpcOptions);
        Map responses = (Map)this.rpcManager.blocking(completionStage);
        List<QueryResponse> queryResponses = this.cast(responses);
        return queryResponses.get(0);
    }

    List<QueryResponse> broadcast(ClusteredQueryOperation operation) {
        Map<Address, BitSet> split = this.partitioner.split();
        SegmentsClusteredQueryCommand localCommand = new SegmentsClusteredQueryCommand(this.cache.getName(), operation, split.get(this.myAddress));
        Future<QueryResponse> localResponse = this.localInvoke(localCommand);
        List futureRemoteResponses = split.entrySet().stream().filter(e -> !((Address)e.getKey()).equals(this.myAddress)).map(e -> {
            Address address = (Address)e.getKey();
            BitSet segments = (BitSet)e.getValue();
            SegmentsClusteredQueryCommand cmd = new SegmentsClusteredQueryCommand(this.cache.getName(), operation, segments);
            return this.rpcManager.invokeCommand(address, (ReplicableCommand)cmd, (ResponseCollector)SingleResponseCollector.validOnly(), this.rpcOptions).toCompletableFuture();
        }).map(a -> a.thenApply(r -> (QueryResponse)r.getResponseValue())).collect(Collectors.toList());
        ArrayList<QueryResponse> results = new ArrayList<QueryResponse>();
        try {
            results.add(localResponse.get());
            List responseList = (List)CompletableFutures.sequence(futureRemoteResponses).get();
            results.addAll(responseList);
        }
        catch (InterruptedException e2) {
            throw new SearchException("Interrupted while searching locally", (Throwable)e2);
        }
        catch (ExecutionException e3) {
            throw new SearchException("Exception while searching locally", (Throwable)e3);
        }
        return results;
    }

    private Future<QueryResponse> localInvoke(SegmentsClusteredQueryCommand cmd) {
        return this.asyncExecutor.submit(() -> {
            try {
                return cmd.perform((Cache<?, ?>)this.cache);
            }
            catch (Throwable e) {
                throw new SearchException(e);
            }
        });
    }

    private List<QueryResponse> cast(Map<Address, Response> responses) {
        LinkedList<QueryResponse> queryResponses = new LinkedList<QueryResponse>();
        for (Response resp : responses.values()) {
            if (resp instanceof SuccessfulResponse) {
                QueryResponse response = (QueryResponse)((SuccessfulResponse)resp).getResponseValue();
                queryResponses.add(response);
                continue;
            }
            throw new SearchException("Unexpected response: " + resp);
        }
        return queryResponses;
    }
}

