/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.clustered;

import java.util.BitSet;
import java.util.Map;
import java.util.UUID;
import org.apache.lucene.search.Sort;
import org.infinispan.AdvancedCache;
import org.infinispan.query.clustered.ClusteredQueryInvoker;
import org.infinispan.query.clustered.ClusteredQueryOperation;
import org.infinispan.query.clustered.DistributedIterator;
import org.infinispan.query.clustered.NodeTopDocs;
import org.infinispan.query.clustered.SegmentsClusteredQueryCommand;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

final class DistributedLazyIterator<E>
extends DistributedIterator<E> {
    private static final Log log = LogFactory.getLog(DistributedLazyIterator.class);
    private final UUID queryId;
    private final ClusteredQueryInvoker invoker;

    DistributedLazyIterator(Sort sort, int fetchSize, int resultSize, int maxResults, int firstResult, UUID queryId, Map<Address, NodeTopDocs> topDocsResponses, ClusteredQueryInvoker invoker, AdvancedCache<?, ?> cache) {
        super(sort, fetchSize, resultSize, maxResults, firstResult, topDocsResponses, cache);
        this.queryId = queryId;
        this.invoker = invoker;
    }

    @Override
    public void close() {
        try {
            this.invoker.broadcast(ClusteredQueryOperation.destroyLazyQuery(this.queryId));
        }
        catch (Exception e) {
            log.error((Object)"Could not close the distributed iterator", (Throwable)e);
        }
    }

    @Override
    protected E fetchValue(int scoreIndex, NodeTopDocs nodeTopDocs) {
        ClusteredQueryOperation operation = ClusteredQueryOperation.retrieveKeyFromLazyQuery(this.queryId, scoreIndex);
        SegmentsClusteredQueryCommand cmd = new SegmentsClusteredQueryCommand(this.cache.getName(), operation, new BitSet());
        Object fetchedValue = this.invoker.unicast(nodeTopDocs.address, cmd).getFetchedValue();
        if (fetchedValue instanceof Object[]) {
            return (E)fetchedValue;
        }
        return (E)this.cache.getValueDataConversion().fromStorage(fetchedValue);
    }
}

