/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.clustered.commandworkers;

import java.util.BitSet;
import java.util.UUID;
import java.util.function.Supplier;
import org.infinispan.AdvancedCache;
import org.infinispan.query.clustered.QueryResponse;
import org.infinispan.query.clustered.commandworkers.CQCreateEagerQuery;
import org.infinispan.query.clustered.commandworkers.CQCreateLazyQuery;
import org.infinispan.query.clustered.commandworkers.CQGetResultSize;
import org.infinispan.query.clustered.commandworkers.CQKillLazyIterator;
import org.infinispan.query.clustered.commandworkers.CQLazyFetcher;
import org.infinispan.query.clustered.commandworkers.CQWorker;
import org.infinispan.query.impl.QueryDefinition;

public enum CQCommandType {
    CREATE_LAZY_ITERATOR(CQCreateLazyQuery::new),
    CREATE_EAGER_ITERATOR(CQCreateEagerQuery::new),
    DESTROY_LAZY_ITERATOR(CQKillLazyIterator::new),
    GET_SOME_KEYS(CQLazyFetcher::new),
    GET_RESULT_SIZE(CQGetResultSize::new);

    private static final CQCommandType[] CACHED_VALUES;
    private final Supplier<CQWorker> workerSupplier;

    public static CQCommandType valueOf(int ordinal) {
        return CACHED_VALUES[ordinal];
    }

    private CQCommandType(Supplier<CQWorker> workerSupplier) {
        this.workerSupplier = workerSupplier;
    }

    public QueryResponse perform(AdvancedCache<?, ?> cache, QueryDefinition queryDefinition, UUID queryId, int docIndex, BitSet segments) {
        CQWorker worker = this.workerSupplier.get();
        worker.initialize(cache.withStorageMediaType(), queryDefinition, queryId, docIndex);
        return worker.perform(segments);
    }

    static {
        CACHED_VALUES = CQCommandType.values();
    }
}

