/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.search.spi.IndexedTypeIdentifier;
import org.hibernate.search.spi.SearchIntegrator;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;

@Scope(value=Scopes.NAMED_CACHE)
public final class IndexInspector {
    private final Map<String, Class<?>> indexedEntities;

    public IndexInspector(Configuration cfg, SearchIntegrator searchFactory) {
        HashMap<String, Class> entities = new HashMap<String, Class>(2);
        for (Class c : cfg.indexing().indexedEntities()) {
            entities.put(c.getName(), c);
        }
        for (IndexedTypeIdentifier typeIdentifier : searchFactory.getIndexBindings().keySet()) {
            Class c = typeIdentifier.getPojoType();
            entities.put(c.getName(), c);
        }
        this.indexedEntities = Collections.unmodifiableMap(entities);
    }

    public Map<String, Class<?>> getIndexedEntities() {
        return this.indexedEntities;
    }

    public boolean isIndexedType(Object value) {
        if (value == null) {
            return false;
        }
        Class<?> c = value.getClass();
        return this.indexedEntities.containsValue(c);
    }
}

