/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.impl.massindex;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.hibernate.search.spi.IndexedTypeIdentifier;
import org.hibernate.search.spi.SearchIntegrator;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.time.TimeService;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedOperation;
import org.infinispan.manager.ClusterExecutor;
import org.infinispan.query.MassIndexer;
import org.infinispan.query.backend.KeyTransformationHandler;
import org.infinispan.query.impl.IndexInspector;
import org.infinispan.query.impl.massindex.IndexUpdater;
import org.infinispan.query.impl.massindex.IndexWorker;
import org.infinispan.query.impl.massindex.MassIndexLock;
import org.infinispan.query.impl.massindex.MassIndexerAlreadyStartedException;
import org.infinispan.query.impl.massindex.MassIndexerLockFactory;
import org.infinispan.query.logging.Log;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.concurrent.BlockingManager;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.concurrent.CompletionStages;
import org.infinispan.util.function.TriConsumer;
import org.infinispan.util.logging.LogFactory;

@MBean(objectName="MassIndexer", description="Component that rebuilds the Lucene index from the cached data")
@Scope(value=Scopes.NAMED_CACHE)
public class DistributedExecutorMassIndexer
implements MassIndexer {
    private static final Log LOG = (Log)LogFactory.getLog(DistributedExecutorMassIndexer.class, Log.class);
    private final AdvancedCache<?, ?> cache;
    private final SearchIntegrator searchIntegrator;
    private final IndexUpdater indexUpdater;
    private final ClusterExecutor executor;
    private final BlockingManager blockingManager;
    private final MassIndexLock lock;
    @Inject
    IndexInspector indexInspector;
    private static final TriConsumer<Address, Void, Throwable> TRI_CONSUMER = (a, v, t) -> {
        if (t != null) {
            throw new CacheException(t);
        }
    };

    public DistributedExecutorMassIndexer(AdvancedCache<?, ?> cache, SearchIntegrator searchIntegrator, KeyTransformationHandler keyTransformationHandler, TimeService timeService) {
        this.cache = cache;
        this.searchIntegrator = searchIntegrator;
        this.indexUpdater = new IndexUpdater(searchIntegrator, keyTransformationHandler, timeService);
        this.executor = cache.getCacheManager().executor();
        this.blockingManager = (BlockingManager)cache.getCacheManager().getGlobalComponentRegistry().getComponent(BlockingManager.class);
        this.lock = MassIndexerLockFactory.buildLock(cache);
    }

    @Override
    @ManagedOperation(description="Starts rebuilding the index", displayName="Rebuild index")
    public void start() {
        CompletionStages.join(this.executeInternal(false));
    }

    @Override
    public CompletableFuture<Void> purge() {
        return this.executeInternal(true);
    }

    @Override
    public CompletableFuture<Void> startAsync() {
        return this.executeInternal(false);
    }

    @Override
    public CompletableFuture<Void> reindex(Object ... keys) {
        CompletableFuture future = null;
        HashSet<Object> keySet = new HashSet<Object>();
        for (Object key : keys) {
            if (this.cache.containsKey(key)) {
                keySet.add(key);
                continue;
            }
            LOG.warn("cache contains no mapping for the key");
        }
        TriConsumer triConsumer = (a, v, t) -> {
            if (t != null) {
                throw new CacheException(t);
            }
        };
        if (keySet.size() > 0) {
            IndexWorker indexWorker = new IndexWorker(this.cache.getName(), null, false, keySet);
            future = this.executor.submitConsumer((Function)indexWorker, triConsumer);
        }
        return future != null ? future : CompletableFutures.completedNull();
    }

    @Override
    public boolean isRunning() {
        return this.lock.isAcquired();
    }

    private CompletableFuture<Void> executeInternal(boolean skipIndex) {
        if (this.lock.lock()) {
            LinkedList toFlush = new LinkedList();
            BiConsumer<Void, Throwable> flushIfNeeded = (v, t) -> {
                try {
                    this.indexUpdater.flush(toFlush);
                }
                finally {
                    this.lock.unlock();
                }
            };
            HashSet<IndexedTypeIdentifier> indexedTypes = new HashSet<IndexedTypeIdentifier>();
            for (IndexedTypeIdentifier indexedType : this.searchIntegrator.getIndexBindings().keySet()) {
                indexedTypes.add(indexedType);
            }
            try {
                IndexWorker indexWork = new IndexWorker(this.cache.getName(), indexedTypes, skipIndex, null);
                CompletableFuture future = this.executor.timeout(Long.MAX_VALUE, TimeUnit.SECONDS).submitConsumer((Function)indexWork, TRI_CONSUMER);
                return this.blockingManager.whenCompleteBlocking((CompletionStage)future, flushIfNeeded, (Object)this).toCompletableFuture();
            }
            catch (Throwable t2) {
                this.lock.unlock();
                return CompletableFutures.completedExceptionFuture((Throwable)t2);
            }
        }
        return CompletableFutures.completedExceptionFuture((Throwable)new MassIndexerAlreadyStartedException());
    }
}

