/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.timeout;

import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.query.SearchTimeoutException;
import org.infinispan.query.test.Person;
import org.infinispan.query.test.QueryTestSCI;
import org.infinispan.query.timeout.TestHelper;
import org.infinispan.test.MultipleCacheManagersTest;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.timeout.DistributedIndexedTimeoutTest")
public class DistributedIndexedTimeoutTest
extends MultipleCacheManagersTest {
    protected Cache<Integer, Person> cache1;

    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder cacheCfg = DistributedIndexedTimeoutTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false);
        cacheCfg.indexing().enable().addIndexedEntity(Person.class).addProperty("default.directory_provider", "local-heap");
        this.createClusteredCaches(2, QueryTestSCI.INSTANCE, cacheCfg);
        this.cache1 = this.cache(0);
    }

    @BeforeMethod
    public void populate() {
        TestHelper.populate(this.cache1, 20);
    }

    @Test(expectedExceptions={SearchTimeoutException.class})
    public void testTimeout() {
        TestHelper.runFullTextQueryWithTimeout(this.cache1, 1L, TimeUnit.NANOSECONDS);
    }
}

