/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.api;

import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.query.Search;
import org.infinispan.query.api.AnotherTestEntity;
import org.infinispan.query.api.NotIndexedType;
import org.infinispan.query.api.TestEntity;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.helper.StaticTestingErrorHandler;
import org.infinispan.query.test.QueryTestSCI;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.api.PutAllTest")
@CleanupAfterMethod
public class PutAllTest
extends SingleCacheManagerTest {
    private StorageType storageType;

    protected String parameters() {
        return "[" + this.storageType + "]";
    }

    @Factory
    public Object[] factory() {
        return new Object[]{new PutAllTest().storageType(StorageType.OFF_HEAP), new PutAllTest().storageType(StorageType.BINARY), new PutAllTest().storageType(StorageType.OBJECT)};
    }

    PutAllTest storageType(StorageType storageType) {
        this.storageType = storageType;
        return this;
    }

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder cfg = this.getDefaultStandaloneCacheConfig(true);
        cfg.indexing().enable().addIndexedEntity(TestEntity.class).addIndexedEntity(AnotherTestEntity.class).addProperty("default.directory_provider", "local-heap").addProperty("error_handler", StaticTestingErrorHandler.class.getName()).addProperty("lucene_version", "LUCENE_CURRENT");
        cfg.memory().storageType(this.storageType);
        return TestCacheManagerFactory.createCacheManager((SerializationContextInitializer)QueryTestSCI.INSTANCE, (ConfigurationBuilder)cfg);
    }

    public void testOverwriteNotIndexedValue() {
        long id = 10L;
        this.cache.put((Object)10L, (Object)new NotIndexedType("name1"));
        HashMap<Long, TestEntity> map = new HashMap<Long, TestEntity>();
        map.put(10L, new TestEntity("name2", "surname2", 10L, "note"));
        this.cache.putAll(map);
        Query<AnotherTestEntity> q1 = this.queryByNameField("name2", AnotherTestEntity.class);
        Query<TestEntity> q2 = this.queryByNameField("name2", TestEntity.class);
        AssertJUnit.assertEquals((long)1L, (long)(q1.execute().hitCount().orElse(-1L) + q2.execute().hitCount().orElse(-1L)));
        AssertJUnit.assertEquals(TestEntity.class, ((TestEntity)q2.list().get(0)).getClass());
        StaticTestingErrorHandler.assertAllGood(this.cache);
    }

    public void testAsyncOverwriteNotIndexedValue() throws Exception {
        long id = 10L;
        this.cache.put((Object)10L, (Object)new NotIndexedType("name1"));
        HashMap<Long, TestEntity> map = new HashMap<Long, TestEntity>();
        map.put(10L, new TestEntity("name2", "surname2", 10L, "note"));
        CompletableFuture futureTask = this.cache.putAllAsync(map);
        futureTask.get();
        AssertJUnit.assertTrue((boolean)futureTask.isDone());
        Query<TestEntity> q1 = this.queryByNameField("name2", TestEntity.class);
        Query<AnotherTestEntity> q2 = this.queryByNameField("name2", AnotherTestEntity.class);
        AssertJUnit.assertEquals((long)1L, (long)(q1.execute().hitCount().orElse(-1L) + q2.execute().hitCount().orElse(-1L)));
        AssertJUnit.assertEquals(TestEntity.class, ((TestEntity)q1.list().get(0)).getClass());
        StaticTestingErrorHandler.assertAllGood(this.cache);
    }

    public void testOverwriteWithNonIndexedValue() {
        long id = 10L;
        this.cache.put((Object)10L, (Object)new TestEntity("name1", "surname1", 10L, "note"));
        Query<TestEntity> q1 = this.queryByNameField("name1", TestEntity.class);
        Object q2 = this.queryByNameField("name1", AnotherTestEntity.class);
        AssertJUnit.assertEquals((long)1L, (long)(q1.execute().hitCount().orElse(-1L) + q2.execute().hitCount().orElse(-1L)));
        AssertJUnit.assertEquals(TestEntity.class, ((TestEntity)q1.list().get(0)).getClass());
        HashMap<Long, NotIndexedType> map = new HashMap<Long, NotIndexedType>();
        map.put(10L, new NotIndexedType("name2"));
        this.cache.putAll(map);
        q2 = this.queryByNameField("name1", TestEntity.class);
        AssertJUnit.assertEquals((long)0L, (long)q2.execute().hitCount().orElse(-1L));
        Query<TestEntity> q3 = this.queryByNameField("name2", TestEntity.class);
        AssertJUnit.assertEquals((long)0L, (long)q3.execute().hitCount().orElse(-1L));
        StaticTestingErrorHandler.assertAllGood(this.cache);
    }

    public void testAsyncOverwriteWithNonIndexedValue() throws Exception {
        long id = 10L;
        this.cache.put((Object)10L, (Object)new TestEntity("name1", "surname1", 10L, "note"));
        Query<TestEntity> q1 = this.queryByNameField("name1", TestEntity.class);
        AssertJUnit.assertEquals((long)1L, (long)q1.execute().hitCount().orElse(-1L));
        AssertJUnit.assertEquals(TestEntity.class, q1.list().get(0).getClass());
        HashMap<Long, NotIndexedType> map = new HashMap<Long, NotIndexedType>();
        map.put(10L, new NotIndexedType("name2"));
        CompletableFuture futureTask = this.cache.putAllAsync(map);
        futureTask.get();
        AssertJUnit.assertTrue((boolean)futureTask.isDone());
        Query<TestEntity> q2 = this.queryByNameField("name1", TestEntity.class);
        AssertJUnit.assertEquals((long)0L, (long)q2.execute().hitCount().orElse(-1L));
        Query<TestEntity> q3 = this.queryByNameField("name2", TestEntity.class);
        AssertJUnit.assertEquals((long)0L, (long)q3.execute().hitCount().orElse(-1L));
        StaticTestingErrorHandler.assertAllGood(this.cache);
    }

    public void testOverwriteIndexedValue() {
        long id = 10L;
        this.cache.put((Object)10L, (Object)new TestEntity("name1", "surname1", 10L, "note"));
        Query<TestEntity> q1 = this.queryByNameField("name1", TestEntity.class);
        AssertJUnit.assertEquals((long)1L, (long)q1.execute().hitCount().orElse(-1L));
        AssertJUnit.assertEquals(TestEntity.class, ((TestEntity)q1.list().get(0)).getClass());
        HashMap<Long, AnotherTestEntity> map = new HashMap<Long, AnotherTestEntity>();
        map.put(10L, new AnotherTestEntity("name2"));
        this.cache.putAll(map);
        Query<TestEntity> q2 = this.queryByNameField("name1", TestEntity.class);
        AssertJUnit.assertEquals((long)0L, (long)q2.execute().hitCount().orElse(-1L));
        Query<AnotherTestEntity> q3 = this.queryByNameField("name2", AnotherTestEntity.class);
        AssertJUnit.assertEquals((long)1L, (long)q3.execute().hitCount().orElse(-1L));
        AssertJUnit.assertEquals(AnotherTestEntity.class, ((AnotherTestEntity)q3.list().get(0)).getClass());
        StaticTestingErrorHandler.assertAllGood(this.cache);
    }

    private <T> Query<T> queryByNameField(String name, Class<T> entity) {
        QueryFactory queryFactory = Search.getQueryFactory((Cache)this.cache);
        return queryFactory.create(String.format("FROM %s WHERE name = '%s'", entity.getName(), name));
    }
}

