/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.blackbox;

import java.util.List;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.InterceptorConfiguration;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.interceptors.DDAsyncInterceptor;
import org.infinispan.query.Search;
import org.infinispan.query.backend.QueryInterceptor;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.indexedembedded.Book;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.CacheManagerCallable;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(testName="query.blackbox.IndexedCacheRestartTest", groups={"functional"})
public class IndexedCacheRestartTest
extends AbstractInfinispanTest {
    public void testIndexedCacheRestart() {
        this.indexedCacheRestart(false);
    }

    public void testLocalIndexedCacheRestart() {
        this.indexedCacheRestart(true);
    }

    private void indexedCacheRestart(boolean localOnly) {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.indexing().enable().addIndexedEntity(Book.class).addProperty("default.directory_provider", "local-heap").addProperty("lucene_version", "LUCENE_CURRENT");
        final NoOpInterceptor noOpInterceptor = new NoOpInterceptor();
        builder.customInterceptors().addInterceptor().interceptor((AsyncInterceptor)noOpInterceptor).position(InterceptorConfiguration.Position.FIRST);
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)builder)){

            public void call() {
                Cache cache = this.cm.getCache();
                AssertJUnit.assertNotNull((Object)TestingUtil.extractInterceptorChain((Cache)cache).findInterceptorExtending(QueryInterceptor.class));
                AssertJUnit.assertTrue((boolean)cache.isEmpty());
                this.addABook((Cache<String, Book>)cache);
                IndexedCacheRestartTest.assertFindBook(cache);
                cache.stop();
                IndexedCacheRestartTest.this.assertCacheHasCustomInterceptor(cache, (AsyncInterceptor)noOpInterceptor);
                cache.start();
                AssertJUnit.assertNotNull((Object)TestingUtil.extractInterceptorChain((Cache)cache).findInterceptorExtending(QueryInterceptor.class));
                AssertJUnit.assertTrue((boolean)cache.isEmpty());
                this.addABook((Cache<String, Book>)cache);
                IndexedCacheRestartTest.assertFindBook(cache);
                IndexedCacheRestartTest.this.assertCacheHasCustomInterceptor(cache, (AsyncInterceptor)noOpInterceptor);
            }

            private void addABook(Cache<String, Book> cache) {
                cache.put((Object)"1", (Object)new Book("Infinispan Data Grid Platform", "Francesco Marchioni and Manik Surtani", "Packt Publishing"));
            }
        });
    }

    private void assertCacheHasCustomInterceptor(Cache<?, ?> cache, AsyncInterceptor interceptor) {
        for (InterceptorConfiguration interceptorConfig : cache.getCacheConfiguration().customInterceptors().interceptors()) {
            if (interceptor != interceptorConfig.asyncInterceptor()) continue;
            return;
        }
        AssertJUnit.fail((String)("Expected to find interceptor " + interceptor + " among custom interceptors of cache, but it was not there."));
    }

    private static void assertFindBook(Cache<?, ?> cache) {
        String q = String.format("FROM %s WHERE title:'infinispan'", Book.class.getName());
        Query cacheQuery = Search.getQueryFactory(cache).create(q);
        List list = cacheQuery.list();
        AssertJUnit.assertEquals((int)1, (int)list.size());
    }

    static class NoOpInterceptor
    extends DDAsyncInterceptor {
        NoOpInterceptor() {
        }
    }
}

