/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.config;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.Set;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.indexes.spi.DirectoryBasedIndexManager;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.spi.SearchIntegrator;
import org.hibernate.search.store.impl.RAMDirectoryProvider;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.helper.TestQueryHelperFactory;
import org.infinispan.query.test.Person;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(testName="query.config.DeclarativeConfigTest", groups={"functional"})
public class DeclarativeConfigTest
extends SingleCacheManagerTest {
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        String config = TestingUtil.wrapXMLWithSchema((String)"<cache-container default-cache=\"default\">   <local-cache name=\"default\">\n      <indexing>\n         <indexed-entities>\n            <indexed-entity>org.infinispan.query.test.Person</indexed-entity>\n         </indexed-entities>\n         <property name=\"default.directory_provider\">local-heap</property>\n         <property name=\"lucene_version\">LUCENE_CURRENT</property>\n      </indexing>\n   </local-cache>\n</cache-container>");
        this.log.tracef("Using test configuration:\n%s", (Object)config);
        try (ByteArrayInputStream is = new ByteArrayInputStream(config.getBytes());){
            this.cacheManager = TestCacheManagerFactory.fromStream((InputStream)is);
        }
        this.cache = this.cacheManager.getCache();
        return this.cacheManager;
    }

    public void simpleIndexTest() {
        this.cache.put((Object)"1", (Object)new Person("A Person's Name", "A paragraph containing some text", 75));
        Query cq = TestQueryHelperFactory.createCacheQuery(Person.class, this.cache, "name", "Name");
        AssertJUnit.assertEquals((long)1L, (long)cq.execute().hitCount().orElse(-1L));
        List l = cq.execute().list();
        AssertJUnit.assertEquals((int)1, (int)l.size());
        Person p = (Person)l.get(0);
        AssertJUnit.assertEquals((String)"A Person's Name", (String)p.getName());
        AssertJUnit.assertEquals((String)"A paragraph containing some text", (String)p.getBlurb());
        AssertJUnit.assertEquals((int)75, (int)p.getAge());
    }

    public void testPropertiesWhereRead() {
        SearchIntegrator searchFactory = TestQueryHelperFactory.extractSearchFactory(this.cache);
        EntityIndexBinding indexBindingForEntity = (EntityIndexBinding)searchFactory.getIndexBindings().get(Person.class);
        Set managers = indexBindingForEntity.getIndexManagerSelector().all();
        AssertJUnit.assertEquals((int)1, (int)managers.size());
        IndexManager manager = (IndexManager)managers.iterator().next();
        AssertJUnit.assertNotNull((Object)manager);
        AssertJUnit.assertTrue((boolean)(manager instanceof DirectoryBasedIndexManager));
        DirectoryBasedIndexManager dbim = (DirectoryBasedIndexManager)manager;
        AssertJUnit.assertTrue((boolean)(dbim.getDirectoryProvider() instanceof RAMDirectoryProvider));
    }
}

