/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.dsl.embedded;

import java.util.HashMap;
import java.util.Map;
import org.hibernate.search.spi.SearchIntegrator;
import org.hibernate.search.spi.impl.PojoIndexedTypeIdentifier;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.IndexingConfigurationBuilder;
import org.infinispan.query.dsl.embedded.DslSCI;
import org.infinispan.query.dsl.embedded.QueryDslConditionsTest;
import org.infinispan.test.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.dsl.embedded.ClusteredQueryDslConditionsTest")
public class ClusteredQueryDslConditionsTest
extends QueryDslConditionsTest {
    protected static final String TEST_CACHE_NAME = "custom";
    protected Cache<Object, Object> cache1;
    protected Cache<Object, Object> cache2;

    protected Cache<Object, Object> getCacheForWrite() {
        return this.cache1;
    }

    protected Cache<Object, Object> getCacheForQuery() {
        return this.cache2;
    }

    protected Map<String, String> getIndexConfig() {
        HashMap<String, String> configs = new HashMap<String, String>();
        configs.put("default.directory_provider", "local-heap");
        configs.put("lucene_version", "LUCENE_CURRENT");
        return configs;
    }

    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder defaultConfiguration = ClusteredQueryDslConditionsTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.REPL_SYNC, (boolean)false);
        defaultConfiguration.clustering().stateTransfer().fetchInMemoryState(true);
        this.createClusteredCaches(2, DslSCI.INSTANCE, defaultConfiguration);
        ConfigurationBuilder cfg = this.initialCacheConfiguration();
        IndexingConfigurationBuilder indexingConfigurationBuilder = cfg.clustering().stateTransfer().fetchInMemoryState(true).indexing().enable().addIndexedEntity(this.getModelFactory().getUserImplClass()).addIndexedEntity(this.getModelFactory().getAccountImplClass()).addIndexedEntity(this.getModelFactory().getTransactionImplClass());
        this.getIndexConfig().forEach((arg_0, arg_1) -> ((IndexingConfigurationBuilder)indexingConfigurationBuilder).addProperty(arg_0, arg_1));
        this.manager(0).defineConfiguration(TEST_CACHE_NAME, cfg.build());
        this.manager(1).defineConfiguration(TEST_CACHE_NAME, cfg.build());
        this.cache1 = this.manager(0).getCache(TEST_CACHE_NAME);
        this.cache2 = this.manager(1).getCache(TEST_CACHE_NAME);
    }

    protected ConfigurationBuilder initialCacheConfiguration() {
        return ClusteredQueryDslConditionsTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.REPL_SYNC, (boolean)false);
    }

    @Override
    public void testIndexPresence() {
        this.checkIndexPresence(this.cache1);
        this.checkIndexPresence(this.cache2);
    }

    private void checkIndexPresence(Cache<?, ?> cache) {
        SearchIntegrator searchIntegrator = (SearchIntegrator)TestingUtil.extractComponent(cache, SearchIntegrator.class);
        this.verifyClassIsIndexed(searchIntegrator, this.getModelFactory().getUserImplClass());
        this.verifyClassIsIndexed(searchIntegrator, this.getModelFactory().getAccountImplClass());
        this.verifyClassIsIndexed(searchIntegrator, this.getModelFactory().getTransactionImplClass());
        this.verifyClassIsNotIndexed(searchIntegrator, this.getModelFactory().getAddressImplClass());
    }

    private void verifyClassIsNotIndexed(SearchIntegrator searchIntegrator, Class<?> type) {
        AssertJUnit.assertFalse((boolean)searchIntegrator.getIndexBindings().containsKey(PojoIndexedTypeIdentifier.convertFromLegacy(type)));
        AssertJUnit.assertNull((Object)searchIntegrator.getIndexManager(type.getName()));
    }

    private void verifyClassIsIndexed(SearchIntegrator searchIntegrator, Class<?> type) {
        AssertJUnit.assertTrue((boolean)searchIntegrator.getIndexBindings().containsKey(PojoIndexedTypeIdentifier.convertFromLegacy(type)));
        AssertJUnit.assertNotNull((Object)searchIntegrator.getIndexManager(type.getName()));
    }
}

