/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.dsl.embedded;

import java.util.ArrayList;
import org.infinispan.Cache;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.event.CacheEntryCreatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryModifiedEvent;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilter;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.query.Search;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.test.Person;
import org.infinispan.query.test.QueryTestSCI;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.Test;

@Test(groups={"profiling"}, testName="query.dsl.embedded.ListenerWithDslFilterProfilingTest")
public class ListenerWithDslFilterProfilingTest
extends SingleCacheManagerTest {
    private static final int NUM_ENTRIES = 100000;
    private static final int NUM_LISTENERS = 1000;

    protected EmbeddedCacheManager createCacheManager() {
        return TestCacheManagerFactory.createCacheManager((SerializationContextInitializer)QueryTestSCI.INSTANCE);
    }

    public void testEventFilterPerformance() {
        QueryFactory qf = Search.getQueryFactory((Cache)this.cache());
        Query query = qf.create("FROM org.infinispan.query.test.Person WHERE age <= 31");
        ArrayList<NoOpEntryListener> listeners = new ArrayList<NoOpEntryListener>(1000);
        for (int i = 0; i < 1000; ++i) {
            NoOpEntryListener listener = new NoOpEntryListener();
            listeners.add(listener);
            this.cache().addListener((Object)listener, (CacheEventFilter)Search.makeFilter((Query)query), null);
        }
        long startTs = System.nanoTime();
        for (int i = 0; i < 100000; ++i) {
            Person value = new Person();
            value.setName("John");
            value.setAge(i + 25);
            this.cache.put((Object)i, (Object)value);
        }
        long endTs = System.nanoTime();
        for (NoOpEntryListener listener : listeners) {
            this.cache().removeListener((Object)listener);
        }
        this.log.infof("ListenerWithDslFilterProfilingTest.testEventFilterPerformance took %d us\n", (Object)((endTs - startTs) / 1000L));
    }

    @Listener
    private static class NoOpEntryListener {
        private NoOpEntryListener() {
        }

        @CacheEntryCreated
        public void handleEvent(CacheEntryCreatedEvent<?, ?> event) {
        }

        @CacheEntryModified
        public void handleEvent(CacheEntryModifiedEvent<?, ?> event) {
        }
    }
}

