/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.queries.ranges;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.Search;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.test.Person;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.queries.ranges.QueryRangesTest")
public class QueryRangesTest
extends SingleCacheManagerTest {
    protected final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private Person person1;
    private Person person2;
    private Person person3;
    private Person person4;
    protected String key1 = "test1";
    protected String key2 = "test2";
    protected String key3 = "test3";

    public QueryRangesTest() {
        this.cleanup = AbstractCacheTest.CleanupPhase.AFTER_METHOD;
        this.DATE_FORMAT.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    protected Query<Person> createQuery(String predicate) {
        QueryFactory searchManager = Search.getQueryFactory((Cache)this.cache);
        String query = String.format("FROM %s WHERE %s", Person.class.getName(), predicate);
        return searchManager.create(query);
    }

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder cfg = this.getDefaultStandaloneCacheConfig(true);
        cfg.indexing().enable().addIndexedEntity(Person.class).addProperty("default.directory_provider", "local-heap").addProperty("lucene_version", "LUCENE_CURRENT");
        return TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)cfg);
    }

    public void testQueryingRangeBelowExcludingLimit() throws ParseException {
        this.loadTestingData();
        Query<Person> cacheQuery = this.createQuery("age:[* TO 29]");
        List found = cacheQuery.execute().list();
        AssertJUnit.assertEquals((int)2, (int)found.size());
        assert (found.contains(this.person1));
        assert (found.contains(this.person3));
        assert (!found.contains(this.person4)) : "This should not contain object person4";
        this.person4 = new Person();
        this.person4.setName("Mighty Goat");
        this.person4.setBlurb("Also eats grass");
        this.person4.setAge(28);
        this.cache.put((Object)"mighty", (Object)this.person4);
        found = cacheQuery.execute().list();
        assert (found.size() == 3) : "Size of list should be 3";
        assert (found.contains(this.person1));
        assert (found.contains(this.person3));
        assert (found.contains(this.person4)) : "This should now contain object person4";
    }

    public void testQueryingRangeBelowWithLimit() throws ParseException {
        this.loadTestingData();
        Query<Person> cacheQuery = this.createQuery("age:[* to 30]");
        List found = cacheQuery.execute().list();
        AssertJUnit.assertEquals((int)3, (int)found.size());
        assert (found.contains(this.person1));
        assert (found.contains(this.person2));
        assert (found.contains(this.person3));
        assert (!found.contains(this.person4)) : "This should not contain object person4";
        this.person4 = new Person();
        this.person4.setName("Mighty Goat");
        this.person4.setBlurb("Also eats grass");
        this.person4.setAge(28);
        this.cache.put((Object)"mighty", (Object)this.person4);
        found = cacheQuery.execute().list();
        assert (found.size() == 4) : "Size of list should be 4";
        assert (found.contains(this.person1));
        assert (found.contains(this.person2));
        assert (found.contains(this.person3));
        assert (found.contains(this.person4)) : "This should now contain object person4";
    }

    public void testQueryingRangeAboveExcludingLimit() throws ParseException {
        this.loadTestingData();
        Query<Person> cacheQuery = this.createQuery("age:[31 to *]");
        List found = cacheQuery.execute().list();
        AssertJUnit.assertEquals((int)0, (int)found.size());
        cacheQuery = this.createQuery("age:[21 to *]");
        found = cacheQuery.execute().list();
        AssertJUnit.assertEquals((int)2, (int)found.size());
        assert (found.contains(this.person2));
        assert (found.contains(this.person3));
        assert (!found.contains(this.person4)) : "This should not contain object person4";
        this.person4 = new Person();
        this.person4.setName("Mighty Goat");
        this.person4.setBlurb("Also eats grass");
        this.person4.setAge(28);
        this.cache.put((Object)"mighty", (Object)this.person4);
        found = cacheQuery.execute().list();
        assert (found.size() == 3) : "Size of list should be 3";
        assert (found.contains(this.person2));
        assert (found.contains(this.person3));
        assert (found.contains(this.person4)) : "This should now contain object person4";
    }

    public void testQueryingRangeAboveWithLimit() throws ParseException {
        this.loadTestingData();
        Query<Person> cacheQuery = this.createQuery("age:[31 to *]");
        List found = cacheQuery.execute().list();
        AssertJUnit.assertEquals((int)0, (int)found.size());
        cacheQuery = this.createQuery("age:[20 to *]");
        found = cacheQuery.execute().list();
        AssertJUnit.assertEquals((int)3, (int)found.size());
        assert (found.contains(this.person1));
        assert (found.contains(this.person2));
        assert (found.contains(this.person3));
        assert (!found.contains(this.person4)) : "This should not contain object person4";
        this.person4 = new Person();
        this.person4.setName("Mighty Goat");
        this.person4.setBlurb("Also eats grass");
        this.person4.setAge(28);
        this.cache.put((Object)"mighty", (Object)this.person4);
        found = cacheQuery.execute().list();
        assert (found.size() == 4) : "Size of list should be 3";
        assert (found.contains(this.person1));
        assert (found.contains(this.person2));
        assert (found.contains(this.person3));
        assert (found.contains(this.person4)) : "This should now contain object person4";
    }

    public void testQueryingRange() throws ParseException {
        this.loadTestingData();
        Query<Person> cacheQuery = this.createQuery("age:[21 TO 29]");
        List found = cacheQuery.execute().list();
        AssertJUnit.assertEquals((int)1, (int)found.size());
        assert (found.contains(this.person3));
        assert (!found.contains(this.person4)) : "This should not contain object person4";
        this.person4 = new Person();
        this.person4.setName("Mighty Goat");
        this.person4.setBlurb("Mighty Goat also eats grass");
        this.person4.setAge(28);
        this.cache.put((Object)"mighty", (Object)this.person4);
        found = cacheQuery.execute().list();
        assert (found.size() == 2) : "Size of list should be 3";
        assert (found.contains(this.person3));
        assert (found.contains(this.person4)) : "This should now contain object person4";
    }

    public void testQueryingRangeWithLimits() throws ParseException {
        this.loadTestingData();
        Query<Person> cacheQuery = this.createQuery("age:[20 to 30]");
        List found = cacheQuery.execute().list();
        AssertJUnit.assertEquals((int)3, (int)found.size());
        assert (found.contains(this.person1));
        assert (found.contains(this.person2));
        assert (found.contains(this.person3));
        assert (!found.contains(this.person4)) : "This should not contain object person4";
        this.person4 = new Person();
        this.person4.setName("Mighty Goat");
        this.person4.setBlurb("Mighty Goat also eats grass");
        this.person4.setAge(28);
        this.cache.put((Object)"mighty", (Object)this.person4);
        found = cacheQuery.execute().list();
        assert (found.size() == 4) : "Size of list should be 3";
        assert (found.contains(this.person1));
        assert (found.contains(this.person2));
        assert (found.contains(this.person3));
        assert (found.contains(this.person4)) : "This should now contain object person4";
        Person person5 = new Person();
        person5.setName("ANother Goat");
        person5.setBlurb("Some other goat should eat grass.");
        person5.setAge(31);
        this.cache.put((Object)"anotherGoat", (Object)person5);
        found = cacheQuery.execute().list();
        assert (found.size() == 4) : "Size of list should be 3";
        assert (found.contains(this.person1));
        assert (found.contains(this.person2));
        assert (found.contains(this.person3));
        assert (found.contains(this.person4)) : "This should now contain object person4";
    }

    public void testQueryingRangeWithLimitsAndExclusions() throws ParseException {
        this.loadTestingData();
        Query<Person> cacheQuery = this.createQuery("age:[21 to 30]");
        List found = cacheQuery.execute().list();
        AssertJUnit.assertEquals((int)2, (int)found.size());
        assert (found.contains(this.person2));
        assert (found.contains(this.person3));
        assert (!found.contains(this.person4)) : "This should not contain object person4";
        this.person4 = new Person();
        this.person4.setName("Mighty Goat");
        this.person4.setBlurb("Mighty Goat also eats grass");
        this.person4.setAge(28);
        this.cache.put((Object)"mighty", (Object)this.person4);
        found = cacheQuery.execute().list();
        AssertJUnit.assertEquals((int)3, (int)found.size());
        assert (found.contains(this.person2));
        assert (found.contains(this.person3));
        assert (found.contains(this.person4)) : "This should now contain object person4";
        Person person5 = new Person();
        person5.setName("ANother Goat");
        person5.setBlurb("Some other goat should eat grass.");
        person5.setAge(31);
        this.cache.put((Object)"anotherGoat", (Object)person5);
        found = cacheQuery.execute().list();
        AssertJUnit.assertEquals((int)3, (int)found.size());
        assert (found.contains(this.person2));
        assert (found.contains(this.person3));
        assert (found.contains(this.person4)) : "This should now contain object person4";
        cacheQuery = this.createQuery("age:[20 to 29]");
        found = cacheQuery.execute().list();
        AssertJUnit.assertEquals((int)3, (int)found.size());
        assert (found.contains(this.person1));
        assert (found.contains(this.person3));
        assert (found.contains(this.person4));
    }

    public void testQueryingRangeForDatesWithLimitsAndExclusions() throws ParseException {
        this.loadTestingData();
        Query<Person> cacheQuery = this.createQuery("dateOfGraduation:['20020506' to '20120630']");
        List found = cacheQuery.execute().list();
        AssertJUnit.assertEquals((int)2, (int)found.size());
        assert (found.contains(this.person1));
        assert (found.contains(this.person2));
        this.person4 = new Person("Mighty Goat", "Mighty Goat also eats grass", 28, this.makeDate("2007-06-15"));
        this.cache.put((Object)"mighty", (Object)this.person4);
        found = cacheQuery.execute().list();
        AssertJUnit.assertEquals((int)3, (int)found.size());
        assert (found.contains(this.person1));
        assert (found.contains(this.person2));
        assert (found.contains(this.person4)) : "This should now contain object person4";
        Person person5 = new Person("Another Goat", "Some other goat should eat grass.", 31, this.makeDate("2012-07-05"));
        this.cache.put((Object)"anotherGoat", (Object)person5);
        found = cacheQuery.execute().list();
        AssertJUnit.assertEquals((int)3, (int)found.size());
        assert (found.contains(this.person1));
        assert (found.contains(this.person2));
        assert (found.contains(this.person4));
        cacheQuery = this.createQuery("dateOfGraduation:['20020505' to '20120609']");
        found = cacheQuery.execute().list();
        AssertJUnit.assertEquals((int)3, (int)found.size());
        assert (found.contains(this.person2));
        assert (found.contains(this.person3));
        assert (found.contains(this.person4));
    }

    protected void loadTestingData() throws ParseException {
        this.person1 = new Person();
        this.person1.setName("Navin Surtani");
        this.person1.setBlurb("Likes playing WoW");
        this.person1.setAge(20);
        this.person1.setDateOfGraduation(this.makeDate("2012-06-10"));
        this.person2 = new Person();
        this.person2.setName("Big Goat");
        this.person2.setBlurb("Eats grass");
        this.person2.setAge(30);
        this.person2.setDateOfGraduation(this.makeDate("2002-07-05"));
        this.person3 = new Person();
        this.person3.setName("Mini Goat");
        this.person3.setBlurb("Eats cheese");
        this.person3.setAge(25);
        this.person3.setDateOfGraduation(this.makeDate("2002-05-05"));
        this.cache.put((Object)this.key1, (Object)this.person1);
        this.cache.put((Object)this.key2, (Object)this.person2);
        this.cache.put((Object)this.key3, (Object)this.person3);
    }

    protected Date makeDate(String dateStr) throws ParseException {
        return this.DATE_FORMAT.parse(dateStr);
    }
}

