/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.config;

import org.infinispan.Cache;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.backend.QueryInterceptor;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.config.CacheModeTest")
public class CacheModeTest
extends AbstractInfinispanTest {
    public void testLocal() {
        this.doTest(CacheMode.LOCAL);
    }

    public void testReplicated() {
        this.doTest(CacheMode.REPL_SYNC);
    }

    @Test(expectedExceptions={CacheConfigurationException.class}, expectedExceptionsMessageRegExp="ISPN(\\d)*: Indexing can not be enabled on caches in Invalidation mode")
    public void testInvalidated() {
        this.doTest(CacheMode.INVALIDATION_SYNC);
    }

    public void testDistributed() {
        this.doTest(CacheMode.DIST_SYNC);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTest(CacheMode m) {
        EmbeddedCacheManager cc = null;
        try {
            cc = TestCacheManagerFactory.createCacheManager((CacheMode)m, (boolean)true);
            QueryInterceptor queryInterceptor = (QueryInterceptor)TestingUtil.findInterceptor((Cache)cc.getCache(), QueryInterceptor.class);
            AssertJUnit.assertNotNull((String)"Didn't find a query interceptor in the chain!!", (Object)queryInterceptor);
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers((CacheContainer[])new CacheContainer[]{cc});
            throw throwable;
        }
        TestingUtil.killCacheManagers((CacheContainer[])new CacheContainer[]{cc});
    }
}

