/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.distributed;

import java.util.concurrent.CompletionStage;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.context.Flag;
import org.infinispan.query.Search;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.queries.faceting.Car;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.util.concurrent.CompletionStages;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.distributed.DegeneratedClusterMassIndexingTest")
public class DegeneratedClusterMassIndexingTest
extends MultipleCacheManagersTest {
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder cfg = DegeneratedClusterMassIndexingTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.REPL_SYNC, (boolean)true);
        cfg.indexing().enable().addIndexedEntity(Car.class).addProperty("default.directory_provider", "local-heap").addProperty("lucene_version", "LUCENE_CURRENT");
        this.addClusterEnabledCacheManager(cfg);
        this.waitForClusterToForm();
    }

    public void testReindexing() {
        AdvancedCache cache = this.cache(0).getAdvancedCache().withFlags(Flag.SKIP_INDEXING);
        cache.put((Object)"car1", (Object)new Car("ford", "white", 300));
        cache.put((Object)"car2", (Object)new Car("ford", "blue", 300));
        cache.put((Object)"car3", (Object)new Car("ford", "red", 300));
        QueryFactory queryFactory = Search.getQueryFactory((Cache)cache);
        String q = String.format("FROM %s where make:'ford'", Car.class.getName());
        Query query = queryFactory.create(q);
        AssertJUnit.assertEquals((long)0L, (long)query.execute().hitCount().orElse(-1L));
        CompletionStages.join((CompletionStage)Search.getIndexer((Cache)cache).run());
        AssertJUnit.assertEquals((long)3L, (long)query.execute().hitCount().orElse(-1L));
    }
}

