/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.distributed;

import java.util.concurrent.CompletionStage;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.query.Indexer;
import org.infinispan.query.Search;
import org.infinispan.query.distributed.DistributedMassIndexingTest;
import org.infinispan.query.helper.StaticTestingErrorHandler;
import org.infinispan.query.queries.faceting.Car;
import org.infinispan.query.test.QueryTestSCI;
import org.infinispan.util.concurrent.CompletionStages;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.distributed.ReplRamMassIndexingTest")
public class ReplRamMassIndexingTest
extends DistributedMassIndexingTest {
    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder cacheCfg = ReplRamMassIndexingTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.REPL_SYNC, (boolean)false);
        cacheCfg.indexing().enable().addIndexedEntity(Car.class).addProperty("hibernate.search.default.directory_provider", "local-heap").addProperty("hibernate.search.default.exclusive_index_use", "true").addProperty("error_handler", StaticTestingErrorHandler.class.getName()).addProperty("lucene_version", "LUCENE_CURRENT").clustering().hash().numSegments(30);
        cacheCfg.clustering().stateTransfer().fetchInMemoryState(true);
        this.createClusteredCaches(3, QueryTestSCI.INSTANCE, cacheCfg);
        this.waitForClusterToForm(this.getDefaultCacheName());
    }

    @Override
    public void testReindexing() throws Exception {
        int NUM_CARS = 100;
        for (int i = 0; i < 100; ++i) {
            this.cache(i % 3).put((Object)("car" + i), (Object)new Car("skoda", "white", 42));
        }
        for (Cache cache : this.caches()) {
            Assert.assertEquals((int)cache.size(), (int)100);
            this.verifyFindsCar(cache, 100, "skoda");
        }
        this.rebuildIndexes();
        for (int i = 0; i < 100; ++i) {
            String key = "car" + i;
            for (Cache cache : this.caches()) {
                Assert.assertNotNull((Object)cache.get((Object)key));
            }
        }
        this.verifyFindsCar(100, "skoda");
    }

    @Override
    protected void rebuildIndexes() {
        for (Cache cache : this.caches()) {
            Indexer indexer = Search.getIndexer((Cache)cache);
            this.eventually(() -> !indexer.isRunning());
            CompletionStages.join((CompletionStage)indexer.run());
        }
    }
}

